/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceOrderConfiguration"}, immediate=true, service={CheckGuestCommerceOrdersMessageListener.class})
public class CheckGuestCommerceOrdersMessageListener
extends BaseMessageListener {
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        this._commerceOrderConfiguration = (CommerceOrderConfiguration)ConfigurableUtil.createConfigurable(CommerceOrderConfiguration.class, properties);
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._commerceOrderConfiguration.checkInterval(), TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        int deleteInterval = this._commerceOrderConfiguration.deleteInterval();
        Date createDate = new Date(System.currentTimeMillis() - (long)deleteInterval * 60000L);
        this._commerceOrderLocalService.deleteCommerceOrdersByAccountId(-1L, createDate, 2);
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

