/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.impl.CommerceCountryImpl;
import com.liferay.commerce.service.persistence.CommerceCountryFinder;
import com.liferay.commerce.service.persistence.impl.CommerceCountryFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceCountryFinderImpl
extends CommerceCountryFinderBaseImpl
implements CommerceCountryFinder {
    public static final String FIND_BY_COMMERCE_WAREHOUSES = CommerceCountryFinder.class.getName() + ".findByCommerceInventoryWarehouses";
    public static final String FIND_BY_COMMERCE_CHANNEL = CommerceCountryFinder.class.getName() + ".findByCommerceChannel";
    private static final String _ACTIVE_SQL = "AND (CIWarehouse.active_ = [$TRUE$])";
    private static final String _ALL_SQL = "[$ALL$]";
    private static final String _BILLING_ALLOWED_SQL = "AND (CommerceCountry.billingAllowed = [$TRUE$])";
    private static final String _BILLING_SQL = "[$BILLING$]";
    private static final String _SHIPPING_ALLOWED_SQL = "AND (CommerceCountry.shippingAllowed = [$TRUE$])";
    private static final String _SHIPPING_SQL = "[$SHIPPING$]";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public List<CommerceCountry> findByCommerceInventoryWarehouses(long companyId, boolean all) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_COMMERCE_WAREHOUSES);
            sql = all ? StringUtil.replace((String)sql, (String)_ALL_SQL, (String)"") : StringUtil.replace((String)sql, (String)_ALL_SQL, (String)_ACTIVE_SQL);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceCountry", CommerceCountryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceCountry> findByCommerceChannel(long commerceChannelId, boolean shippingAllowed, boolean billingAllowed, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_COMMERCE_CHANNEL);
            sql = billingAllowed ? StringUtil.replace((String)sql, (String)_BILLING_SQL, (String)_BILLING_ALLOWED_SQL) : StringUtil.replace((String)sql, (String)_BILLING_SQL, (String)"");
            sql = shippingAllowed ? StringUtil.replace((String)sql, (String)_SHIPPING_SQL, (String)_SHIPPING_ALLOWED_SQL) : StringUtil.replace((String)sql, (String)_SHIPPING_SQL, (String)"");
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceCountry", CommerceCountryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(ClassNameLocalServiceUtil.getClassNameId(CommerceCountry.class));
            qPos.add(commerceChannelId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

