/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.Dimensions;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={CommerceShippingHelper.class})
public class CommerceShippingHelperImpl
implements CommerceShippingHelper {
    public Dimensions getDimensions(CPInstance cpInstance) {
        if (cpInstance == null) {
            return new Dimensions(0.0, 0.0, 0.0);
        }
        return new Dimensions(cpInstance.getWidth(), cpInstance.getHeight(), cpInstance.getDepth());
    }

    public Dimensions getDimensions(List<CommerceOrderItem> commerceOrderItems) throws PortalException {
        double width;
        CommerceOrderItem commerceOrderItem;
        if (commerceOrderItems.size() == 1 && (commerceOrderItem = commerceOrderItems.get(0)).getQuantity() == 1) {
            return this.getDimensions(commerceOrderItem.fetchCPInstance());
        }
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        double maxDepth = 0.0;
        double volume = 0.0;
        for (CommerceOrderItem commerceOrderItem2 : commerceOrderItems) {
            CPDefinition cpDefinition = commerceOrderItem2.getCPDefinition();
            if (!cpDefinition.isShippable() || cpDefinition.isFreeShipping()) continue;
            Dimensions dimensions = this.getDimensions(commerceOrderItem2.fetchCPInstance());
            double width2 = dimensions.getWidth();
            double height = dimensions.getHeight();
            double depth = dimensions.getDepth();
            maxWidth = Math.max(maxWidth, width2);
            maxHeight = Math.max(maxHeight, height);
            maxDepth = Math.max(maxDepth, depth);
            volume += width2 * height * depth * (double)commerceOrderItem2.getQuantity();
        }
        double height = width = Math.cbrt(volume);
        double depth = width;
        width = Math.max(maxWidth, width);
        height = Math.max(maxHeight, height);
        depth = Math.max(maxDepth, depth);
        return new Dimensions(width, height, depth);
    }

    public double getWeight(CPInstance cpInstance) {
        if (cpInstance == null) {
            return 0.0;
        }
        return cpInstance.getWeight();
    }

    public double getWeight(List<CommerceOrderItem> commerceOrderItems) throws PortalException {
        double weight = 0.0;
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
            if (!cpDefinition.isShippable() || cpDefinition.isFreeShipping()) continue;
            weight += this.getWeight(commerceOrderItem.fetchCPInstance()) * (double)commerceOrderItem.getQuantity();
        }
        return weight;
    }

    public boolean isFreeShipping(CommerceOrder commerceOrder) throws PortalException {
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
            if (cpDefinition.isFreeShipping()) continue;
            return false;
        }
        return true;
    }

    public boolean isShippable(CommerceOrder commerceOrder) throws PortalException {
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
            if (!cpDefinition.isShippable()) continue;
            return true;
        }
        return false;
    }
}

