/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.discount.application.strategy.CommerceDiscountApplicationStrategy;
import com.liferay.commerce.internal.price.BaseCommerceProductPriceCalculation;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.price.list.discovery.CommercePriceListDiscovery;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.pricing.modifier.CommercePriceModifierHelper;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CommerceProductPriceCalculationV2Impl
extends BaseCommerceProductPriceCalculation {
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final int _SCALE = 10;
    private static final Log _log = LogFactoryUtil.getLog(CommerceProductPriceCalculationV2Impl.class);
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private final Map<String, CommerceDiscountApplicationStrategy> _commerceDiscountApplicationStrategyMap;
    private final CommerceDiscountCalculation _commerceDiscountCalculation;
    private final CommercePriceEntryLocalService _commercePriceEntryLocalService;
    private final Map<String, CommercePriceListDiscovery> _commercePriceListDiscoveryMap;
    private final CommercePriceListLocalService _commercePriceListLocalService;
    private final CommercePriceModifierHelper _commercePriceModifierHelper;
    private final CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    private final ConfigurationProvider _configurationProvider;

    public CommerceProductPriceCalculationV2Impl(CommerceChannelLocalService commerceChannelLocalService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceDiscountCalculation commerceDiscountCalculation, CommerceMoneyFactory commerceMoneyFactory, CommercePriceEntryLocalService commercePriceEntryLocalService, CommercePriceListLocalService commercePriceListLocalService, CommercePriceModifierHelper commercePriceModifierHelper, CommerceTierPriceEntryLocalService commerceTierPriceEntryLocalService, CommerceTaxCalculation commerceTaxCalculation, ConfigurationProvider configurationProvider, CPDefinitionOptionRelLocalService cpDefinitionOptionRelLocalService, CPInstanceLocalService cpInstanceLocalService, Map<String, CommerceDiscountApplicationStrategy> commerceDiscountApplicationStrategyMap, Map<String, CommercePriceListDiscovery> commercePriceListDiscoveryMap) {
        super(commerceMoneyFactory, commerceTaxCalculation, cpDefinitionOptionRelLocalService, cpInstanceLocalService);
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceDiscountCalculation = commerceDiscountCalculation;
        this._commercePriceEntryLocalService = commercePriceEntryLocalService;
        this._commercePriceListLocalService = commercePriceListLocalService;
        this._commercePriceModifierHelper = commercePriceModifierHelper;
        this._commerceTierPriceEntryLocalService = commerceTierPriceEntryLocalService;
        this._configurationProvider = configurationProvider;
        this._commerceDiscountApplicationStrategyMap = commerceDiscountApplicationStrategyMap;
        this._commercePriceListDiscoveryMap = commercePriceListDiscoveryMap;
    }

    public CommerceMoney getBasePrice(long cpInstanceId, CommerceCurrency commerceCurrency) throws PortalException {
        return this.commerceMoneyFactory.create(commerceCurrency, this._getBasePrice(cpInstanceId, commerceCurrency, "price-list"));
    }

    public CommerceMoney getBasePromoPrice(long cpInstanceId, CommerceCurrency commerceCurrency) throws PortalException {
        return this.commerceMoneyFactory.create(commerceCurrency, this._getBasePrice(cpInstanceId, commerceCurrency, "promotion"));
    }

    public CommerceProductPrice getCommerceProductPrice(CommerceProductPriceRequest commerceProductPriceRequest) throws PortalException {
        CommerceMoney discountAmountMoney;
        CommerceDiscountValue commerceDiscountValue;
        long cpInstanceId = commerceProductPriceRequest.getCpInstanceId();
        int quantity = commerceProductPriceRequest.getQuantity();
        CommerceContext commerceContext = commerceProductPriceRequest.getCommerceContext();
        long commercePriceListId = this._getCommercePriceListId(cpInstanceId, commerceContext);
        CommerceMoney unitPriceMoney = this._getUnitPrice(commercePriceListId, cpInstanceId, quantity, commerceContext);
        BigDecimal finalPrice = unitPriceMoney.getPrice();
        long commercePromoPriceListId = this._getCommercePromoPriceListId(cpInstanceId, commerceContext);
        CommerceMoney promoPriceMoney = this._getPromoPrice(commercePromoPriceListId, cpInstanceId, quantity, commerceContext);
        BigDecimal unitPrice = unitPriceMoney.getPrice();
        BigDecimal promoPrice = promoPriceMoney.getPrice();
        if (promoPrice != null && promoPrice.compareTo(BigDecimal.ZERO) > 0 && promoPrice.compareTo(unitPrice) <= 0) {
            finalPrice = promoPriceMoney.getPrice();
            commercePriceListId = commercePromoPriceListId;
        }
        BigDecimal[] updatedPrices = this.getUpdatedPrices(unitPrice, promoPrice, finalPrice, commerceContext, commerceProductPriceRequest.getCommerceOptionValues());
        finalPrice = updatedPrices[2];
        BigDecimal finalPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, finalPrice, false, commerceContext);
        boolean discountsTargetNetPrice = true;
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel != null) {
            discountsTargetNetPrice = commerceChannel.isDiscountsTargetNetPrice();
        }
        if (discountsTargetNetPrice) {
            commerceDiscountValue = this._getCommerceDiscountValue(cpInstanceId, commercePriceListId, quantity, finalPrice, commerceContext);
            finalPrice = finalPrice.multiply(BigDecimal.valueOf(quantity));
            if (commerceDiscountValue != null) {
                discountAmountMoney = commerceDiscountValue.getDiscountAmount();
                finalPrice = finalPrice.subtract(discountAmountMoney.getPrice());
            }
            finalPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, finalPrice, false, commerceContext);
        } else {
            commerceDiscountValue = this._getCommerceDiscountValue(cpInstanceId, commercePriceListId, quantity, finalPriceWithTaxAmount, commerceContext);
            finalPriceWithTaxAmount = finalPriceWithTaxAmount.multiply(BigDecimal.valueOf(quantity));
            if (commerceDiscountValue != null) {
                discountAmountMoney = commerceDiscountValue.getDiscountAmount();
                finalPriceWithTaxAmount = finalPriceWithTaxAmount.subtract(discountAmountMoney.getPrice());
            }
            finalPrice = this.getConvertedPrice(cpInstanceId, finalPriceWithTaxAmount, true, commerceContext);
        }
        CommerceProductPriceImpl commerceProductPriceImpl = new CommerceProductPriceImpl();
        commerceProductPriceImpl.setCommercePriceListId(commercePriceListId);
        commerceProductPriceImpl.setUnitPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), updatedPrices[0]));
        commerceProductPriceImpl.setUnitPromoPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), updatedPrices[1]));
        commerceProductPriceImpl.setQuantity(quantity);
        if (discountsTargetNetPrice) {
            commerceProductPriceImpl.setCommerceDiscountValue(commerceDiscountValue);
        } else {
            CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
            commerceProductPriceImpl.setCommerceDiscountValue(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(commerceDiscountValue, updatedPrices[2].multiply(BigDecimal.valueOf(quantity)), finalPrice, this.commerceMoneyFactory, RoundingMode.valueOf(commerceCurrency.getRoundingMode())));
        }
        commerceProductPriceImpl.setFinalPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPrice));
        if (commerceProductPriceRequest.isCalculateTax()) {
            this.setCommerceProductPriceWithTaxAmount(cpInstanceId, finalPriceWithTaxAmount, commerceProductPriceImpl, commerceContext, commerceDiscountValue, discountsTargetNetPrice);
        }
        return commerceProductPriceImpl;
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        long commercePromoPriceListId;
        long commercePriceListId;
        boolean calculateTax = false;
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel != null) {
            calculateTax = Objects.equals(commerceChannel.getPriceDisplayType(), "tax-included");
        }
        if ((commercePriceListId = this._getCommercePriceListId(cpInstanceId, commerceContext)) > 0L) {
            CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
            boolean bl = calculateTax = calculateTax || !commercePriceList.isNetPrice();
        }
        if ((commercePromoPriceListId = this._getCommercePromoPriceListId(cpInstanceId, commerceContext)) > 0L) {
            CommercePriceList commercePromotion = this._commercePriceListLocalService.getCommercePriceList(commercePromoPriceListId);
            calculateTax = calculateTax || !commercePromotion.isNetPrice();
        }
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCpInstanceId(cpInstanceId);
        commerceProductPriceRequest.setQuantity(quantity);
        commerceProductPriceRequest.setSecure(secure);
        commerceProductPriceRequest.setCommerceContext(commerceContext);
        commerceProductPriceRequest.setCommerceOptionValues(null);
        commerceProductPriceRequest.setCalculateTax(calculateTax);
        return this.getCommerceProductPrice(commerceProductPriceRequest);
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceProductPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceProductPrice commerceProductPrice = this.getCommerceProductPrice(cpInstanceId, quantity, commerceContext);
        if (commerceProductPrice == null) {
            return null;
        }
        return commerceProductPrice.getFinalPrice();
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getFinalPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getPromoPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        long commercePromoPriceListId = this._getCommercePromoPriceListId(cpInstanceId, commerceContext);
        return this._getPromoPrice(commercePromoPriceListId, cpInstanceId, quantity, commerceContext);
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal maxPrice = BigDecimal.ZERO;
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (maxPrice.compareTo(cpInstanceCommerceMoney.getPrice()) >= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            maxPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMaxPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal minPrice = BigDecimal.ZERO;
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (commerceMoney != null && minPrice.compareTo(cpInstanceCommerceMoney.getPrice()) <= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            minPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMinPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        long commercePriceListId = this._getCommercePriceListId(cpInstanceId, commerceContext);
        return this._getUnitPrice(commercePriceListId, cpInstanceId, quantity, commerceContext);
    }

    private CommerceDiscountValue _calculateCommerceDiscountValue(BigDecimal[] values, int quantity, BigDecimal finalPrice, CommerceContext commerceContext) throws PortalException {
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy = this._getCommerceDiscountApplicationStrategy();
        BigDecimal discountedAmount = commerceDiscountApplicationStrategy.applyCommerceDiscounts(finalPrice, values);
        BigDecimal currentDiscountAmount = finalPrice.subtract(discountedAmount);
        currentDiscountAmount = currentDiscountAmount.setScale(10, roundingMode);
        CommerceMoney discountAmount = this.commerceMoneyFactory.create(commerceCurrency, currentDiscountAmount.multiply(new BigDecimal(quantity)));
        return new CommerceDiscountValue(0L, discountAmount, this._getDiscountPercentage(discountedAmount, finalPrice, roundingMode), values);
    }

    private BigDecimal _getBasePrice(long cpInstanceId, CommerceCurrency commerceCurrency, String commercePriceListType) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchCommerceCatalogBasePriceListByType(cpInstance.getGroupId(), commercePriceListType);
        if (commercePriceList == null) {
            return BigDecimal.ZERO;
        }
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid(), false);
        if (commercePriceEntry == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = commercePriceEntry.getPrice();
        CommerceCurrency priceListCurrency = commercePriceList.getCommerceCurrency();
        if (priceListCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(priceListCurrency.getRate(), RoundingMode.valueOf(priceListCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        return price;
    }

    private long _getBasePriceListId(CPInstance cpInstance) throws PortalException {
        CommerceCatalog commerceCatalog = cpInstance.getCommerceCatalog();
        CommercePriceList basePriceList = this._commercePriceListLocalService.fetchCommerceCatalogBasePriceList(commerceCatalog.getGroupId());
        if (basePriceList != null) {
            return basePriceList.getCommercePriceListId();
        }
        _log.error((Object)"There is no base price list configured for the current catalog");
        return 0L;
    }

    private CommerceDiscountApplicationStrategy _getCommerceDiscountApplicationStrategy() throws ConfigurationException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getSystemConfiguration(CommercePricingConfiguration.class);
        String commerceDiscountApplicationStrategy = commercePricingConfiguration.commerceDiscountApplicationStrategy();
        if (!this._commerceDiscountApplicationStrategyMap.containsKey(commerceDiscountApplicationStrategy)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No commerce discount application strategy specified for " + commerceDiscountApplicationStrategy));
            }
            return null;
        }
        return this._commerceDiscountApplicationStrategyMap.get(commerceDiscountApplicationStrategy);
    }

    private CommerceDiscountValue _getCommerceDiscountValue(long cpInstanceId, long commercePriceListId, int quantity, BigDecimal finalPrice, CommerceContext commerceContext) throws PortalException {
        if (finalPrice == null || finalPrice.compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), true);
        BigDecimal[] values = new BigDecimal[4];
        if (commercePriceEntry != null) {
            CommerceTierPriceEntry commerceTierPriceEntry;
            if (!commercePriceEntry.isHasTierPrice() && !commercePriceEntry.isDiscountDiscovery()) {
                values[0] = commercePriceEntry.getDiscountLevel1();
                values[1] = commercePriceEntry.getDiscountLevel2();
                values[2] = commercePriceEntry.getDiscountLevel3();
                values[3] = commercePriceEntry.getDiscountLevel4();
                return this._calculateCommerceDiscountValue(values, quantity, finalPrice, commerceContext);
            }
            if (commercePriceEntry.isBulkPricing() && (commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.findClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity)) != null && !commerceTierPriceEntry.isDiscountDiscovery()) {
                values[0] = commerceTierPriceEntry.getDiscountLevel1();
                values[1] = commerceTierPriceEntry.getDiscountLevel2();
                values[2] = commerceTierPriceEntry.getDiscountLevel3();
                values[3] = commerceTierPriceEntry.getDiscountLevel4();
                return this._calculateCommerceDiscountValue(values, quantity, finalPrice, commerceContext);
            }
        }
        return this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPrice, commerceContext);
    }

    private CommerceMoney _getCommerceMoney(long commercePriceListId, CommerceCurrency commerceCurrency, BigDecimal price) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CommerceCurrency priceListCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId());
        if (priceListCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(priceListCurrency.getRate(), RoundingMode.valueOf(priceListCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        if (price != null) {
            return this.commerceMoneyFactory.create(commerceCurrency, price);
        }
        return null;
    }

    private BigDecimal _getCommercePrice(long commercePriceListId, CommercePriceEntry commercePriceEntry, int quantity) throws PortalException {
        if (commercePriceEntry == null) {
            return null;
        }
        BigDecimal commercePrice = commercePriceEntry.getPrice();
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceEntry.getCommercePriceListId());
        CommercePriceList modifierCommercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CPInstance cpInstance = commercePriceEntry.getCPInstance();
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId());
        if (!commercePriceEntry.isHasTierPrice()) {
            if (commercePriceEntry.getCommercePriceListId() != commercePriceListId && commercePriceList.isNetPrice() == modifierCommercePriceList.isNetPrice()) {
                commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), commercePriceEntry.getPriceMoney(commerceCurrency.getCommerceCurrencyId()));
            }
            return commercePrice;
        }
        if (commercePriceEntry.isBulkPricing()) {
            commercePrice = commercePriceEntry.getPrice();
            CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.findClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity);
            if (commerceTierPriceEntry != null) {
                commercePrice = commerceTierPriceEntry.getPrice();
            }
            if (commercePriceEntry.getCommercePriceListId() != commercePriceListId && commercePriceList.isNetPrice() == modifierCommercePriceList.isNetPrice()) {
                commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), commerceTierPriceEntry.getPriceMoney(commerceCurrency.getCommerceCurrencyId()));
            }
            return commercePrice;
        }
        int totalTierCounter = 0;
        List commerceTierPriceEntries = this._commerceTierPriceEntryLocalService.findCommerceTierPriceEntries(commercePriceEntry.getCommercePriceEntryId(), quantity);
        if (commerceTierPriceEntries != null && !commerceTierPriceEntries.isEmpty()) {
            commercePrice = BigDecimal.ZERO;
            CommerceTierPriceEntry commerceTierPriceEntry0 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(0);
            int tierCounter = commerceTierPriceEntry0.getMinQuantity() - totalTierCounter - 1;
            BigDecimal currentPrice = commercePriceEntry.getPrice();
            currentPrice = currentPrice.multiply(BigDecimal.valueOf(tierCounter));
            commercePrice = commercePrice.add(currentPrice);
            totalTierCounter += tierCounter;
            for (int i = 0; i < commerceTierPriceEntries.size() - 1; ++i) {
                CommerceTierPriceEntry commerceTierPriceEntry1 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(i);
                CommerceTierPriceEntry commerceTierPriceEntry2 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(i + 1);
                tierCounter = commerceTierPriceEntry2.getMinQuantity() - totalTierCounter - 1;
                currentPrice = commerceTierPriceEntry1.getPrice();
                currentPrice = currentPrice.multiply(BigDecimal.valueOf(tierCounter));
                commercePrice = commercePrice.add(currentPrice);
                totalTierCounter += tierCounter;
            }
            totalTierCounter = quantity - totalTierCounter;
            CommerceTierPriceEntry commerceTierPriceEntry = (CommerceTierPriceEntry)commerceTierPriceEntries.get(commerceTierPriceEntries.size() - 1);
            currentPrice = commerceTierPriceEntry.getPrice();
            currentPrice = currentPrice.multiply(BigDecimal.valueOf(totalTierCounter));
            commercePrice = commercePrice.add(currentPrice);
            RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
            commercePrice = commercePrice.divide(BigDecimal.valueOf(quantity), 10, roundingMode);
        }
        if (commercePriceEntry.getCommercePriceListId() != commercePriceListId && commercePriceList.isNetPrice() == modifierCommercePriceList.isNetPrice()) {
            commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), this.commerceMoneyFactory.create(commerceCurrency, commercePrice));
        }
        return commercePrice;
    }

    private BigDecimal _getCommercePrice(long cpInstanceId, long commercePriceListId, CommerceMoney unitPriceMoney) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        BigDecimal commercePrice = null;
        if (commercePriceList != null) {
            CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
            commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), unitPriceMoney);
        }
        return commercePrice;
    }

    private CommercePriceList _getCommercePriceList(long cpInstanceId, CommerceContext commerceContext, String commercePriceListType) throws PortalException {
        CommercePriceListDiscovery commercePriceListDiscovery;
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        long commerceAccountId = 0L;
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
        }
        if ((commercePriceListDiscovery = this._getCommercePriceListDiscovery(commercePriceListType)) == null) {
            return null;
        }
        return commercePriceListDiscovery.getCommercePriceList(cpInstance.getGroupId(), commerceAccountId, commerceContext.getCommerceChannelId(), cpInstance.getCPInstanceUuid(), commercePriceListType);
    }

    private CommercePriceListDiscovery _getCommercePriceListDiscovery(String commercePriceListType) throws PortalException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getSystemConfiguration(CommercePricingConfiguration.class);
        String discoveryMethod = "hierarchy";
        if (commercePriceListType.equals("price-list")) {
            discoveryMethod = commercePricingConfiguration.commercePriceListDiscovery();
        } else if (commercePriceListType.equals("promotion")) {
            discoveryMethod = commercePricingConfiguration.commercePromotionDiscovery();
        }
        if (!this._commercePriceListDiscoveryMap.containsKey(discoveryMethod)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No commerce price list discovery specified for " + discoveryMethod));
            }
            return null;
        }
        return this._commercePriceListDiscoveryMap.get(discoveryMethod);
    }

    private long _getCommercePriceListId(long cpInstanceId, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance;
        CommercePriceEntry commercePriceEntry;
        CommercePriceList commercePriceList = this._getCommercePriceList(cpInstanceId, commerceContext, "price-list");
        long commercePriceListId = 0L;
        if (commercePriceList != null) {
            commercePriceListId = commercePriceList.getCommercePriceListId();
        }
        if ((commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, (cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId)).getCPInstanceUuid(), true)) != null) {
            return commercePriceEntry.getCommercePriceListId();
        }
        boolean hasCommercePriceModifiers = this._commercePriceModifierHelper.hasCommercePriceModifiers(commercePriceListId, cpInstance.getCPDefinitionId());
        if (hasCommercePriceModifiers) {
            return commercePriceListId;
        }
        return this._getBasePriceListId(cpInstance);
    }

    private long _getCommercePromoPriceListId(long cpInstanceId, CommerceContext commerceContext) throws PortalException {
        CommercePriceList commercePriceList = this._getCommercePriceList(cpInstanceId, commerceContext, "promotion");
        if (commercePriceList != null) {
            return commercePriceList.getCommercePriceListId();
        }
        return 0L;
    }

    private BigDecimal _getDiscountPercentage(BigDecimal discountedAmount, BigDecimal amount, RoundingMode roundingMode) {
        double actualPrice = discountedAmount.doubleValue();
        double originalPrice = amount.doubleValue();
        double percentage = actualPrice / originalPrice;
        BigDecimal discountPercentage = new BigDecimal(percentage);
        discountPercentage = discountPercentage.multiply(_ONE_HUNDRED);
        MathContext mathContext = new MathContext(discountPercentage.precision(), roundingMode);
        return _ONE_HUNDRED.subtract(discountPercentage, mathContext);
    }

    private CommerceMoney _getPromoPrice(long commercePriceListId, long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        if (commercePriceListId > 0L) {
            CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
            CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
            CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), true);
            if (commercePriceEntry != null) {
                BigDecimal promoPrice = this._getCommercePrice(commercePriceListId, commercePriceEntry, quantity);
                if (!commercePriceList.isNetPrice()) {
                    promoPrice = this.getConvertedPrice(cpInstance.getCPInstanceId(), promoPrice, true, commerceContext);
                }
                return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), promoPrice);
            }
            if (!this._commercePriceModifierHelper.hasCommercePriceModifiers(commercePriceListId, cpInstance.getCPDefinitionId())) {
                return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
            }
            CommerceMoney unitPrice = this.getUnitPrice(cpInstanceId, quantity, commerceContext.getCommerceCurrency(), false, commerceContext);
            BigDecimal promoPrice = this._getCommercePrice(cpInstanceId, commercePriceListId, unitPrice);
            if (!commercePriceList.isNetPrice()) {
                promoPrice = this.getConvertedPrice(cpInstance.getCPInstanceId(), promoPrice, true, commerceContext);
            }
            return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), promoPrice);
        }
        return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
    }

    private CommerceMoney _getUnitPrice(long commercePriceListId, long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        if (commercePriceListId == 0L) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
        }
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), true);
        if (commercePriceEntry == null) {
            CommercePriceEntry commerceBasePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(this._getBasePriceListId(cpInstance), cpInstance.getCPInstanceUuid(), false);
            if (commerceBasePriceEntry == null) {
                return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
            }
            BigDecimal unitPrice = this._getCommercePrice(commercePriceList.getCommercePriceListId(), commerceBasePriceEntry, quantity);
            if (!commercePriceList.isNetPrice()) {
                unitPrice = this.getConvertedPrice(cpInstance.getCPInstanceId(), unitPrice, true, commerceContext);
            }
            return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), unitPrice);
        }
        BigDecimal unitPrice = this._getCommercePrice(commercePriceList.getCommercePriceListId(), commercePriceEntry, quantity);
        if (!commercePriceList.isNetPrice()) {
            unitPrice = this.getConvertedPrice(cpInstance.getCPInstanceId(), unitPrice, true, commerceContext);
        }
        return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), unitPrice);
    }
}

