/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.NoSuchShipmentItemException;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.model.impl.CommerceShipmentItemImpl;
import com.liferay.commerce.model.impl.CommerceShipmentItemModelImpl;
import com.liferay.commerce.service.persistence.CommerceShipmentItemPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommerceShipmentItemPersistenceImpl
extends BasePersistenceImpl<CommerceShipmentItem>
implements CommerceShipmentItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceShipmentItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "commerceShipmentItem.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByCommerceShipment;
    private FinderPath _finderPathWithoutPaginationFindByCommerceShipment;
    private FinderPath _finderPathCountByCommerceShipment;
    private static final String _FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2 = "commerceShipmentItem.commerceShipmentId = ?";
    private FinderPath _finderPathWithPaginationFindByCommerceOrderItemId;
    private FinderPath _finderPathWithoutPaginationFindByCommerceOrderItemId;
    private FinderPath _finderPathCountByCommerceOrderItemId;
    private static final String _FINDER_COLUMN_COMMERCEORDERITEMID_COMMERCEORDERITEMID_2 = "commerceShipmentItem.commerceOrderItemId = ?";
    private FinderPath _finderPathWithPaginationFindByC_C;
    private FinderPath _finderPathWithoutPaginationFindByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_COMMERCESHIPMENTID_2 = "commerceShipmentItem.commerceShipmentId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_COMMERCEORDERITEMID_2 = "commerceShipmentItem.commerceOrderItemId = ?";
    private FinderPath _finderPathFetchByC_C_C;
    private FinderPath _finderPathCountByC_C_C;
    private static final String _FINDER_COLUMN_C_C_C_COMMERCESHIPMENTID_2 = "commerceShipmentItem.commerceShipmentId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_COMMERCEORDERITEMID_2 = "commerceShipmentItem.commerceOrderItemId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_COMMERCEINVENTORYWAREHOUSEID_2 = "commerceShipmentItem.commerceInventoryWarehouseId = ?";
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCESHIPMENTITEM = "SELECT commerceShipmentItem FROM CommerceShipmentItem commerceShipmentItem";
    private static final String _SQL_SELECT_COMMERCESHIPMENTITEM_WHERE_PKS_IN = "SELECT commerceShipmentItem FROM CommerceShipmentItem commerceShipmentItem WHERE commerceShipmentItemId IN (";
    private static final String _SQL_SELECT_COMMERCESHIPMENTITEM_WHERE = "SELECT commerceShipmentItem FROM CommerceShipmentItem commerceShipmentItem WHERE ";
    private static final String _SQL_COUNT_COMMERCESHIPMENTITEM = "SELECT COUNT(commerceShipmentItem) FROM CommerceShipmentItem commerceShipmentItem";
    private static final String _SQL_COUNT_COMMERCESHIPMENTITEM_WHERE = "SELECT COUNT(commerceShipmentItem) FROM CommerceShipmentItem commerceShipmentItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceShipmentItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceShipmentItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceShipmentItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentItemPersistenceImpl.class);

    public List<CommerceShipmentItem> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<CommerceShipmentItem> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<CommerceShipmentItem> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipmentItem commerceShipmentItem : list) {
                if (groupId == commerceShipmentItem.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipmentItem findByGroupId_First(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByGroupId_First(groupId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByGroupId_First(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        List<CommerceShipmentItem> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem findByGroupId_Last(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByGroupId_Last(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipmentItem> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem[] findByGroupId_PrevAndNext(long commerceShipmentItemId, long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.findByPrimaryKey(commerceShipmentItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem[] array = new CommerceShipmentItemImpl[]{this.getByGroupId_PrevAndNext(session, commerceShipmentItem, groupId, orderByComparator, true), commerceShipmentItem, this.getByGroupId_PrevAndNext(session, commerceShipmentItem, groupId, orderByComparator, false)};
            CommerceShipmentItem[] commerceShipmentItemArray = array;
            return commerceShipmentItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem getByGroupId_PrevAndNext(Session session, CommerceShipmentItem commerceShipmentItem, long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipmentItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipmentItem)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (CommerceShipmentItem commerceShipmentItem : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCESHIPMENTITEM_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId) {
        return this.findByCommerceShipment(commerceShipmentId, -1, -1, null);
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId, int start, int end) {
        return this.findByCommerceShipment(commerceShipmentId, start, end, null);
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findByCommerceShipment(commerceShipmentId, start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCommerceShipment;
                finderArgs = new Object[]{commerceShipmentId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCommerceShipment;
            finderArgs = new Object[]{commerceShipmentId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipmentItem commerceShipmentItem : list) {
                if (commerceShipmentId == commerceShipmentItem.getCommerceShipmentId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
            sb.append(_FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceShipmentId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipmentItem findByCommerceShipment_First(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByCommerceShipment_First(commerceShipmentId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceShipmentId=");
        sb.append(commerceShipmentId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByCommerceShipment_First(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        List<CommerceShipmentItem> list = this.findByCommerceShipment(commerceShipmentId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem findByCommerceShipment_Last(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByCommerceShipment_Last(commerceShipmentId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceShipmentId=");
        sb.append(commerceShipmentId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByCommerceShipment_Last(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        int count = this.countByCommerceShipment(commerceShipmentId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipmentItem> list = this.findByCommerceShipment(commerceShipmentId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem[] findByCommerceShipment_PrevAndNext(long commerceShipmentItemId, long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.findByPrimaryKey(commerceShipmentItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem[] array = new CommerceShipmentItemImpl[]{this.getByCommerceShipment_PrevAndNext(session, commerceShipmentItem, commerceShipmentId, orderByComparator, true), commerceShipmentItem, this.getByCommerceShipment_PrevAndNext(session, commerceShipmentItem, commerceShipmentId, orderByComparator, false)};
            CommerceShipmentItem[] commerceShipmentItemArray = array;
            return commerceShipmentItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem getByCommerceShipment_PrevAndNext(Session session, CommerceShipmentItem commerceShipmentItem, long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
        sb.append(_FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceShipmentId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipmentItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipmentItem)list.get(1);
        }
        return null;
    }

    public void removeByCommerceShipment(long commerceShipmentId) {
        for (CommerceShipmentItem commerceShipmentItem : this.findByCommerceShipment(commerceShipmentId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countByCommerceShipment(long commerceShipmentId) {
        FinderPath finderPath = this._finderPathCountByCommerceShipment;
        Object[] finderArgs = new Object[]{commerceShipmentId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCESHIPMENTITEM_WHERE);
            sb.append(_FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceShipmentId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipmentItem> findByCommerceOrderItemId(long commerceOrderItemId) {
        return this.findByCommerceOrderItemId(commerceOrderItemId, -1, -1, null);
    }

    public List<CommerceShipmentItem> findByCommerceOrderItemId(long commerceOrderItemId, int start, int end) {
        return this.findByCommerceOrderItemId(commerceOrderItemId, start, end, null);
    }

    public List<CommerceShipmentItem> findByCommerceOrderItemId(long commerceOrderItemId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findByCommerceOrderItemId(commerceOrderItemId, start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findByCommerceOrderItemId(long commerceOrderItemId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCommerceOrderItemId;
                finderArgs = new Object[]{commerceOrderItemId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCommerceOrderItemId;
            finderArgs = new Object[]{commerceOrderItemId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipmentItem commerceShipmentItem : list) {
                if (commerceOrderItemId == commerceShipmentItem.getCommerceOrderItemId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
            sb.append("commerceShipmentItem.commerceOrderItemId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderItemId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipmentItem findByCommerceOrderItemId_First(long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByCommerceOrderItemId_First(commerceOrderItemId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderItemId=");
        sb.append(commerceOrderItemId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByCommerceOrderItemId_First(long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        List<CommerceShipmentItem> list = this.findByCommerceOrderItemId(commerceOrderItemId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem findByCommerceOrderItemId_Last(long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByCommerceOrderItemId_Last(commerceOrderItemId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderItemId=");
        sb.append(commerceOrderItemId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByCommerceOrderItemId_Last(long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        int count = this.countByCommerceOrderItemId(commerceOrderItemId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipmentItem> list = this.findByCommerceOrderItemId(commerceOrderItemId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem[] findByCommerceOrderItemId_PrevAndNext(long commerceShipmentItemId, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.findByPrimaryKey(commerceShipmentItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem[] array = new CommerceShipmentItemImpl[]{this.getByCommerceOrderItemId_PrevAndNext(session, commerceShipmentItem, commerceOrderItemId, orderByComparator, true), commerceShipmentItem, this.getByCommerceOrderItemId_PrevAndNext(session, commerceShipmentItem, commerceOrderItemId, orderByComparator, false)};
            CommerceShipmentItem[] commerceShipmentItemArray = array;
            return commerceShipmentItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem getByCommerceOrderItemId_PrevAndNext(Session session, CommerceShipmentItem commerceShipmentItem, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
        sb.append("commerceShipmentItem.commerceOrderItemId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceOrderItemId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipmentItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipmentItem)list.get(1);
        }
        return null;
    }

    public void removeByCommerceOrderItemId(long commerceOrderItemId) {
        for (CommerceShipmentItem commerceShipmentItem : this.findByCommerceOrderItemId(commerceOrderItemId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countByCommerceOrderItemId(long commerceOrderItemId) {
        FinderPath finderPath = this._finderPathCountByCommerceOrderItemId;
        Object[] finderArgs = new Object[]{commerceOrderItemId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCESHIPMENTITEM_WHERE);
            sb.append("commerceShipmentItem.commerceOrderItemId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderItemId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipmentItem> findByC_C(long commerceShipmentId, long commerceOrderItemId) {
        return this.findByC_C(commerceShipmentId, commerceOrderItemId, -1, -1, null);
    }

    public List<CommerceShipmentItem> findByC_C(long commerceShipmentId, long commerceOrderItemId, int start, int end) {
        return this.findByC_C(commerceShipmentId, commerceOrderItemId, start, end, null);
    }

    public List<CommerceShipmentItem> findByC_C(long commerceShipmentId, long commerceOrderItemId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findByC_C(commerceShipmentId, commerceOrderItemId, start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findByC_C(long commerceShipmentId, long commerceOrderItemId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_C;
                finderArgs = new Object[]{commerceShipmentId, commerceOrderItemId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_C;
            finderArgs = new Object[]{commerceShipmentId, commerceOrderItemId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipmentItem commerceShipmentItem : list) {
                if (commerceShipmentId == commerceShipmentItem.getCommerceShipmentId() && commerceOrderItemId == commerceShipmentItem.getCommerceOrderItemId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
            sb.append("commerceShipmentItem.commerceShipmentId = ? AND ");
            sb.append("commerceShipmentItem.commerceOrderItemId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceShipmentId);
                queryPos.add(commerceOrderItemId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipmentItem findByC_C_First(long commerceShipmentId, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByC_C_First(commerceShipmentId, commerceOrderItemId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceShipmentId=");
        sb.append(commerceShipmentId);
        sb.append(", commerceOrderItemId=");
        sb.append(commerceOrderItemId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByC_C_First(long commerceShipmentId, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        List<CommerceShipmentItem> list = this.findByC_C(commerceShipmentId, commerceOrderItemId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem findByC_C_Last(long commerceShipmentId, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByC_C_Last(commerceShipmentId, commerceOrderItemId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceShipmentId=");
        sb.append(commerceShipmentId);
        sb.append(", commerceOrderItemId=");
        sb.append(commerceOrderItemId);
        sb.append("}");
        throw new NoSuchShipmentItemException(sb.toString());
    }

    public CommerceShipmentItem fetchByC_C_Last(long commerceShipmentId, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        int count = this.countByC_C(commerceShipmentId, commerceOrderItemId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipmentItem> list = this.findByC_C(commerceShipmentId, commerceOrderItemId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem[] findByC_C_PrevAndNext(long commerceShipmentItemId, long commerceShipmentId, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.findByPrimaryKey(commerceShipmentItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem[] array = new CommerceShipmentItemImpl[]{this.getByC_C_PrevAndNext(session, commerceShipmentItem, commerceShipmentId, commerceOrderItemId, orderByComparator, true), commerceShipmentItem, this.getByC_C_PrevAndNext(session, commerceShipmentItem, commerceShipmentId, commerceOrderItemId, orderByComparator, false)};
            CommerceShipmentItem[] commerceShipmentItemArray = array;
            return commerceShipmentItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem getByC_C_PrevAndNext(Session session, CommerceShipmentItem commerceShipmentItem, long commerceShipmentId, long commerceOrderItemId, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
        sb.append("commerceShipmentItem.commerceShipmentId = ? AND ");
        sb.append("commerceShipmentItem.commerceOrderItemId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipmentItem.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceShipmentId);
        queryPos.add(commerceOrderItemId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipmentItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipmentItem)list.get(1);
        }
        return null;
    }

    public void removeByC_C(long commerceShipmentId, long commerceOrderItemId) {
        for (CommerceShipmentItem commerceShipmentItem : this.findByC_C(commerceShipmentId, commerceOrderItemId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countByC_C(long commerceShipmentId, long commerceOrderItemId) {
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{commerceShipmentId, commerceOrderItemId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENTITEM_WHERE);
            sb.append("commerceShipmentItem.commerceShipmentId = ? AND ");
            sb.append("commerceShipmentItem.commerceOrderItemId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceShipmentId);
                queryPos.add(commerceOrderItemId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipmentItem findByC_C_C(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByC_C_C(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId);
        if (commerceShipmentItem == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("commerceShipmentId=");
            sb.append(commerceShipmentId);
            sb.append(", commerceOrderItemId=");
            sb.append(commerceOrderItemId);
            sb.append(", commerceInventoryWarehouseId=");
            sb.append(commerceInventoryWarehouseId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchShipmentItemException(sb.toString());
        }
        return commerceShipmentItem;
    }

    public CommerceShipmentItem fetchByC_C_C(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) {
        return this.fetchByC_C_C(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId, true);
    }

    public CommerceShipmentItem fetchByC_C_C(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, boolean useFinderCache) {
        CommerceShipmentItem commerceShipmentItem;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceShipmentItem && (commerceShipmentId != (commerceShipmentItem = (CommerceShipmentItem)result).getCommerceShipmentId() || commerceOrderItemId != commerceShipmentItem.getCommerceOrderItemId() || commerceInventoryWarehouseId != commerceShipmentItem.getCommerceInventoryWarehouseId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
            sb.append("commerceShipmentItem.commerceShipmentId = ? AND ");
            sb.append(_FINDER_COLUMN_C_C_C_COMMERCEORDERITEMID_2);
            sb.append(_FINDER_COLUMN_C_C_C_COMMERCEINVENTORYWAREHOUSEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceShipmentId);
                queryPos.add(commerceOrderItemId);
                queryPos.add(commerceInventoryWarehouseId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_C_C, finderArgs, (Object)list);
                    }
                } else {
                    CommerceShipmentItem commerceShipmentItem2 = (CommerceShipmentItem)list.get(0);
                    result = commerceShipmentItem2;
                    this.cacheResult(commerceShipmentItem2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByC_C_C, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceShipmentItem)result;
    }

    public CommerceShipmentItem removeByC_C_C(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.findByC_C_C(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId);
        return (CommerceShipmentItem)this.remove((BaseModel)commerceShipmentItem);
    }

    public int countByC_C_C(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) {
        FinderPath finderPath = this._finderPathCountByC_C_C;
        Object[] finderArgs = new Object[]{commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_COMMERCESHIPMENTITEM_WHERE);
            sb.append("commerceShipmentItem.commerceShipmentId = ? AND ");
            sb.append(_FINDER_COLUMN_C_C_C_COMMERCEORDERITEMID_2);
            sb.append(_FINDER_COLUMN_C_C_C_COMMERCEINVENTORYWAREHOUSEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceShipmentId);
                queryPos.add(commerceOrderItemId);
                queryPos.add(commerceInventoryWarehouseId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipmentItemPersistenceImpl() {
        this.setModelClass(CommerceShipmentItem.class);
    }

    public void cacheResult(CommerceShipmentItem commerceShipmentItem) {
        this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()), (Serializable)commerceShipmentItem);
        this.finderCache.putResult(this._finderPathFetchByC_C_C, new Object[]{commerceShipmentItem.getCommerceShipmentId(), commerceShipmentItem.getCommerceOrderItemId(), commerceShipmentItem.getCommerceInventoryWarehouseId()}, (Object)commerceShipmentItem);
        commerceShipmentItem.resetOriginalValues();
    }

    public void cacheResult(List<CommerceShipmentItem> commerceShipmentItems) {
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            if (this.entityCache.getResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey())) == null) {
                this.cacheResult(commerceShipmentItem);
                continue;
            }
            commerceShipmentItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceShipmentItemImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceShipmentItem commerceShipmentItem) {
        this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CommerceShipmentItemModelImpl)commerceShipmentItem, true);
    }

    public void clearCache(List<CommerceShipmentItem> commerceShipmentItems) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()));
            this.clearUniqueFindersCache((CommerceShipmentItemModelImpl)commerceShipmentItem, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceShipmentItemModelImpl commerceShipmentItemModelImpl) {
        Object[] args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId(), commerceShipmentItemModelImpl.getCommerceOrderItemId(), commerceShipmentItemModelImpl.getCommerceInventoryWarehouseId()};
        this.finderCache.putResult(this._finderPathCountByC_C_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_C_C, args, (Object)commerceShipmentItemModelImpl, false);
    }

    protected void clearUniqueFindersCache(CommerceShipmentItemModelImpl commerceShipmentItemModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId(), commerceShipmentItemModelImpl.getCommerceOrderItemId(), commerceShipmentItemModelImpl.getCommerceInventoryWarehouseId()};
            this.finderCache.removeResult(this._finderPathCountByC_C_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C_C, args);
        }
        if ((commerceShipmentItemModelImpl.getColumnBitmask() & this._finderPathFetchByC_C_C.getColumnBitmask()) != 0L) {
            args = new Object[]{commerceShipmentItemModelImpl.getOriginalCommerceShipmentId(), commerceShipmentItemModelImpl.getOriginalCommerceOrderItemId(), commerceShipmentItemModelImpl.getOriginalCommerceInventoryWarehouseId()};
            this.finderCache.removeResult(this._finderPathCountByC_C_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C_C, args);
        }
    }

    public CommerceShipmentItem create(long commerceShipmentItemId) {
        CommerceShipmentItemImpl commerceShipmentItem = new CommerceShipmentItemImpl();
        commerceShipmentItem.setNew(true);
        commerceShipmentItem.setPrimaryKey(commerceShipmentItemId);
        commerceShipmentItem.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceShipmentItem;
    }

    public CommerceShipmentItem remove(long commerceShipmentItemId) throws NoSuchShipmentItemException {
        return this.remove(Long.valueOf(commerceShipmentItemId));
    }

    public CommerceShipmentItem remove(Serializable primaryKey) throws NoSuchShipmentItemException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)session.get(CommerceShipmentItemImpl.class, primaryKey);
            if (commerceShipmentItem == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchShipmentItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceShipmentItem commerceShipmentItem2 = (CommerceShipmentItem)this.remove((BaseModel)commerceShipmentItem);
            return commerceShipmentItem2;
        }
        catch (NoSuchShipmentItemException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem removeImpl(CommerceShipmentItem commerceShipmentItem) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceShipmentItem)) {
                commerceShipmentItem = (CommerceShipmentItem)session.get(CommerceShipmentItemImpl.class, commerceShipmentItem.getPrimaryKeyObj());
            }
            if (commerceShipmentItem != null) {
                session.delete((Object)commerceShipmentItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceShipmentItem != null) {
            this.clearCache(commerceShipmentItem);
        }
        return commerceShipmentItem;
    }

    public CommerceShipmentItem updateImpl(CommerceShipmentItem commerceShipmentItem) {
        boolean isNew = commerceShipmentItem.isNew();
        if (!(commerceShipmentItem instanceof CommerceShipmentItemModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceShipmentItem.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceShipmentItem);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceShipmentItem proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceShipmentItem implementation " + commerceShipmentItem.getClass());
        }
        CommerceShipmentItemModelImpl commerceShipmentItemModelImpl = (CommerceShipmentItemModelImpl)commerceShipmentItem;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceShipmentItem.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceShipmentItem.setCreateDate(now);
            } else {
                commerceShipmentItem.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceShipmentItemModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceShipmentItem.setModifiedDate(now);
            } else {
                commerceShipmentItem.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceShipmentItem);
                commerceShipmentItem.setNew(false);
            } else {
                commerceShipmentItem = (CommerceShipmentItem)session.merge((Object)commerceShipmentItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommerceShipmentItemModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commerceShipmentItemModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByGroupId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId()};
            this.finderCache.removeResult(this._finderPathCountByCommerceShipment, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceShipment, args);
            args = new Object[]{commerceShipmentItemModelImpl.getCommerceOrderItemId()};
            this.finderCache.removeResult(this._finderPathCountByCommerceOrderItemId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderItemId, args);
            args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId(), commerceShipmentItemModelImpl.getCommerceOrderItemId()};
            this.finderCache.removeResult(this._finderPathCountByC_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commerceShipmentItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentItemModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{commerceShipmentItemModelImpl.getGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((commerceShipmentItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCommerceShipment.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentItemModelImpl.getOriginalCommerceShipmentId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceShipment, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceShipment, args);
                args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceShipment, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceShipment, args);
            }
            if ((commerceShipmentItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCommerceOrderItemId.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentItemModelImpl.getOriginalCommerceOrderItemId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceOrderItemId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderItemId, args);
                args = new Object[]{commerceShipmentItemModelImpl.getCommerceOrderItemId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceOrderItemId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderItemId, args);
            }
            if ((commerceShipmentItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentItemModelImpl.getOriginalCommerceShipmentId(), commerceShipmentItemModelImpl.getOriginalCommerceOrderItemId()};
                this.finderCache.removeResult(this._finderPathCountByC_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
                args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId(), commerceShipmentItemModelImpl.getCommerceOrderItemId()};
                this.finderCache.removeResult(this._finderPathCountByC_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
            }
        }
        this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()), (Serializable)commerceShipmentItem, false);
        this.clearUniqueFindersCache(commerceShipmentItemModelImpl, false);
        this.cacheUniqueFindersCache(commerceShipmentItemModelImpl);
        commerceShipmentItem.resetOriginalValues();
        return commerceShipmentItem;
    }

    public CommerceShipmentItem findByPrimaryKey(Serializable primaryKey) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByPrimaryKey(primaryKey);
        if (commerceShipmentItem == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchShipmentItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceShipmentItem;
    }

    public CommerceShipmentItem findByPrimaryKey(long commerceShipmentItemId) throws NoSuchShipmentItemException {
        return this.findByPrimaryKey(Long.valueOf(commerceShipmentItemId));
    }

    public CommerceShipmentItem fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)serializable;
        if (commerceShipmentItem == null) {
            Session session = null;
            try {
                session = this.openSession();
                commerceShipmentItem = (CommerceShipmentItem)session.get(CommerceShipmentItemImpl.class, primaryKey);
                if (commerceShipmentItem != null) {
                    this.cacheResult(commerceShipmentItem);
                } else {
                    this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commerceShipmentItem;
    }

    public CommerceShipmentItem fetchByPrimaryKey(long commerceShipmentItemId) {
        return this.fetchByPrimaryKey(Long.valueOf(commerceShipmentItemId));
    }

    public Map<Serializable, CommerceShipmentItem> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommerceShipmentItem> map = new HashMap<Serializable, CommerceShipmentItem>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommerceShipmentItem commerceShipmentItem = this.fetchByPrimaryKey(primaryKey);
            if (commerceShipmentItem != null) {
                map.put(primaryKey, commerceShipmentItem);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommerceShipmentItem)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (CommerceShipmentItem commerceShipmentItem : query.list()) {
                map.put(commerceShipmentItem.getPrimaryKeyObj(), commerceShipmentItem);
                this.cacheResult(commerceShipmentItem);
                uncachedPrimaryKeys.remove(commerceShipmentItem.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommerceShipmentItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceShipmentItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceShipmentItem> findAll(int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findAll(int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCESHIPMENTITEM);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCESHIPMENTITEM;
                sql = sql.concat(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceShipmentItem commerceShipmentItem : this.findAll()) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCESHIPMENTITEM);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceShipmentItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 24L);
        this._finderPathCountByGroupId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCommerceShipment = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCommerceShipment", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCommerceShipment = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCommerceShipment", new String[]{Long.class.getName()}, 20L);
        this._finderPathCountByCommerceShipment = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCommerceShipment", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCommerceOrderItemId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCommerceOrderItemId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCommerceOrderItemId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCommerceOrderItemId", new String[]{Long.class.getName()}, 18L);
        this._finderPathCountByCommerceOrderItemId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCommerceOrderItemId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByC_C = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 22L);
        this._finderPathCountByC_C = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathFetchByC_C_C = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()}, 7L);
        this._finderPathCountByC_C_C = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceShipmentItemImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

