/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.base.CommerceSubscriptionEntryServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;
import java.util.stream.Stream;

public class CommerceSubscriptionEntryServiceImpl
extends CommerceSubscriptionEntryServiceBaseImpl {
    @ServiceReference(type=CommerceChannelLocalService.class)
    private CommerceChannelLocalService _commerceChannelLocalService;

    public void deleteCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        this.commerceSubscriptionEntryLocalService.deleteCommerceSubscriptionEntry(commerceSubscriptionEntryId);
    }

    public CommerceSubscriptionEntry fetchCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        return this.commerceSubscriptionEntryLocalService.fetchCommerceSubscriptionEntry(commerceSubscriptionEntryId);
    }

    @Deprecated
    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(long companyId, long userId, int start, int end, OrderByComparator<CommerceSubscriptionEntry> orderByComparator) throws PortalException {
        if (userId != this.getUserId()) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        }
        return this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntries(companyId, userId, start, end, orderByComparator);
    }

    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(long companyId, long groupId, long userId, int start, int end, OrderByComparator<CommerceSubscriptionEntry> orderByComparator) throws PortalException {
        if (userId != this.getUserId()) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        }
        return this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntries(companyId, groupId, userId, start, end, orderByComparator);
    }

    @Deprecated
    public int getCommerceSubscriptionEntriesCount(long companyId, long userId) throws PortalException {
        if (userId != this.getUserId()) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        }
        return this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntriesCount(companyId, userId);
    }

    public int getCommerceSubscriptionEntriesCount(long companyId, long groupId, long userId) throws PortalException {
        if (userId != this.getUserId()) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        }
        return this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntriesCount(companyId, groupId, userId);
    }

    public BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(long companyId, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        List commerceChannels = this._commerceChannelLocalService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceSubscriptionEntryLocalService.searchCommerceSubscriptionEntries(companyId, commerceChannelGroupIds, maxSubscriptionCycles, subscriptionStatus, keywords, start, end, sort);
    }

    @Deprecated
    public BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(long companyId, long[] groupIds, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        return this.commerceSubscriptionEntryLocalService.searchCommerceSubscriptionEntries(companyId, groupIds, maxSubscriptionCycles, subscriptionStatus, keywords, start, end, sort);
    }

    public CommerceSubscriptionEntry updateCommerceSubscriptionEntry(long commerceSubscriptionEntryId, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsProperties, long maxSubscriptionCycles, int subscriptionStatus, int nextIterationDateMonth, int nextIterationDateDay, int nextIterationDateYear, int nextIterationDateHour, int nextIterationDateMinute, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsProperties, long deliveryMaxSubscriptionCycles, int deliverySubscriptionStatus, int deliveryNextIterationDateMonth, int deliveryNextIterationDateDay, int deliveryNextIterationDateYear, int deliveryNextIterationDateHour, int deliveryNextIterationDateMinute) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        return this.commerceSubscriptionEntryLocalService.updateCommerceSubscriptionEntry(commerceSubscriptionEntryId, subscriptionLength, subscriptionType, subscriptionTypeSettingsProperties, maxSubscriptionCycles, subscriptionStatus, nextIterationDateMonth, nextIterationDateDay, nextIterationDateYear, nextIterationDateHour, nextIterationDateMinute, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsProperties, deliveryMaxSubscriptionCycles, deliverySubscriptionStatus, deliveryNextIterationDateMonth, deliveryNextIterationDateDay, deliveryNextIterationDateYear, deliveryNextIterationDateHour, deliveryNextIterationDateMinute);
    }

    @Deprecated
    public CommerceSubscriptionEntry updateSubscriptionStatus(long commerceSubscriptionEntryId, int subscriptionStatus) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SUBSCRIPTIONS");
        return this.commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntryId, subscriptionStatus);
    }
}

