/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.base.CommerceShipmentServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class CommerceShipmentServiceImpl
extends CommerceShipmentServiceBaseImpl {
    @ServiceReference(type=CommerceChannelService.class)
    private CommerceChannelService _commerceChannelService;

    public CommerceShipment addCommerceShipment(long groupId, long commerceAccountId, long commerceAddressId, long commerceShippingMethodId, String commerceShippingOptionName, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.addCommerceShipment(groupId, commerceAccountId, commerceAddressId, commerceShippingMethodId, commerceShippingOptionName, serviceContext);
    }

    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.addCommerceShipment(commerceOrderId, serviceContext);
    }

    @Deprecated
    public void deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        this.deleteCommerceShipment(commerceShipmentId, false);
    }

    public void deleteCommerceShipment(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment, restoreStockQuantity);
    }

    public CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipments(commerceChannelGroupIds, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        if (commerceChannels.isEmpty()) {
            return Collections.emptyList();
        }
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipments(commerceChannelGroupIds, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipments(commerceChannelGroupIds, commerceAddressId, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus, int start, int end) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipments(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus, start, end);
    }

    public List<CommerceShipment> getCommerceShipmentsByOrderId(long commerceOrderId, int start, int end) {
        return this.commerceShipmentLocalService.getCommerceShipments(commerceOrderId, start, end);
    }

    public int getCommerceShipmentsCount(long companyId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        if (commerceChannels.isEmpty()) {
            return 0;
        }
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(commerceChannelGroupIds);
    }

    public int getCommerceShipmentsCount(long companyId, int status) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(commerceChannelGroupIds, status);
    }

    public int getCommerceShipmentsCount(long companyId, long commerceAddressId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(commerceChannelGroupIds, commerceAddressId);
    }

    public int getCommerceShipmentsCount(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus);
    }

    public int getCommerceShipmentsCountByOrderId(long commerceOrderId) {
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(commerceOrderId);
    }

    public CommerceShipment updateAddress(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateAddress(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber);
    }

    public CommerceShipment updateCarrierDetails(long commerceShipmentId, String carrier, String trackingNumber) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCarrierDetails(commerceShipmentId, carrier, trackingNumber);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public CommerceShipment updateExpectedDate(long commerceShipmentId, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateExpectedDate(commerceShipmentId, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public CommerceShipment updateShippingDate(long commerceShipmentId, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateShippingDate(commerceShipmentId, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute);
    }

    public CommerceShipment updateStatus(long commerceShipmentId, int status) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateStatus(commerceShipmentId, status);
    }
}

