/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemModel;
import com.liferay.commerce.model.CommerceOrderItemSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceOrderItem service. Represents a row in the &quot;CommerceOrderItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceOrderItemModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderItemImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderItemImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceOrderItemModelImpl
	extends BaseModelImpl<CommerceOrderItem> implements CommerceOrderItemModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order item model instance should use the <code>CommerceOrderItem</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceOrderItem";

	public static final Object[][] TABLE_COLUMNS = {
		{"externalReferenceCode", Types.VARCHAR},
		{"commerceOrderItemId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"commerceOrderId", Types.BIGINT},
		{"commercePriceListId", Types.BIGINT}, {"CProductId", Types.BIGINT},
		{"CPInstanceId", Types.BIGINT},
		{"parentCommerceOrderItemId", Types.BIGINT},
		{"quantity", Types.INTEGER}, {"shippedQuantity", Types.INTEGER},
		{"json", Types.CLOB}, {"name", Types.VARCHAR}, {"sku", Types.VARCHAR},
		{"unitPrice", Types.DECIMAL}, {"promoPrice", Types.DECIMAL},
		{"discountAmount", Types.DECIMAL}, {"finalPrice", Types.DECIMAL},
		{"discountPercentageLevel1", Types.DECIMAL},
		{"discountPercentageLevel2", Types.DECIMAL},
		{"discountPercentageLevel3", Types.DECIMAL},
		{"discountPercentageLevel4", Types.DECIMAL},
		{"unitPriceWithTaxAmount", Types.DECIMAL},
		{"promoPriceWithTaxAmount", Types.DECIMAL},
		{"discountWithTaxAmount", Types.DECIMAL},
		{"finalPriceWithTaxAmount", Types.DECIMAL},
		{"discountPctLevel1WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel2WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel3WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel4WithTaxAmount", Types.DECIMAL},
		{"subscription", Types.BOOLEAN}, {"deliveryGroup", Types.VARCHAR},
		{"shippingAddressId", Types.BIGINT}, {"printedNote", Types.VARCHAR},
		{"requestedDeliveryDate", Types.TIMESTAMP},
		{"bookedQuantityId", Types.BIGINT}, {"manuallyAdjusted", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceOrderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commercePriceListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPInstanceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentCommerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("quantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("shippedQuantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("json", Types.CLOB);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("sku", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("unitPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("promoPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("finalPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("unitPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("promoPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("finalPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel1WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel2WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel3WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel4WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subscription", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("deliveryGroup", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("shippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("printedNote", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("requestedDeliveryDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("bookedQuantityId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("manuallyAdjusted", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceOrderItem (externalReferenceCode VARCHAR(75) null,commerceOrderItemId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceOrderId LONG,commercePriceListId LONG,CProductId LONG,CPInstanceId LONG,parentCommerceOrderItemId LONG,quantity INTEGER,shippedQuantity INTEGER,json TEXT null,name STRING null,sku VARCHAR(75) null,unitPrice DECIMAL(30, 16) null,promoPrice DECIMAL(30, 16) null,discountAmount DECIMAL(30, 16) null,finalPrice DECIMAL(30, 16) null,discountPercentageLevel1 DECIMAL(30, 16) null,discountPercentageLevel2 DECIMAL(30, 16) null,discountPercentageLevel3 DECIMAL(30, 16) null,discountPercentageLevel4 DECIMAL(30, 16) null,unitPriceWithTaxAmount DECIMAL(30, 16) null,promoPriceWithTaxAmount DECIMAL(30, 16) null,discountWithTaxAmount DECIMAL(30, 16) null,finalPriceWithTaxAmount DECIMAL(30, 16) null,discountPctLevel1WithTaxAmount DECIMAL(30, 16) null,discountPctLevel2WithTaxAmount DECIMAL(30, 16) null,discountPctLevel3WithTaxAmount DECIMAL(30, 16) null,discountPctLevel4WithTaxAmount DECIMAL(30, 16) null,subscription BOOLEAN,deliveryGroup VARCHAR(75) null,shippingAddressId LONG,printedNote STRING null,requestedDeliveryDate DATE null,bookedQuantityId LONG,manuallyAdjusted BOOLEAN)";

	public static final String TABLE_SQL_DROP = "drop table CommerceOrderItem";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceOrderItem.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceOrderItem.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceOrderItem"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceOrderItem"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceOrderItem"),
		true);

	public static final long CPINSTANCEID_COLUMN_BITMASK = 1L;

	public static final long CPRODUCTID_COLUMN_BITMASK = 2L;

	public static final long BOOKEDQUANTITYID_COLUMN_BITMASK = 4L;

	public static final long COMMERCEORDERID_COLUMN_BITMASK = 8L;

	public static final long COMPANYID_COLUMN_BITMASK = 16L;

	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	public static final long PARENTCOMMERCEORDERITEMID_COLUMN_BITMASK = 64L;

	public static final long SUBSCRIPTION_COLUMN_BITMASK = 128L;

	public static final long CREATEDATE_COLUMN_BITMASK = 256L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceOrderItem toModel(CommerceOrderItemSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceOrderItem model = new CommerceOrderItemImpl();

		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommerceOrderItemId(soapModel.getCommerceOrderItemId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceOrderId(soapModel.getCommerceOrderId());
		model.setCommercePriceListId(soapModel.getCommercePriceListId());
		model.setCProductId(soapModel.getCProductId());
		model.setCPInstanceId(soapModel.getCPInstanceId());
		model.setParentCommerceOrderItemId(
			soapModel.getParentCommerceOrderItemId());
		model.setQuantity(soapModel.getQuantity());
		model.setShippedQuantity(soapModel.getShippedQuantity());
		model.setJson(soapModel.getJson());
		model.setName(soapModel.getName());
		model.setSku(soapModel.getSku());
		model.setUnitPrice(soapModel.getUnitPrice());
		model.setPromoPrice(soapModel.getPromoPrice());
		model.setDiscountAmount(soapModel.getDiscountAmount());
		model.setFinalPrice(soapModel.getFinalPrice());
		model.setDiscountPercentageLevel1(
			soapModel.getDiscountPercentageLevel1());
		model.setDiscountPercentageLevel2(
			soapModel.getDiscountPercentageLevel2());
		model.setDiscountPercentageLevel3(
			soapModel.getDiscountPercentageLevel3());
		model.setDiscountPercentageLevel4(
			soapModel.getDiscountPercentageLevel4());
		model.setUnitPriceWithTaxAmount(soapModel.getUnitPriceWithTaxAmount());
		model.setPromoPriceWithTaxAmount(
			soapModel.getPromoPriceWithTaxAmount());
		model.setDiscountWithTaxAmount(soapModel.getDiscountWithTaxAmount());
		model.setFinalPriceWithTaxAmount(
			soapModel.getFinalPriceWithTaxAmount());
		model.setDiscountPercentageLevel1WithTaxAmount(
			soapModel.getDiscountPercentageLevel1WithTaxAmount());
		model.setDiscountPercentageLevel2WithTaxAmount(
			soapModel.getDiscountPercentageLevel2WithTaxAmount());
		model.setDiscountPercentageLevel3WithTaxAmount(
			soapModel.getDiscountPercentageLevel3WithTaxAmount());
		model.setDiscountPercentageLevel4WithTaxAmount(
			soapModel.getDiscountPercentageLevel4WithTaxAmount());
		model.setSubscription(soapModel.isSubscription());
		model.setDeliveryGroup(soapModel.getDeliveryGroup());
		model.setShippingAddressId(soapModel.getShippingAddressId());
		model.setPrintedNote(soapModel.getPrintedNote());
		model.setRequestedDeliveryDate(soapModel.getRequestedDeliveryDate());
		model.setBookedQuantityId(soapModel.getBookedQuantityId());
		model.setManuallyAdjusted(soapModel.isManuallyAdjusted());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceOrderItem> toModels(
		CommerceOrderItemSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceOrderItem> models = new ArrayList<CommerceOrderItem>(
			soapModels.length);

		for (CommerceOrderItemSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceOrderItem"));

	public CommerceOrderItemModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceOrderItemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceOrderItemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceOrderItemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceOrderItem.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceOrderItem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceOrderItem)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceOrderItem, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceOrderItem, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceOrderItem)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceOrderItem, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceOrderItem, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceOrderItem>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceOrderItem.class.getClassLoader(), CommerceOrderItem.class,
			ModelWrapper.class);

		try {
			Constructor<CommerceOrderItem> constructor =
				(Constructor<CommerceOrderItem>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<CommerceOrderItem, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceOrderItem, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceOrderItem, Object>>();
		Map<String, BiConsumer<CommerceOrderItem, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommerceOrderItem, ?>>();

		attributeGetterFunctions.put(
			"externalReferenceCode",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getExternalReferenceCode();
				}

			});
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object externalReferenceCodeObject) {

					commerceOrderItem.setExternalReferenceCode(
						(String)externalReferenceCodeObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceOrderItemId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getCommerceOrderItemId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceOrderItemId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object commerceOrderItemIdObject) {

					commerceOrderItem.setCommerceOrderItemId(
						(Long)commerceOrderItemIdObject);
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getGroupId();
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem, Object groupIdObject) {

					commerceOrderItem.setGroupId((Long)groupIdObject);
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getCompanyId();
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object companyIdObject) {

					commerceOrderItem.setCompanyId((Long)companyIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem, Object userIdObject) {

					commerceOrderItem.setUserId((Long)userIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object userNameObject) {

					commerceOrderItem.setUserName((String)userNameObject);
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getCreateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object createDateObject) {

					commerceOrderItem.setCreateDate((Date)createDateObject);
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getModifiedDate();
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object modifiedDateObject) {

					commerceOrderItem.setModifiedDate((Date)modifiedDateObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceOrderId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getCommerceOrderId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceOrderId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object commerceOrderIdObject) {

					commerceOrderItem.setCommerceOrderId(
						(Long)commerceOrderIdObject);
				}

			});
		attributeGetterFunctions.put(
			"commercePriceListId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getCommercePriceListId();
				}

			});
		attributeSetterBiConsumers.put(
			"commercePriceListId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object commercePriceListIdObject) {

					commerceOrderItem.setCommercePriceListId(
						(Long)commercePriceListIdObject);
				}

			});
		attributeGetterFunctions.put(
			"CProductId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getCProductId();
				}

			});
		attributeSetterBiConsumers.put(
			"CProductId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object CProductIdObject) {

					commerceOrderItem.setCProductId((Long)CProductIdObject);
				}

			});
		attributeGetterFunctions.put(
			"CPInstanceId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getCPInstanceId();
				}

			});
		attributeSetterBiConsumers.put(
			"CPInstanceId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object CPInstanceIdObject) {

					commerceOrderItem.setCPInstanceId((Long)CPInstanceIdObject);
				}

			});
		attributeGetterFunctions.put(
			"parentCommerceOrderItemId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getParentCommerceOrderItemId();
				}

			});
		attributeSetterBiConsumers.put(
			"parentCommerceOrderItemId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object parentCommerceOrderItemIdObject) {

					commerceOrderItem.setParentCommerceOrderItemId(
						(Long)parentCommerceOrderItemIdObject);
				}

			});
		attributeGetterFunctions.put(
			"quantity",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getQuantity();
				}

			});
		attributeSetterBiConsumers.put(
			"quantity",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object quantityObject) {

					commerceOrderItem.setQuantity((Integer)quantityObject);
				}

			});
		attributeGetterFunctions.put(
			"shippedQuantity",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getShippedQuantity();
				}

			});
		attributeSetterBiConsumers.put(
			"shippedQuantity",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object shippedQuantityObject) {

					commerceOrderItem.setShippedQuantity(
						(Integer)shippedQuantityObject);
				}

			});
		attributeGetterFunctions.put(
			"json",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getJson();
				}

			});
		attributeSetterBiConsumers.put(
			"json",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem, Object jsonObject) {

					commerceOrderItem.setJson((String)jsonObject);
				}

			});
		attributeGetterFunctions.put(
			"name",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getName();
				}

			});
		attributeSetterBiConsumers.put(
			"name",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem, Object nameObject) {

					commerceOrderItem.setName((String)nameObject);
				}

			});
		attributeGetterFunctions.put(
			"sku",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getSku();
				}

			});
		attributeSetterBiConsumers.put(
			"sku",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem, Object skuObject) {

					commerceOrderItem.setSku((String)skuObject);
				}

			});
		attributeGetterFunctions.put(
			"unitPrice",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getUnitPrice();
				}

			});
		attributeSetterBiConsumers.put(
			"unitPrice",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object unitPriceObject) {

					commerceOrderItem.setUnitPrice((BigDecimal)unitPriceObject);
				}

			});
		attributeGetterFunctions.put(
			"promoPrice",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getPromoPrice();
				}

			});
		attributeSetterBiConsumers.put(
			"promoPrice",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object promoPriceObject) {

					commerceOrderItem.setPromoPrice(
						(BigDecimal)promoPriceObject);
				}

			});
		attributeGetterFunctions.put(
			"discountAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getDiscountAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"discountAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountAmountObject) {

					commerceOrderItem.setDiscountAmount(
						(BigDecimal)discountAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"finalPrice",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getFinalPrice();
				}

			});
		attributeSetterBiConsumers.put(
			"finalPrice",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object finalPriceObject) {

					commerceOrderItem.setFinalPrice(
						(BigDecimal)finalPriceObject);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel1",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getDiscountPercentageLevel1();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel1",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel1Object) {

					commerceOrderItem.setDiscountPercentageLevel1(
						(BigDecimal)discountPercentageLevel1Object);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel2",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getDiscountPercentageLevel2();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel2",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel2Object) {

					commerceOrderItem.setDiscountPercentageLevel2(
						(BigDecimal)discountPercentageLevel2Object);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel3",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getDiscountPercentageLevel3();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel3",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel3Object) {

					commerceOrderItem.setDiscountPercentageLevel3(
						(BigDecimal)discountPercentageLevel3Object);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel4",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getDiscountPercentageLevel4();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel4",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel4Object) {

					commerceOrderItem.setDiscountPercentageLevel4(
						(BigDecimal)discountPercentageLevel4Object);
				}

			});
		attributeGetterFunctions.put(
			"unitPriceWithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getUnitPriceWithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"unitPriceWithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object unitPriceWithTaxAmountObject) {

					commerceOrderItem.setUnitPriceWithTaxAmount(
						(BigDecimal)unitPriceWithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"promoPriceWithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getPromoPriceWithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"promoPriceWithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object promoPriceWithTaxAmountObject) {

					commerceOrderItem.setPromoPriceWithTaxAmount(
						(BigDecimal)promoPriceWithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"discountWithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getDiscountWithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"discountWithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountWithTaxAmountObject) {

					commerceOrderItem.setDiscountWithTaxAmount(
						(BigDecimal)discountWithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"finalPriceWithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getFinalPriceWithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"finalPriceWithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object finalPriceWithTaxAmountObject) {

					commerceOrderItem.setFinalPriceWithTaxAmount(
						(BigDecimal)finalPriceWithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel1WithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.
						getDiscountPercentageLevel1WithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel1WithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel1WithTaxAmountObject) {

					commerceOrderItem.setDiscountPercentageLevel1WithTaxAmount(
						(BigDecimal)
							discountPercentageLevel1WithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel2WithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.
						getDiscountPercentageLevel2WithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel2WithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel2WithTaxAmountObject) {

					commerceOrderItem.setDiscountPercentageLevel2WithTaxAmount(
						(BigDecimal)
							discountPercentageLevel2WithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel3WithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.
						getDiscountPercentageLevel3WithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel3WithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel3WithTaxAmountObject) {

					commerceOrderItem.setDiscountPercentageLevel3WithTaxAmount(
						(BigDecimal)
							discountPercentageLevel3WithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"discountPercentageLevel4WithTaxAmount",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.
						getDiscountPercentageLevel4WithTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"discountPercentageLevel4WithTaxAmount",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object discountPercentageLevel4WithTaxAmountObject) {

					commerceOrderItem.setDiscountPercentageLevel4WithTaxAmount(
						(BigDecimal)
							discountPercentageLevel4WithTaxAmountObject);
				}

			});
		attributeGetterFunctions.put(
			"subscription",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getSubscription();
				}

			});
		attributeSetterBiConsumers.put(
			"subscription",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object subscriptionObject) {

					commerceOrderItem.setSubscription(
						(Boolean)subscriptionObject);
				}

			});
		attributeGetterFunctions.put(
			"deliveryGroup",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getDeliveryGroup();
				}

			});
		attributeSetterBiConsumers.put(
			"deliveryGroup",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object deliveryGroupObject) {

					commerceOrderItem.setDeliveryGroup(
						(String)deliveryGroupObject);
				}

			});
		attributeGetterFunctions.put(
			"shippingAddressId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getShippingAddressId();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingAddressId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object shippingAddressIdObject) {

					commerceOrderItem.setShippingAddressId(
						(Long)shippingAddressIdObject);
				}

			});
		attributeGetterFunctions.put(
			"printedNote",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getPrintedNote();
				}

			});
		attributeSetterBiConsumers.put(
			"printedNote",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object printedNoteObject) {

					commerceOrderItem.setPrintedNote((String)printedNoteObject);
				}

			});
		attributeGetterFunctions.put(
			"requestedDeliveryDate",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getRequestedDeliveryDate();
				}

			});
		attributeSetterBiConsumers.put(
			"requestedDeliveryDate",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object requestedDeliveryDateObject) {

					commerceOrderItem.setRequestedDeliveryDate(
						(Date)requestedDeliveryDateObject);
				}

			});
		attributeGetterFunctions.put(
			"bookedQuantityId",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getBookedQuantityId();
				}

			});
		attributeSetterBiConsumers.put(
			"bookedQuantityId",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object bookedQuantityIdObject) {

					commerceOrderItem.setBookedQuantityId(
						(Long)bookedQuantityIdObject);
				}

			});
		attributeGetterFunctions.put(
			"manuallyAdjusted",
			new Function<CommerceOrderItem, Object>() {

				@Override
				public Object apply(CommerceOrderItem commerceOrderItem) {
					return commerceOrderItem.getManuallyAdjusted();
				}

			});
		attributeSetterBiConsumers.put(
			"manuallyAdjusted",
			new BiConsumer<CommerceOrderItem, Object>() {

				@Override
				public void accept(
					CommerceOrderItem commerceOrderItem,
					Object manuallyAdjustedObject) {

					commerceOrderItem.setManuallyAdjusted(
						(Boolean)manuallyAdjustedObject);
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		_columnBitmask |= EXTERNALREFERENCECODE_COLUMN_BITMASK;

		if (_originalExternalReferenceCode == null) {
			_originalExternalReferenceCode = _externalReferenceCode;
		}

		_externalReferenceCode = externalReferenceCode;
	}

	public String getOriginalExternalReferenceCode() {
		return GetterUtil.getString(_originalExternalReferenceCode);
	}

	@JSON
	@Override
	public long getCommerceOrderItemId() {
		return _commerceOrderItemId;
	}

	@Override
	public void setCommerceOrderItemId(long commerceOrderItemId) {
		_commerceOrderItemId = commerceOrderItemId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	@Override
	public void setCommerceOrderId(long commerceOrderId) {
		_columnBitmask |= COMMERCEORDERID_COLUMN_BITMASK;

		if (!_setOriginalCommerceOrderId) {
			_setOriginalCommerceOrderId = true;

			_originalCommerceOrderId = _commerceOrderId;
		}

		_commerceOrderId = commerceOrderId;
	}

	public long getOriginalCommerceOrderId() {
		return _originalCommerceOrderId;
	}

	@JSON
	@Override
	public long getCommercePriceListId() {
		return _commercePriceListId;
	}

	@Override
	public void setCommercePriceListId(long commercePriceListId) {
		_commercePriceListId = commercePriceListId;
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		_columnBitmask |= CPRODUCTID_COLUMN_BITMASK;

		if (!_setOriginalCProductId) {
			_setOriginalCProductId = true;

			_originalCProductId = _CProductId;
		}

		_CProductId = CProductId;
	}

	public long getOriginalCProductId() {
		return _originalCProductId;
	}

	@JSON
	@Override
	public long getCPInstanceId() {
		return _CPInstanceId;
	}

	@Override
	public void setCPInstanceId(long CPInstanceId) {
		_columnBitmask |= CPINSTANCEID_COLUMN_BITMASK;

		if (!_setOriginalCPInstanceId) {
			_setOriginalCPInstanceId = true;

			_originalCPInstanceId = _CPInstanceId;
		}

		_CPInstanceId = CPInstanceId;
	}

	public long getOriginalCPInstanceId() {
		return _originalCPInstanceId;
	}

	@JSON
	@Override
	public long getParentCommerceOrderItemId() {
		return _parentCommerceOrderItemId;
	}

	@Override
	public void setParentCommerceOrderItemId(long parentCommerceOrderItemId) {
		_columnBitmask |= PARENTCOMMERCEORDERITEMID_COLUMN_BITMASK;

		if (!_setOriginalParentCommerceOrderItemId) {
			_setOriginalParentCommerceOrderItemId = true;

			_originalParentCommerceOrderItemId = _parentCommerceOrderItemId;
		}

		_parentCommerceOrderItemId = parentCommerceOrderItemId;
	}

	public long getOriginalParentCommerceOrderItemId() {
		return _originalParentCommerceOrderItemId;
	}

	@JSON
	@Override
	public int getQuantity() {
		return _quantity;
	}

	@Override
	public void setQuantity(int quantity) {
		_quantity = quantity;
	}

	@JSON
	@Override
	public int getShippedQuantity() {
		return _shippedQuantity;
	}

	@Override
	public void setShippedQuantity(int shippedQuantity) {
		_shippedQuantity = shippedQuantity;
	}

	@JSON
	@Override
	public String getJson() {
		if (_json == null) {
			return "";
		}
		else {
			return _json;
		}
	}

	@Override
	public void setJson(String json) {
		_json = json;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getSku() {
		if (_sku == null) {
			return "";
		}
		else {
			return _sku;
		}
	}

	@Override
	public void setSku(String sku) {
		_sku = sku;
	}

	@JSON
	@Override
	public BigDecimal getUnitPrice() {
		return _unitPrice;
	}

	@Override
	public void setUnitPrice(BigDecimal unitPrice) {
		_unitPrice = unitPrice;
	}

	@JSON
	@Override
	public BigDecimal getPromoPrice() {
		return _promoPrice;
	}

	@Override
	public void setPromoPrice(BigDecimal promoPrice) {
		_promoPrice = promoPrice;
	}

	@JSON
	@Override
	public BigDecimal getDiscountAmount() {
		return _discountAmount;
	}

	@Override
	public void setDiscountAmount(BigDecimal discountAmount) {
		_discountAmount = discountAmount;
	}

	@JSON
	@Override
	public BigDecimal getFinalPrice() {
		return _finalPrice;
	}

	@Override
	public void setFinalPrice(BigDecimal finalPrice) {
		_finalPrice = finalPrice;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel1() {
		return _discountPercentageLevel1;
	}

	@Override
	public void setDiscountPercentageLevel1(
		BigDecimal discountPercentageLevel1) {

		_discountPercentageLevel1 = discountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel2() {
		return _discountPercentageLevel2;
	}

	@Override
	public void setDiscountPercentageLevel2(
		BigDecimal discountPercentageLevel2) {

		_discountPercentageLevel2 = discountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel3() {
		return _discountPercentageLevel3;
	}

	@Override
	public void setDiscountPercentageLevel3(
		BigDecimal discountPercentageLevel3) {

		_discountPercentageLevel3 = discountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel4() {
		return _discountPercentageLevel4;
	}

	@Override
	public void setDiscountPercentageLevel4(
		BigDecimal discountPercentageLevel4) {

		_discountPercentageLevel4 = discountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getUnitPriceWithTaxAmount() {
		return _unitPriceWithTaxAmount;
	}

	@Override
	public void setUnitPriceWithTaxAmount(BigDecimal unitPriceWithTaxAmount) {
		_unitPriceWithTaxAmount = unitPriceWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getPromoPriceWithTaxAmount() {
		return _promoPriceWithTaxAmount;
	}

	@Override
	public void setPromoPriceWithTaxAmount(BigDecimal promoPriceWithTaxAmount) {
		_promoPriceWithTaxAmount = promoPriceWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountWithTaxAmount() {
		return _discountWithTaxAmount;
	}

	@Override
	public void setDiscountWithTaxAmount(BigDecimal discountWithTaxAmount) {
		_discountWithTaxAmount = discountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getFinalPriceWithTaxAmount() {
		return _finalPriceWithTaxAmount;
	}

	@Override
	public void setFinalPriceWithTaxAmount(BigDecimal finalPriceWithTaxAmount) {
		_finalPriceWithTaxAmount = finalPriceWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel1WithTaxAmount() {
		return _discountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel1WithTaxAmount(
		BigDecimal discountPercentageLevel1WithTaxAmount) {

		_discountPercentageLevel1WithTaxAmount =
			discountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel2WithTaxAmount() {
		return _discountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel2WithTaxAmount(
		BigDecimal discountPercentageLevel2WithTaxAmount) {

		_discountPercentageLevel2WithTaxAmount =
			discountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel3WithTaxAmount() {
		return _discountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel3WithTaxAmount(
		BigDecimal discountPercentageLevel3WithTaxAmount) {

		_discountPercentageLevel3WithTaxAmount =
			discountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel4WithTaxAmount() {
		return _discountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel4WithTaxAmount(
		BigDecimal discountPercentageLevel4WithTaxAmount) {

		_discountPercentageLevel4WithTaxAmount =
			discountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public boolean getSubscription() {
		return _subscription;
	}

	@JSON
	@Override
	public boolean isSubscription() {
		return _subscription;
	}

	@Override
	public void setSubscription(boolean subscription) {
		_columnBitmask |= SUBSCRIPTION_COLUMN_BITMASK;

		if (!_setOriginalSubscription) {
			_setOriginalSubscription = true;

			_originalSubscription = _subscription;
		}

		_subscription = subscription;
	}

	public boolean getOriginalSubscription() {
		return _originalSubscription;
	}

	@JSON
	@Override
	public String getDeliveryGroup() {
		if (_deliveryGroup == null) {
			return "";
		}
		else {
			return _deliveryGroup;
		}
	}

	@Override
	public void setDeliveryGroup(String deliveryGroup) {
		_deliveryGroup = deliveryGroup;
	}

	@JSON
	@Override
	public long getShippingAddressId() {
		return _shippingAddressId;
	}

	@Override
	public void setShippingAddressId(long shippingAddressId) {
		_shippingAddressId = shippingAddressId;
	}

	@JSON
	@Override
	public String getPrintedNote() {
		if (_printedNote == null) {
			return "";
		}
		else {
			return _printedNote;
		}
	}

	@Override
	public void setPrintedNote(String printedNote) {
		_printedNote = printedNote;
	}

	@JSON
	@Override
	public Date getRequestedDeliveryDate() {
		return _requestedDeliveryDate;
	}

	@Override
	public void setRequestedDeliveryDate(Date requestedDeliveryDate) {
		_requestedDeliveryDate = requestedDeliveryDate;
	}

	@JSON
	@Override
	public long getBookedQuantityId() {
		return _bookedQuantityId;
	}

	@Override
	public void setBookedQuantityId(long bookedQuantityId) {
		_columnBitmask |= BOOKEDQUANTITYID_COLUMN_BITMASK;

		if (!_setOriginalBookedQuantityId) {
			_setOriginalBookedQuantityId = true;

			_originalBookedQuantityId = _bookedQuantityId;
		}

		_bookedQuantityId = bookedQuantityId;
	}

	public long getOriginalBookedQuantityId() {
		return _originalBookedQuantityId;
	}

	@JSON
	@Override
	public boolean getManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@JSON
	@Override
	public boolean isManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@Override
	public void setManuallyAdjusted(boolean manuallyAdjusted) {
		_manuallyAdjusted = manuallyAdjusted;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceOrderItem.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			CommerceOrderItem.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public CommerceOrderItem toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceOrderItem>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceOrderItemImpl commerceOrderItemImpl =
			new CommerceOrderItemImpl();

		commerceOrderItemImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceOrderItemImpl.setCommerceOrderItemId(getCommerceOrderItemId());
		commerceOrderItemImpl.setGroupId(getGroupId());
		commerceOrderItemImpl.setCompanyId(getCompanyId());
		commerceOrderItemImpl.setUserId(getUserId());
		commerceOrderItemImpl.setUserName(getUserName());
		commerceOrderItemImpl.setCreateDate(getCreateDate());
		commerceOrderItemImpl.setModifiedDate(getModifiedDate());
		commerceOrderItemImpl.setCommerceOrderId(getCommerceOrderId());
		commerceOrderItemImpl.setCommercePriceListId(getCommercePriceListId());
		commerceOrderItemImpl.setCProductId(getCProductId());
		commerceOrderItemImpl.setCPInstanceId(getCPInstanceId());
		commerceOrderItemImpl.setParentCommerceOrderItemId(
			getParentCommerceOrderItemId());
		commerceOrderItemImpl.setQuantity(getQuantity());
		commerceOrderItemImpl.setShippedQuantity(getShippedQuantity());
		commerceOrderItemImpl.setJson(getJson());
		commerceOrderItemImpl.setName(getName());
		commerceOrderItemImpl.setSku(getSku());
		commerceOrderItemImpl.setUnitPrice(getUnitPrice());
		commerceOrderItemImpl.setPromoPrice(getPromoPrice());
		commerceOrderItemImpl.setDiscountAmount(getDiscountAmount());
		commerceOrderItemImpl.setFinalPrice(getFinalPrice());
		commerceOrderItemImpl.setDiscountPercentageLevel1(
			getDiscountPercentageLevel1());
		commerceOrderItemImpl.setDiscountPercentageLevel2(
			getDiscountPercentageLevel2());
		commerceOrderItemImpl.setDiscountPercentageLevel3(
			getDiscountPercentageLevel3());
		commerceOrderItemImpl.setDiscountPercentageLevel4(
			getDiscountPercentageLevel4());
		commerceOrderItemImpl.setUnitPriceWithTaxAmount(
			getUnitPriceWithTaxAmount());
		commerceOrderItemImpl.setPromoPriceWithTaxAmount(
			getPromoPriceWithTaxAmount());
		commerceOrderItemImpl.setDiscountWithTaxAmount(
			getDiscountWithTaxAmount());
		commerceOrderItemImpl.setFinalPriceWithTaxAmount(
			getFinalPriceWithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel1WithTaxAmount(
			getDiscountPercentageLevel1WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel2WithTaxAmount(
			getDiscountPercentageLevel2WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel3WithTaxAmount(
			getDiscountPercentageLevel3WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel4WithTaxAmount(
			getDiscountPercentageLevel4WithTaxAmount());
		commerceOrderItemImpl.setSubscription(isSubscription());
		commerceOrderItemImpl.setDeliveryGroup(getDeliveryGroup());
		commerceOrderItemImpl.setShippingAddressId(getShippingAddressId());
		commerceOrderItemImpl.setPrintedNote(getPrintedNote());
		commerceOrderItemImpl.setRequestedDeliveryDate(
			getRequestedDeliveryDate());
		commerceOrderItemImpl.setBookedQuantityId(getBookedQuantityId());
		commerceOrderItemImpl.setManuallyAdjusted(isManuallyAdjusted());

		commerceOrderItemImpl.resetOriginalValues();

		return commerceOrderItemImpl;
	}

	@Override
	public int compareTo(CommerceOrderItem commerceOrderItem) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceOrderItem.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceOrderItem)) {
			return false;
		}

		CommerceOrderItem commerceOrderItem = (CommerceOrderItem)object;

		long primaryKey = commerceOrderItem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalExternalReferenceCode = _externalReferenceCode;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_setModifiedDate = false;
		_originalCommerceOrderId = _commerceOrderId;

		_setOriginalCommerceOrderId = false;

		_originalCProductId = _CProductId;

		_setOriginalCProductId = false;

		_originalCPInstanceId = _CPInstanceId;

		_setOriginalCPInstanceId = false;

		_originalParentCommerceOrderItemId = _parentCommerceOrderItemId;

		_setOriginalParentCommerceOrderItemId = false;

		_originalSubscription = _subscription;

		_setOriginalSubscription = false;

		_originalBookedQuantityId = _bookedQuantityId;

		_setOriginalBookedQuantityId = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceOrderItem> toCacheModel() {
		CommerceOrderItemCacheModel commerceOrderItemCacheModel =
			new CommerceOrderItemCacheModel();

		commerceOrderItemCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceOrderItemCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceOrderItemCacheModel.externalReferenceCode = null;
		}

		commerceOrderItemCacheModel.commerceOrderItemId =
			getCommerceOrderItemId();

		commerceOrderItemCacheModel.groupId = getGroupId();

		commerceOrderItemCacheModel.companyId = getCompanyId();

		commerceOrderItemCacheModel.userId = getUserId();

		commerceOrderItemCacheModel.userName = getUserName();

		String userName = commerceOrderItemCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceOrderItemCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceOrderItemCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceOrderItemCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceOrderItemCacheModel.commerceOrderId = getCommerceOrderId();

		commerceOrderItemCacheModel.commercePriceListId =
			getCommercePriceListId();

		commerceOrderItemCacheModel.CProductId = getCProductId();

		commerceOrderItemCacheModel.CPInstanceId = getCPInstanceId();

		commerceOrderItemCacheModel.parentCommerceOrderItemId =
			getParentCommerceOrderItemId();

		commerceOrderItemCacheModel.quantity = getQuantity();

		commerceOrderItemCacheModel.shippedQuantity = getShippedQuantity();

		commerceOrderItemCacheModel.json = getJson();

		String json = commerceOrderItemCacheModel.json;

		if ((json != null) && (json.length() == 0)) {
			commerceOrderItemCacheModel.json = null;
		}

		commerceOrderItemCacheModel.name = getName();

		String name = commerceOrderItemCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceOrderItemCacheModel.name = null;
		}

		commerceOrderItemCacheModel.sku = getSku();

		String sku = commerceOrderItemCacheModel.sku;

		if ((sku != null) && (sku.length() == 0)) {
			commerceOrderItemCacheModel.sku = null;
		}

		commerceOrderItemCacheModel.unitPrice = getUnitPrice();

		commerceOrderItemCacheModel.promoPrice = getPromoPrice();

		commerceOrderItemCacheModel.discountAmount = getDiscountAmount();

		commerceOrderItemCacheModel.finalPrice = getFinalPrice();

		commerceOrderItemCacheModel.discountPercentageLevel1 =
			getDiscountPercentageLevel1();

		commerceOrderItemCacheModel.discountPercentageLevel2 =
			getDiscountPercentageLevel2();

		commerceOrderItemCacheModel.discountPercentageLevel3 =
			getDiscountPercentageLevel3();

		commerceOrderItemCacheModel.discountPercentageLevel4 =
			getDiscountPercentageLevel4();

		commerceOrderItemCacheModel.unitPriceWithTaxAmount =
			getUnitPriceWithTaxAmount();

		commerceOrderItemCacheModel.promoPriceWithTaxAmount =
			getPromoPriceWithTaxAmount();

		commerceOrderItemCacheModel.discountWithTaxAmount =
			getDiscountWithTaxAmount();

		commerceOrderItemCacheModel.finalPriceWithTaxAmount =
			getFinalPriceWithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel1WithTaxAmount =
			getDiscountPercentageLevel1WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel2WithTaxAmount =
			getDiscountPercentageLevel2WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel3WithTaxAmount =
			getDiscountPercentageLevel3WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel4WithTaxAmount =
			getDiscountPercentageLevel4WithTaxAmount();

		commerceOrderItemCacheModel.subscription = isSubscription();

		commerceOrderItemCacheModel.deliveryGroup = getDeliveryGroup();

		String deliveryGroup = commerceOrderItemCacheModel.deliveryGroup;

		if ((deliveryGroup != null) && (deliveryGroup.length() == 0)) {
			commerceOrderItemCacheModel.deliveryGroup = null;
		}

		commerceOrderItemCacheModel.shippingAddressId = getShippingAddressId();

		commerceOrderItemCacheModel.printedNote = getPrintedNote();

		String printedNote = commerceOrderItemCacheModel.printedNote;

		if ((printedNote != null) && (printedNote.length() == 0)) {
			commerceOrderItemCacheModel.printedNote = null;
		}

		Date requestedDeliveryDate = getRequestedDeliveryDate();

		if (requestedDeliveryDate != null) {
			commerceOrderItemCacheModel.requestedDeliveryDate =
				requestedDeliveryDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.requestedDeliveryDate = Long.MIN_VALUE;
		}

		commerceOrderItemCacheModel.bookedQuantityId = getBookedQuantityId();

		commerceOrderItemCacheModel.manuallyAdjusted = isManuallyAdjusted();

		return commerceOrderItemCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(4 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((CommerceOrderItem)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceOrderItem)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceOrderItem>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _externalReferenceCode;
	private String _originalExternalReferenceCode;
	private long _commerceOrderItemId;
	private long _groupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceOrderId;
	private long _originalCommerceOrderId;
	private boolean _setOriginalCommerceOrderId;
	private long _commercePriceListId;
	private long _CProductId;
	private long _originalCProductId;
	private boolean _setOriginalCProductId;
	private long _CPInstanceId;
	private long _originalCPInstanceId;
	private boolean _setOriginalCPInstanceId;
	private long _parentCommerceOrderItemId;
	private long _originalParentCommerceOrderItemId;
	private boolean _setOriginalParentCommerceOrderItemId;
	private int _quantity;
	private int _shippedQuantity;
	private String _json;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _sku;
	private BigDecimal _unitPrice;
	private BigDecimal _promoPrice;
	private BigDecimal _discountAmount;
	private BigDecimal _finalPrice;
	private BigDecimal _discountPercentageLevel1;
	private BigDecimal _discountPercentageLevel2;
	private BigDecimal _discountPercentageLevel3;
	private BigDecimal _discountPercentageLevel4;
	private BigDecimal _unitPriceWithTaxAmount;
	private BigDecimal _promoPriceWithTaxAmount;
	private BigDecimal _discountWithTaxAmount;
	private BigDecimal _finalPriceWithTaxAmount;
	private BigDecimal _discountPercentageLevel1WithTaxAmount;
	private BigDecimal _discountPercentageLevel2WithTaxAmount;
	private BigDecimal _discountPercentageLevel3WithTaxAmount;
	private BigDecimal _discountPercentageLevel4WithTaxAmount;
	private boolean _subscription;
	private boolean _originalSubscription;
	private boolean _setOriginalSubscription;
	private String _deliveryGroup;
	private long _shippingAddressId;
	private String _printedNote;
	private Date _requestedDeliveryDate;
	private long _bookedQuantityId;
	private long _originalBookedQuantityId;
	private boolean _setOriginalBookedQuantityId;
	private boolean _manuallyAdjusted;
	private long _columnBitmask;
	private CommerceOrderItem _escapedModel;

}