/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"commerce.order.status.key=15", "commerce.order.status.priority:Integer=60"}, service={CommerceOrderStatus.class})
public class ShippedCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 15;
    public static final int PRIORITY = 60;
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceShippingHelper _commerceShippingHelper;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId) throws PortalException {
        commerceOrder.setOrderStatus(15);
        if (!this._commerceShippingHelper.isShippable(commerceOrder)) {
            commerceOrder = this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, 0, userId);
        }
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 15;
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)CommerceOrderConstants.getOrderStatusLabel((int)15));
    }

    public int getPriority() {
        return 60;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return commerceOrder.getOrderStatus() == 15 || commerceOrder.getOrderStatus() == 0;
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        boolean allOrderItemsShipped = true;
        for (CommerceOrderItem shippedCommerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            if (shippedCommerceOrderItem.getShippedQuantity() >= shippedCommerceOrderItem.getQuantity()) continue;
            allOrderItemsShipped = false;
        }
        return !(commerceOrder.getOrderStatus() != 10 && commerceOrder.getOrderStatus() != 14 || !allOrderItemsShipped && this._commerceShippingHelper.isShippable(commerceOrder));
    }

    public boolean isValidForOrder(CommerceOrder commerceOrder) throws PortalException {
        return this._commerceShippingHelper.isShippable(commerceOrder);
    }
}

