/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.service.base.CommerceAvailabilityEstimateLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceAvailabilityEstimateLocalServiceImpl
extends CommerceAvailabilityEstimateLocalServiceBaseImpl {
    public CommerceAvailabilityEstimate addCommerceAvailabilityEstimate(Map<Locale, String> titleMap, double priority, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceAvailabilityEstimateId = this.counterLocalService.increment();
        CommerceAvailabilityEstimate commerceAvailabilityEstimate = this.commerceAvailabilityEstimatePersistence.create(commerceAvailabilityEstimateId);
        commerceAvailabilityEstimate.setCompanyId(user.getCompanyId());
        commerceAvailabilityEstimate.setUserId(user.getUserId());
        commerceAvailabilityEstimate.setUserName(user.getFullName());
        commerceAvailabilityEstimate.setTitleMap(titleMap);
        commerceAvailabilityEstimate.setPriority(priority);
        return (CommerceAvailabilityEstimate)this.commerceAvailabilityEstimatePersistence.update((BaseModel)commerceAvailabilityEstimate);
    }

    @Override
    @SystemEvent(type=1)
    public CommerceAvailabilityEstimate deleteCommerceAvailabilityEstimate(CommerceAvailabilityEstimate commerceAvailabilityEstimate) throws PortalException {
        this.commerceAvailabilityEstimatePersistence.remove((BaseModel)commerceAvailabilityEstimate);
        this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimates(commerceAvailabilityEstimate.getCommerceAvailabilityEstimateId());
        return commerceAvailabilityEstimate;
    }

    @Override
    public CommerceAvailabilityEstimate deleteCommerceAvailabilityEstimate(long commerceAvailabilityEstimateId) throws PortalException {
        CommerceAvailabilityEstimate commerceAvailabilityEstimate = this.commerceAvailabilityEstimatePersistence.findByPrimaryKey(commerceAvailabilityEstimateId);
        return this.commerceAvailabilityEstimateLocalService.deleteCommerceAvailabilityEstimate(commerceAvailabilityEstimate);
    }

    public void deleteCommerceAvailabilityEstimates(long companyId) throws PortalException {
        List commerceAvailabilityEstimates = this.commerceAvailabilityEstimatePersistence.findByCompanyId(companyId);
        for (CommerceAvailabilityEstimate commerceAvailabilityEstimate : commerceAvailabilityEstimates) {
            this.commerceAvailabilityEstimateLocalService.deleteCommerceAvailabilityEstimate(commerceAvailabilityEstimate);
        }
    }

    public List<CommerceAvailabilityEstimate> getCommerceAvailabilityEstimates(long companyId, int start, int end, OrderByComparator<CommerceAvailabilityEstimate> orderByComparator) {
        return this.commerceAvailabilityEstimatePersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCommerceAvailabilityEstimatesCount(long companyId) {
        return this.commerceAvailabilityEstimatePersistence.countByCompanyId(companyId);
    }

    public CommerceAvailabilityEstimate updateCommerceAvailabilityEstimate(long commerceAvailabilityId, Map<Locale, String> titleMap, double priority, ServiceContext serviceContext) throws PortalException {
        CommerceAvailabilityEstimate commerceAvailabilityEstimate = this.commerceAvailabilityEstimatePersistence.findByPrimaryKey(commerceAvailabilityId);
        commerceAvailabilityEstimate.setTitleMap(titleMap);
        commerceAvailabilityEstimate.setPriority(priority);
        return (CommerceAvailabilityEstimate)this.commerceAvailabilityEstimatePersistence.update((BaseModel)commerceAvailabilityEstimate);
    }
}

