/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.model.impl;

import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactoryUtil;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.impl.CommerceOrderItemBaseImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPInstanceLocalServiceUtil;
import com.liferay.commerce.product.service.CProductLocalServiceUtil;
import com.liferay.commerce.service.CommerceOrderItemLocalServiceUtil;
import com.liferay.commerce.service.CommerceOrderLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;

public class CommerceOrderItemImpl
extends CommerceOrderItemBaseImpl {
    public CPInstance fetchCPInstance() {
        return CPInstanceLocalServiceUtil.fetchCPInstance((long)this.getCPInstanceId());
    }

    public CProduct fetchCProduct() {
        return CProductLocalServiceUtil.fetchCProduct((long)this.getCProductId());
    }

    public CommerceOrder getCommerceOrder() throws PortalException {
        return CommerceOrderLocalServiceUtil.getCommerceOrder((long)this.getCommerceOrderId());
    }

    public CPDefinition getCPDefinition() throws PortalException {
        CPInstance cpInstance = this.fetchCPInstance();
        if (cpInstance == null) {
            return null;
        }
        return cpInstance.getCPDefinition();
    }

    public long getCPDefinitionId() {
        CPInstance cpInstance = this.fetchCPInstance();
        if (cpInstance == null) {
            return 0L;
        }
        return cpInstance.getCPDefinitionId();
    }

    @Deprecated
    public CPInstance getCPInstance() throws PortalException {
        return CPInstanceLocalServiceUtil.getCPInstance((long)this.getCPInstanceId());
    }

    @Deprecated
    public CProduct getCProduct() throws PortalException {
        return CProductLocalServiceUtil.getCProduct((long)this.getCProductId());
    }

    public CommerceMoney getDiscountAmountMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getDiscountAmount());
    }

    public CommerceMoney getDiscountWithTaxAmountMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getDiscountWithTaxAmount());
    }

    public CommerceMoney getFinalPriceMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getFinalPrice());
    }

    public CommerceMoney getFinalPriceWithTaxAmountMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getFinalPriceWithTaxAmount());
    }

    public long getParentCommerceOrderItemCPDefinitionId() {
        if (this.getParentCommerceOrderItemId() == 0L) {
            return 0L;
        }
        CommerceOrderItem commerceOrderItem = CommerceOrderItemLocalServiceUtil.fetchCommerceOrderItem((long)this.getParentCommerceOrderItemId());
        if (commerceOrderItem == null) {
            return 0L;
        }
        return commerceOrderItem.getCPDefinitionId();
    }

    public CommerceMoney getPromoPriceMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getPromoPrice());
    }

    public CommerceMoney getPromoPriceWithTaxAmountMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getPromoPriceWithTaxAmount());
    }

    public CommerceMoney getUnitPriceMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getUnitPrice());
    }

    public CommerceMoney getUnitPriceWithTaxAmountMoney() throws PortalException {
        CommerceOrder commerceOrder = this.getCommerceOrder();
        return CommerceMoneyFactoryUtil.create((long)commerceOrder.getCommerceCurrencyId(), (BigDecimal)this.getUnitPriceWithTaxAmount());
    }

    public boolean hasParentCommerceOrderItem() {
        return this.getParentCommerceOrderItemId() != 0L;
    }
}

