/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.price.BaseCommerceProductPriceCalculation;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.price.list.discovery.CommercePriceListDiscovery;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.price.calculation.key=v1.0"}, service={CommerceProductPriceCalculation.class})
public class CommerceProductPriceCalculationImpl
extends BaseCommerceProductPriceCalculation {
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference(target="(commerce.discount.calculation.key=v1.0)")
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference(target="(commerce.price.list.discovery.key=hierarchy)")
    private CommercePriceListDiscovery _commercePriceListDiscovery;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    public CommerceProductPrice getCommerceProductPrice(CommerceProductPriceRequest commerceProductPriceRequest) throws PortalException {
        CommerceMoney discountAmountMoney;
        CommerceDiscountValue commerceDiscountValue;
        long cpInstanceId = commerceProductPriceRequest.getCpInstanceId();
        int quantity = commerceProductPriceRequest.getQuantity();
        boolean secure = commerceProductPriceRequest.isSecure();
        CommerceContext commerceContext = commerceProductPriceRequest.getCommerceContext();
        CommerceMoney unitPriceMoney = this.getUnitPrice(cpInstanceId, quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
        BigDecimal finalPrice = unitPriceMoney.getPrice();
        CommerceMoney promoPriceMoney = this.getPromoPrice(cpInstanceId, quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
        BigDecimal promoPrice = promoPriceMoney.getPrice();
        BigDecimal unitPrice = unitPriceMoney.getPrice();
        if (promoPrice != null && promoPrice.compareTo(BigDecimal.ZERO) > 0 && promoPrice.compareTo(unitPrice) <= 0) {
            finalPrice = promoPriceMoney.getPrice();
        }
        BigDecimal[] updatedPrices = this.getUpdatedPrices(unitPrice, promoPrice, finalPrice, commerceContext, commerceProductPriceRequest.getCommerceOptionValues());
        finalPrice = updatedPrices[2];
        BigDecimal finalPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, finalPrice, false, commerceContext);
        boolean discountsTargetNetPrice = true;
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel != null) {
            discountsTargetNetPrice = commerceChannel.isDiscountsTargetNetPrice();
        }
        if (discountsTargetNetPrice) {
            commerceDiscountValue = this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPrice, commerceContext);
            finalPrice = finalPrice.multiply(BigDecimal.valueOf(quantity));
            if (commerceDiscountValue != null) {
                discountAmountMoney = commerceDiscountValue.getDiscountAmount();
                finalPrice = finalPrice.subtract(discountAmountMoney.getPrice());
            }
            finalPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, finalPrice, false, commerceContext);
        } else {
            commerceDiscountValue = this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPriceWithTaxAmount, commerceContext);
            finalPriceWithTaxAmount = finalPriceWithTaxAmount.multiply(BigDecimal.valueOf(quantity));
            if (commerceDiscountValue != null) {
                discountAmountMoney = commerceDiscountValue.getDiscountAmount();
                finalPriceWithTaxAmount = finalPriceWithTaxAmount.subtract(discountAmountMoney.getPrice());
            }
            finalPrice = this.getConvertedPrice(cpInstanceId, finalPriceWithTaxAmount, true, commerceContext);
        }
        CommerceProductPriceImpl commerceProductPriceImpl = new CommerceProductPriceImpl();
        commerceProductPriceImpl.setCommercePriceListId(this._getUsedCommercePriceList(cpInstanceId, commerceContext));
        commerceProductPriceImpl.setUnitPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), updatedPrices[0]));
        commerceProductPriceImpl.setUnitPromoPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), updatedPrices[1]));
        commerceProductPriceImpl.setQuantity(quantity);
        if (discountsTargetNetPrice) {
            commerceProductPriceImpl.setCommerceDiscountValue(commerceDiscountValue);
        } else {
            CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
            commerceProductPriceImpl.setCommerceDiscountValue(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(commerceDiscountValue, updatedPrices[2].multiply(BigDecimal.valueOf(quantity)), finalPrice, this._commerceMoneyFactory, RoundingMode.valueOf(commerceCurrency.getRoundingMode())));
        }
        commerceProductPriceImpl.setFinalPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPrice));
        if (commerceProductPriceRequest.isCalculateTax()) {
            this.setCommerceProductPriceWithTaxAmount(cpInstanceId, finalPriceWithTaxAmount, commerceProductPriceImpl, commerceContext, commerceDiscountValue, discountsTargetNetPrice);
        }
        return commerceProductPriceImpl;
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        long commercePriceListId;
        boolean calculateTax = false;
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel != null) {
            calculateTax = Objects.equals(commerceChannel.getPriceDisplayType(), "tax-included");
        }
        if ((commercePriceListId = this._getUsedCommercePriceList(cpInstanceId, commerceContext)) > 0L) {
            CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
            calculateTax = calculateTax || !commercePriceList.isNetPrice();
        }
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCpInstanceId(cpInstanceId);
        commerceProductPriceRequest.setQuantity(quantity);
        commerceProductPriceRequest.setSecure(secure);
        commerceProductPriceRequest.setCommerceContext(commerceContext);
        commerceProductPriceRequest.setCommerceOptionValues(null);
        commerceProductPriceRequest.setCalculateTax(calculateTax);
        return this.getCommerceProductPrice(commerceProductPriceRequest);
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceProductPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceProductPrice commerceProductPrice = this.getCommerceProductPrice(cpInstanceId, quantity, commerceContext);
        if (commerceProductPrice == null) {
            return null;
        }
        return commerceProductPrice.getFinalPrice();
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getFinalPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getPromoPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        Optional<BigDecimal> priceListPrice;
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        Optional<CommercePriceList> commercePriceList = this._getPriceList(cpInstance.getGroupId(), commerceContext);
        if (commercePriceList.isPresent() && (priceListPrice = this._getPriceListPrice(cpInstanceId, quantity, commercePriceList.get(), commerceContext, true)).isPresent()) {
            return this.commerceMoneyFactory.create(commerceCurrency, priceListPrice.get());
        }
        BigDecimal price = cpInstance.getPromoPrice();
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpInstance.getGroupId());
        CommerceCurrency catalogCommerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceCatalog.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
        if (catalogCommerceCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(catalogCommerceCurrency.getRate(), RoundingMode.valueOf(catalogCommerceCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        return this.commerceMoneyFactory.create(commerceCurrency, price);
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal maxPrice = BigDecimal.ZERO;
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (maxPrice.compareTo(cpInstanceCommerceMoney.getPrice()) >= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            maxPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMaxPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal minPrice = BigDecimal.ZERO;
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (commerceMoney != null && minPrice.compareTo(cpInstanceCommerceMoney.getPrice()) <= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            minPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMinPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        Optional<BigDecimal> priceListPrice;
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        Optional<CommercePriceList> commercePriceList = this._getPriceList(cpInstance.getGroupId(), commerceContext);
        if (commercePriceList.isPresent() && (priceListPrice = this._getPriceListPrice(cpInstanceId, quantity, commercePriceList.get(), commerceContext, false)).isPresent()) {
            return this.commerceMoneyFactory.create(commerceCurrency, priceListPrice.get());
        }
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpInstance.getGroupId());
        CommerceCurrency catalogCommerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceCatalog.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
        BigDecimal price = cpInstance.getPrice();
        if (catalogCommerceCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(catalogCommerceCurrency.getRate(), RoundingMode.valueOf(catalogCommerceCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        return this.commerceMoneyFactory.create(commerceCurrency, price);
    }

    private Optional<CommercePriceList> _getPriceList(long groupId, CommerceContext commerceContext) throws PortalException {
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        long commerceAccountId = 0L;
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
        }
        CommercePriceList commercePriceList = this._commercePriceListDiscovery.getCommercePriceList(groupId, commerceAccountId, commerceContext.getCommerceChannelId(), null, "price-list");
        return Optional.ofNullable(commercePriceList);
    }

    private Optional<BigDecimal> _getPriceListPrice(long cpInstanceId, int quantity, CommercePriceList commercePriceList, CommerceContext commerceContext, boolean promo) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry;
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        BigDecimal price = null;
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid());
        if (commercePriceEntry == null) {
            return Optional.empty();
        }
        price = promo ? commercePriceEntry.getPromoPrice() : commercePriceEntry.getPrice();
        if (commercePriceEntry.isHasTierPrice() && (commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.findClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity)) != null) {
            price = promo ? commerceTierPriceEntry.getPromoPrice() : commerceTierPriceEntry.getPrice();
        }
        if (!commercePriceList.isNetPrice()) {
            price = this.getConvertedPrice(cpInstance.getCPInstanceId(), price, true, commerceContext);
        }
        CommerceCurrency priceListCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId());
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        if (priceListCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(priceListCurrency.getRate(), RoundingMode.valueOf(priceListCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        return Optional.ofNullable(price);
    }

    private long _getUsedCommercePriceList(long cpInstanceId, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        Optional<CommercePriceList> commercePriceList = this._getPriceList(cpInstance.getGroupId(), commerceContext);
        if (commercePriceList.isPresent()) {
            CommercePriceList commercePriceListActive = commercePriceList.get();
            CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListActive.getCommercePriceListId(), cpInstance.getCPInstanceUuid());
            if (commercePriceEntry == null) {
                return 0L;
            }
            return commercePriceListActive.getCommercePriceListId();
        }
        return 0L;
    }
}

