/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/shipment_status"}, service={MessageListener.class})
public class CommerceShipmentStatusMessageListener
extends BaseMessageListener {
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;

    protected void doReceive(Message message) throws Exception {
        long commerceShipmentId = message.getLong("commerceShipmentId");
        List shippedCommerceOrders = this._commerceOrderLocalService.getShippedCommerceOrdersByCommerceShipmentId(commerceShipmentId, -1, -1);
        for (CommerceOrder commerceOrder : shippedCommerceOrders) {
            this._commerceOrderEngine.checkCommerceOrderShipmentStatus(commerceOrder);
        }
    }
}

