/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.util.PriceFormat;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.price.CommerceProductOptionValueRelativePriceRequest;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceProductPriceCalculation
implements CommerceProductPriceCalculation {
    @Reference
    protected CommerceMoneyFactory commerceMoneyFactory;
    @Reference
    protected CommerceTaxCalculation commerceTaxCalculation;
    @Reference
    protected CPDefinitionOptionRelLocalService cpDefinitionOptionRelLocalService;
    @Reference
    protected CPInstanceLocalService cpInstanceLocalService;

    public CommerceMoney getCPDefinitionMinimumPrice(long cpDefinitionId, CommerceContext commerceContext) throws PortalException {
        BigDecimal cpDefinitionMinimumPrice = BigDecimal.ZERO;
        CommerceMoney commerceMoney = this.getUnitMinPrice(cpDefinitionId, 1, commerceContext);
        cpDefinitionMinimumPrice = cpDefinitionMinimumPrice.add(commerceMoney.getPrice());
        List cpDefinitionOptionRels = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId);
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            if (!this._isRequiredPriceContributor(cpDefinitionOptionRel)) continue;
            if (cpDefinitionOptionRel.isPriceTypeStatic()) {
                cpDefinitionMinimumPrice = cpDefinitionMinimumPrice.add(this._getCPDefinitionOptionMinStaticPrice(cpDefinitionOptionRel, commerceContext));
                continue;
            }
            cpDefinitionMinimumPrice = cpDefinitionMinimumPrice.add(this._getCPDefinitionOptionMinDynamicPrice(cpDefinitionOptionRel, commerceContext));
        }
        return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), cpDefinitionMinimumPrice);
    }

    public CommerceMoney getCPDefinitionOptionValueRelativePrice(CommerceProductOptionValueRelativePriceRequest commerceProductOptionValueRelativePriceRequest) throws PortalException {
        this._validate(commerceProductOptionValueRelativePriceRequest.getCPDefinitionOptionValueRel(), commerceProductOptionValueRelativePriceRequest.getSelectedCPDefinitionOptionValueRel());
        BigDecimal relativePrice = BigDecimal.ZERO;
        CommerceContext commerceContext = commerceProductOptionValueRelativePriceRequest.getCommerceContext();
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = commerceProductOptionValueRelativePriceRequest.getCPDefinitionOptionValueRel();
        CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionValueRel.getCPDefinitionOptionRel();
        if (!cpDefinitionOptionRel.isPriceContributor()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), relativePrice, PriceFormat.RELATIVE);
        }
        relativePrice = relativePrice.add(this._getCPInstancePriceDifference(commerceProductOptionValueRelativePriceRequest.getCPInstanceId(), commerceProductOptionValueRelativePriceRequest.getCPInstanceMinQuantity(), commerceProductOptionValueRelativePriceRequest.getSelectedCPInstanceId(), commerceProductOptionValueRelativePriceRequest.getSelectedCPInstanceMinQuantity(), commerceContext));
        relativePrice = relativePrice.add(this._getCPDefinitionOptionValuePriceDifference(commerceProductOptionValueRelativePriceRequest.getCPDefinitionOptionValueRel(), commerceProductOptionValueRelativePriceRequest.getSelectedCPDefinitionOptionValueRel(), cpDefinitionOptionRel.getPriceType(), commerceContext));
        return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), relativePrice, PriceFormat.RELATIVE);
    }

    protected BigDecimal getConvertedPrice(long cpInstanceId, BigDecimal price, boolean includeTax, CommerceContext commerceContext) throws PortalException {
        long commerceChannelGroupId = commerceContext.getCommerceChannelGroupId();
        long commerceBillingAddressId = 0L;
        long commerceShippingAddressId = 0L;
        CommerceOrder commerceOrder = commerceContext.getCommerceOrder();
        if (commerceOrder != null) {
            commerceChannelGroupId = commerceOrder.getGroupId();
            commerceBillingAddressId = commerceOrder.getBillingAddressId();
            commerceShippingAddressId = commerceOrder.getShippingAddressId();
        } else {
            CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
            if (commerceAccount != null) {
                commerceBillingAddressId = commerceAccount.getDefaultBillingAddressId();
                commerceShippingAddressId = commerceAccount.getDefaultShippingAddressId();
            }
        }
        return CommercePriceConverterUtil.getConvertedPrice(commerceChannelGroupId, cpInstanceId, commerceBillingAddressId, commerceShippingAddressId, price, includeTax, this.commerceTaxCalculation);
    }

    protected BigDecimal[] getUpdatedPrices(BigDecimal unitPrice, BigDecimal promoPrice, BigDecimal finalPrice, CommerceContext commerceContext, List<CommerceOptionValue> commerceOptionValues) throws PortalException {
        if (commerceOptionValues == null || commerceOptionValues.isEmpty()) {
            return new BigDecimal[]{unitPrice, promoPrice, finalPrice};
        }
        for (CommerceOptionValue commerceOptionValue : commerceOptionValues) {
            if (this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                BigDecimal optionValuePrice = commerceOptionValue.getPrice();
                if (optionValuePrice == null || optionValuePrice.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (commerceOptionValue.getCPInstanceId() > 0L) {
                    optionValuePrice = optionValuePrice.multiply(BigDecimal.valueOf(commerceOptionValue.getQuantity()));
                }
                unitPrice = unitPrice.add(optionValuePrice);
                if (promoPrice != null && promoPrice.compareTo(BigDecimal.ZERO) > 0) {
                    promoPrice = promoPrice.add(optionValuePrice);
                }
                finalPrice = finalPrice.add(optionValuePrice);
                continue;
            }
            if (!Objects.equals(commerceOptionValue.getPriceType(), "dynamic")) continue;
            int optionValueQuantity = commerceOptionValue.getQuantity();
            CommerceProductPrice optionValueProductPrice = this.getCommerceProductPrice(commerceOptionValue.getCPInstanceId(), optionValueQuantity, true, commerceContext);
            CommerceMoney optionValueUnitPriceMoney = optionValueProductPrice.getUnitPrice();
            BigDecimal optionValueUnitPrice = optionValueUnitPriceMoney.getPrice();
            CommerceMoney optionValueUnitPromoPriceMoney = optionValueProductPrice.getUnitPromoPrice();
            BigDecimal optionValueUnitPromoPrice = optionValueUnitPromoPriceMoney.getPrice();
            if (optionValueUnitPromoPrice.compareTo(BigDecimal.ZERO) > 0 && promoPrice.compareTo(BigDecimal.ZERO) == 0) {
                promoPrice = promoPrice.add(unitPrice);
            } else if (optionValueUnitPromoPrice.compareTo(BigDecimal.ZERO) == 0 && promoPrice.compareTo(BigDecimal.ZERO) > 0) {
                promoPrice = promoPrice.add(optionValueUnitPrice.multiply(BigDecimal.valueOf(optionValueQuantity)));
            }
            unitPrice = unitPrice.add(optionValueUnitPrice.multiply(BigDecimal.valueOf(optionValueQuantity)));
            promoPrice = promoPrice.add(optionValueUnitPromoPrice.multiply(BigDecimal.valueOf(optionValueQuantity)));
            CommerceMoney optionValueFinalPriceMoney = optionValueProductPrice.getFinalPrice();
            finalPrice = finalPrice.add(optionValueFinalPriceMoney.getPrice());
        }
        return new BigDecimal[]{unitPrice, promoPrice, finalPrice};
    }

    protected void setCommerceProductPriceWithTaxAmount(long cpInstanceId, BigDecimal finalPriceWithTaxAmount, CommerceProductPriceImpl commerceProductPriceImpl, CommerceContext commerceContext, CommerceDiscountValue commerceDiscountValue, boolean discountsTargetNetPrice) throws PortalException {
        BigDecimal unitPriceWithTaxAmount;
        CommerceMoney unitPriceMoney = commerceProductPriceImpl.getUnitPrice();
        BigDecimal activePrice = unitPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, unitPriceMoney.getPrice(), false, commerceContext);
        CommerceMoney promoPriceMoney = commerceProductPriceImpl.getUnitPromoPrice();
        BigDecimal promoPrice = promoPriceMoney.getPrice();
        if (promoPrice != null && promoPrice.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal unitPromoPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, promoPriceMoney.getPrice(), false, commerceContext);
            commerceProductPriceImpl.setUnitPromoPriceWithTaxAmount(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), unitPromoPriceWithTaxAmount));
            activePrice = unitPromoPriceWithTaxAmount;
        } else {
            commerceProductPriceImpl.setUnitPromoPriceWithTaxAmount(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO));
        }
        commerceProductPriceImpl.setUnitPriceWithTaxAmount(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), unitPriceWithTaxAmount));
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        int quantity = commerceProductPriceImpl.getQuantity();
        activePrice = activePrice.multiply(BigDecimal.valueOf(quantity));
        if (discountsTargetNetPrice) {
            commerceProductPriceImpl.setCommerceDiscountValueWithTaxAmount(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(commerceDiscountValue, activePrice, finalPriceWithTaxAmount, this.commerceMoneyFactory, RoundingMode.valueOf(commerceCurrency.getRoundingMode())));
        } else {
            commerceProductPriceImpl.setCommerceDiscountValueWithTaxAmount(commerceDiscountValue);
        }
        commerceProductPriceImpl.setFinalPriceWithTaxAmount(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPriceWithTaxAmount));
    }

    private BigDecimal _getCPDefinitionOptionMinDynamicPrice(CPDefinitionOptionRel cpDefinitionOptionRel, CommerceContext commerceContext) throws PortalException {
        List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
        if (cpDefinitionOptionValueRels.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Iterator iterator = cpDefinitionOptionValueRels.iterator();
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
        BigDecimal cpDefinitionOptionMinDynamicPrice = this._getCPInstanceFinalPrice(cpDefinitionOptionValueRel.getCProductId(), cpDefinitionOptionValueRel.getCPInstanceUuid(), cpDefinitionOptionValueRel.getQuantity(), commerceContext);
        while (iterator.hasNext()) {
            cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
            BigDecimal cpInstanceFinalPrice = this._getCPInstanceFinalPrice(cpDefinitionOptionValueRel.getCProductId(), cpDefinitionOptionValueRel.getCPInstanceUuid(), cpDefinitionOptionValueRel.getQuantity(), commerceContext);
            if (cpDefinitionOptionMinDynamicPrice.compareTo(cpInstanceFinalPrice) <= 0) continue;
            cpDefinitionOptionMinDynamicPrice = cpInstanceFinalPrice;
        }
        return cpDefinitionOptionMinDynamicPrice;
    }

    private BigDecimal _getCPDefinitionOptionMinStaticPrice(CPDefinitionOptionRel cpDefinitionOptionRel, CommerceContext commerceContext) throws PortalException {
        List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
        if (cpDefinitionOptionValueRels.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Iterator iterator = cpDefinitionOptionValueRels.iterator();
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
        BigDecimal cpDefinitionOptionMinStaticPrice = this._getCPDefinitionOptionValueFinalPrice(cpDefinitionOptionValueRel.getPrice(), cpDefinitionOptionValueRel.getQuantity());
        while (iterator.hasNext()) {
            cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
            BigDecimal cpDefinitionOptionValueFinalPrice = this._getCPDefinitionOptionValueFinalPrice(cpDefinitionOptionValueRel.getPrice(), cpDefinitionOptionValueRel.getQuantity());
            if (cpDefinitionOptionMinStaticPrice.compareTo(cpDefinitionOptionValueFinalPrice) <= 0) continue;
            cpDefinitionOptionMinStaticPrice = cpDefinitionOptionValueFinalPrice;
        }
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        return cpDefinitionOptionMinStaticPrice.multiply(commerceCurrency.getRate());
    }

    private BigDecimal _getCPDefinitionOptionValueFinalPrice(BigDecimal price, int quantity) {
        return price.multiply(BigDecimal.valueOf(quantity));
    }

    private BigDecimal _getCPDefinitionOptionValuePriceDifference(CPDefinitionOptionValueRel cpDefinitionOptionValueRel, CPDefinitionOptionValueRel selectedCPDefinitionOptionValueRel, String priceType, CommerceContext commerceContext) throws PortalException {
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        if (this._isStaticPriceType(priceType)) {
            BigDecimal price = cpDefinitionOptionValueRel.getPrice();
            if (selectedCPDefinitionOptionValueRel != null) {
                price = price.subtract(selectedCPDefinitionOptionValueRel.getPrice());
            }
            return price.multiply(commerceCurrency.getRate());
        }
        BigDecimal cpInstanceFinalPrice = this._getCPInstanceFinalPrice(cpDefinitionOptionValueRel.getCProductId(), cpDefinitionOptionValueRel.getCPInstanceUuid(), cpDefinitionOptionValueRel.getQuantity(), commerceContext);
        if (selectedCPDefinitionOptionValueRel == null) {
            return cpInstanceFinalPrice;
        }
        BigDecimal selectedCPInstanceFinalPrice = this._getCPInstanceFinalPrice(selectedCPDefinitionOptionValueRel.getCProductId(), selectedCPDefinitionOptionValueRel.getCPInstanceUuid(), selectedCPDefinitionOptionValueRel.getQuantity(), commerceContext);
        return cpInstanceFinalPrice.subtract(selectedCPInstanceFinalPrice);
    }

    private BigDecimal _getCPInstanceFinalPrice(long cProductId, String cpInstanceUuid, int quantity, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCProductInstance(cProductId, cpInstanceUuid);
        CommerceMoney commerceMoney = this.getFinalPrice(cpInstance.getCPInstanceId(), quantity, commerceContext);
        return commerceMoney.getPrice();
    }

    private BigDecimal _getCPInstancePriceDifference(long cpInstanceId, int cpInstanceMinQuantity, long selectedCPInstanceId, int selectedCPInstanceMinQuantity, CommerceContext commerceContext) throws PortalException {
        BigDecimal priceDifference = BigDecimal.ZERO;
        if (cpInstanceId > 0L) {
            CommerceMoney cpInstanceFinalPrice = this.getFinalPrice(cpInstanceId, cpInstanceMinQuantity, commerceContext);
            priceDifference = priceDifference.add(cpInstanceFinalPrice.getPrice());
        }
        BigDecimal selectedCPInstanceFinalPrice = BigDecimal.ZERO;
        if (selectedCPInstanceId > 0L) {
            CommerceMoney commerceMoney = this.getFinalPrice(selectedCPInstanceId, selectedCPInstanceMinQuantity, commerceContext);
            selectedCPInstanceFinalPrice = commerceMoney.getPrice();
        }
        return priceDifference.subtract(selectedCPInstanceFinalPrice);
    }

    private boolean _isRequiredPriceContributor(CPDefinitionOptionRel cpDefinitionOptionRel) {
        return cpDefinitionOptionRel.isPriceContributor() && (cpDefinitionOptionRel.isRequired() || cpDefinitionOptionRel.isSkuContributor());
    }

    private boolean _isStaticPriceType(String value) {
        return Objects.equals(value, "static");
    }

    private void _validate(CPDefinitionOptionValueRel cpDefinitionOptionValueRel, CPDefinitionOptionValueRel selectedCPDefinitionOptionValueRel) {
        if (selectedCPDefinitionOptionValueRel != null && cpDefinitionOptionValueRel.getCPDefinitionOptionRelId() != selectedCPDefinitionOptionValueRel.getCPDefinitionOptionRelId()) {
            throw new IllegalArgumentException("Provided CPDefinitionOptionValueRel parameters must belong to the same CPDefinitionOptionRel");
        }
    }
}

