/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.inventory;

import com.liferay.commerce.inventory.CommerceInventoryChecker;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.inventory.checker.target=CPInstanceOptionValueRel"}, service={CommerceInventoryChecker.class})
public class CPInstanceOptionValueRelCommerceInventoryCheckerImpl
implements CommerceInventoryChecker<CPInstanceOptionValueRel> {
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    public List<CPInstanceOptionValueRel> filterByAvailability(List<CPInstanceOptionValueRel> cpInstanceOptionValueRels) {
        ArrayList<CPInstanceOptionValueRel> filtered = new ArrayList<CPInstanceOptionValueRel>();
        for (CPInstanceOptionValueRel cpDefinitionOptionValueRel : cpInstanceOptionValueRels) {
            if (!this.isAvailable((BaseModel<CPInstanceOptionValueRel>)cpDefinitionOptionValueRel)) continue;
            filtered.add(cpDefinitionOptionValueRel);
        }
        return filtered;
    }

    public boolean isAvailable(BaseModel<CPInstanceOptionValueRel> baseModel) {
        CPInstanceOptionValueRel cpInstanceOptionValueRel = (CPInstanceOptionValueRel)baseModel;
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceOptionValueRel.getCPInstanceId());
        if (cpInstance == null) {
            return false;
        }
        return this._commerceInventoryEngine.hasStockQuantity(cpInstance.getCompanyId(), cpInstance.getSku(), 1);
    }
}

