/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.exception.CommerceOrderItemRequestedDeliveryDateException;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.exception.GuestCartItemMaxAllowedException;
import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.exception.ProductBundleException;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceCalculationFactory;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.option.CommerceOptionValueHelper;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.commerce.service.base.CommerceOrderItemLocalServiceBaseImpl;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommerceOrderItemLocalServiceImpl
extends CommerceOrderItemLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};
    @ServiceReference(type=CommerceInventoryBookedQuantityLocalService.class)
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @ServiceReference(type=CommerceInventoryWarehouseItemLocalService.class)
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @ServiceReference(type=CommerceMoneyFactory.class)
    private CommerceMoneyFactory _commerceMoneyFactory;
    @ServiceReference(type=CommerceOptionValueHelper.class)
    private CommerceOptionValueHelper _commerceOptionValueHelper;
    @ServiceReference(type=CommerceOrderConfiguration.class)
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @ServiceReference(type=CommerceOrderValidatorRegistry.class)
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @ServiceReference(type=CommerceProductPriceCalculationFactory.class)
    private CommerceProductPriceCalculationFactory _commerceProductPriceCalculationFactory;
    @ServiceReference(type=CommerceShippingHelper.class)
    private CommerceShippingHelper _commerceShippingHelper;
    @ServiceReference(type=CommerceTaxCalculation.class)
    private CommerceTaxCalculation _commerceTaxCalculation;
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CPDefinitionOptionRelLocalService.class)
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @ServiceReference(type=CPInstanceLocalService.class)
    private CPInstanceLocalService _cpInstanceLocalService;
    @ServiceReference(type=JsonHelper.class)
    private JsonHelper _jsonHelper;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)json)) {
            json = this._getCPInstanceOptionValueRelsJSONString(cpInstanceId);
        }
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        this.updateWorkflow(commerceOrder, serviceContext);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceOrderItem commerceOrderItem = this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, cpInstance, json, 0L, quantity, shippedQuantity, commerceContext, serviceContext);
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        List commerceOptionValues = this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpInstance.getCPDefinitionId(), json);
        for (CommerceOptionValue commerceOptionValue : commerceOptionValues) {
            if (Validator.isNull((String)commerceOptionValue.getPriceType()) || this._isStaticPriceType(commerceOptionValue.getPriceType()) && commerceOptionValue.getCPInstanceId() <= 0L) continue;
            CPInstance commerceOptionValueCPInstance = this._cpInstanceLocalService.getCPInstance(commerceOptionValue.getCPInstanceId());
            CommerceOrderItem childCommerceOrderItem = this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, commerceOptionValueCPInstance, commerceOptionValue.toJSON(), commerceOrderItem.getCommerceOrderItemId(), commerceOptionValue.getQuantity(), 0, commerceContext, serviceContext);
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                childCommerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
                continue;
            }
            CommerceProductPrice commerceProductPrice = this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), commerceOptionValue.getQuantity(), commerceOptionValue.getPrice(), childCommerceOrderItem.getCommerceOrder(), commerceContext.getCommerceCurrency());
            this._setCommerceOrderItemPrice(childCommerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(childCommerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(childCommerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
            this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
        }
        this.commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    public int countSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByC_S(commerceOrderId, true);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem) throws PortalException {
        this.validateParentCommerceOrderId(commerceOrderItem);
        return this._deleteCommerceOrderItem(commerceOrderItem);
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem, CommerceContext commerceContext) throws PortalException {
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        if (this._commerceShippingHelper.isFreeShipping(commerceOrder)) {
            this.commerceOrderLocalService.updateShippingMethod(commerceOrder.getCommerceOrderId(), 0L, null, BigDecimal.ZERO, commerceContext);
        }
        this.commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    @Override
    public CommerceOrderItem deleteCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
    }

    public void deleteCommerceOrderItems(long commerceOrderId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this._deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public void deleteCommerceOrderItemsByCPInstanceId(long cpInstanceId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCPInstanceId(cpInstanceId);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public CommerceOrderItem fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceOrderItemPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceOrderItem fetchCommerceOrderItemByBookedQuantityId(long bookedQuantityId) {
        return this.commerceOrderItemPersistence.fetchByBookedQuantityId(bookedQuantityId);
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemFinder.findByAvailableQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getChildCommerceOrderItems(long parentCommerceOrderItemId) {
        return this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(parentCommerceOrderItemId);
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, commerceOrderItem.getSku());
        if (commerceInventoryWarehouseItem == null) {
            return 0;
        }
        return commerceInventoryWarehouseItem.getQuantity();
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end) {
        return this.commerceOrderItemPersistence.findByC_I(commerceOrderId, cpInstanceId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByC_I(commerceOrderId, cpInstanceId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long groupId, long commerceAccountId, int[] orderStatuses, int start, int end) {
        return this.commerceOrderItemFinder.findByG_A_O(groupId, commerceAccountId, orderStatuses, start, end);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) {
        return this.commerceOrderItemPersistence.countByC_I(commerceOrderId, cpInstanceId);
    }

    public int getCommerceOrderItemsCount(long groupId, long commerceAccountId, int[] orderStatuses) {
        return this.commerceOrderItemFinder.countByG_A_O(groupId, commerceAccountId, orderStatuses);
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) {
        return this.commerceOrderItemFinder.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.findByC_S(commerceOrderId, true);
    }

    public CommerceOrderItem incrementShippedQuantity(long commerceOrderItemId, int shippedQuantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        shippedQuantity = commerceOrderItem.getShippedQuantity() + shippedQuantity;
        if (shippedQuantity < 0) {
            shippedQuantity = 0;
        }
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, long parentCommerceOrderItemId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, parentCommerceOrderItemId, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, null, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String sku, String name, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, null, start, end, sort);
        searchContext.setAndSearch(andOperator);
        searchContext.setAttribute("sku", (Serializable)((Object)sku));
        searchContext.setAttribute("name", (Serializable)((Object)name));
        return this.searchCommerceOrderItems(searchContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, quantity, commerceOrderItem.getJson(), commerceContext, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this.validateParentCommerceOrderId(commerceOrderItem);
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        if (childCommerceOrderItems.isEmpty()) {
            return this._updateCommerceOrderItem(commerceOrderItemId, quantity, json, null, commerceContext, serviceContext);
        }
        List commerceOptionValues = this._commerceOptionValueHelper.toCommerceOptionValues(json);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            CommerceOptionValue matchedCommerceOptionValue = commerceOptionValue.getFirstMatch(commerceOptionValues);
            if (matchedCommerceOptionValue == null) {
                throw new NoSuchOrderItemException("Child commerce order item does not match any JSON item");
            }
            int currentQuantity = quantity * commerceOptionValue.getQuantity();
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                this._updateCommerceOrderItem(childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), null, commerceContext, serviceContext);
                continue;
            }
            CommerceProductPrice staticCommerceProductPrice = this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), currentQuantity, commerceOptionValue.getPrice(), childCommerceOrderItem.getCommerceOrder(), commerceContext.getCommerceCurrency());
            this._updateCommerceOrderItem(childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), staticCommerceProductPrice, commerceContext, serviceContext);
        }
        return this._updateCommerceOrderItem(commerceOrderItemId, quantity, json, null, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long bookedQuantityId) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setBookedQuantityId(bookedQuantityId);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        Date requestedDeliveryDate = PortalUtil.getDate((int)requestedDeliveryDateMonth, (int)requestedDeliveryDateDay, (int)requestedDeliveryDateYear);
        if (requestedDeliveryDate != null && requestedDeliveryDate.before(new Date())) {
            throw new CommerceOrderItemRequestedDeliveryDateException();
        }
        commerceOrderItem.setDeliveryGroup(deliveryGroup);
        commerceOrderItem.setShippingAddressId(shippingAddressId);
        commerceOrderItem.setPrintedNote(printedNote);
        commerceOrderItem.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, deliveryGroup, shippingAddressId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrice(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (commerceOrderItem.isManuallyAdjusted() || commerceOrderItem.getParentCommerceOrderItemId() != 0L) {
            return commerceOrderItem;
        }
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null) {
            return commerceOrderItem;
        }
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                this._setCommerceOrderItemPrice(childCommerceOrderItem, null, commerceContext);
            } else {
                this._setCommerceOrderItemPrice(childCommerceOrderItem, this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), childCommerceOrderItem.getQuantity(), commerceOptionValue.getPrice(), childCommerceOrderItem.getCommerceOrder(), commerceContext.getCommerceCurrency()), commerceContext);
            }
            this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
        }
        this._setCommerceOrderItemPrice(commerceOrderItem, null, commerceContext);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal unitPrice, BigDecimal promoPrice, BigDecimal discountAmount, BigDecimal finalPrice, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this.validateParentCommerceOrderId(commerceOrderItem);
        commerceOrderItem.setUnitPrice(unitPrice);
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setDiscountAmount(discountAmount);
        commerceOrderItem.setFinalPrice(finalPrice);
        commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
        commerceOrderItem.setManuallyAdjusted(true);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal unitPrice, BigDecimal promoPrice, BigDecimal discountAmount, BigDecimal finalPrice, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4, BigDecimal unitPriceWithTaxAmount, BigDecimal promoPriceWithTaxAmount, BigDecimal discountAmountWithTaxAmount, BigDecimal finalPriceWithTaxAmount, BigDecimal discountPercentageLevel1WithTaxAmount, BigDecimal discountPercentageLevel2WithTaxAmount, BigDecimal discountPercentageLevel3WithTaxAmount, BigDecimal discountPercentageLevel4WithTaxAmount) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setUnitPrice(unitPrice);
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setDiscountAmount(discountAmount);
        commerceOrderItem.setFinalPrice(finalPrice);
        commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
        commerceOrderItem.setUnitPriceWithTaxAmount(unitPriceWithTaxAmount);
        commerceOrderItem.setPromoPriceWithTaxAmount(promoPriceWithTaxAmount);
        commerceOrderItem.setDiscountWithTaxAmount(discountAmountWithTaxAmount);
        commerceOrderItem.setFinalPriceWithTaxAmount(finalPriceWithTaxAmount);
        commerceOrderItem.setDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1WithTaxAmount);
        commerceOrderItem.setDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2WithTaxAmount);
        commerceOrderItem.setDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3WithTaxAmount);
        commerceOrderItem.setDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4WithTaxAmount);
        commerceOrderItem.setManuallyAdjusted(true);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setUnitPrice(unitPrice);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long userId, long commerceOrderItemId, BigDecimal unitPrice, int quantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this._updateBookedQuantity(userId, commerceOrderItem, commerceOrderItem.getBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setUnitPrice(unitPrice);
        commerceOrderItem.setManuallyAdjusted(true);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem upsertCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        String cpInstanceOptionValueRelJSONString = this._getCPInstanceOptionValueRelsJSONString(cpInstanceId);
        return this.commerceOrderItemLocalService.upsertCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, 0, cpInstanceOptionValueRelJSONString, commerceContext, serviceContext);
    }

    public CommerceOrderItem upsertCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(commerceOrderId, cpInstanceId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (commerceOrderItem.getParentCommerceOrderItemId() != 0L || !this._jsonMatches(json, commerceOrderItem.getJson())) continue;
            return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceOrderItem.getQuantity() + quantity, commerceOrderItem.getJson(), commerceContext, serviceContext);
        }
        return this.commerceOrderItemLocalService.addCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, 0, json, commerceContext, serviceContext);
    }

    protected SearchContext buildSearchContext(long commerceOrderId, Long parentCommerceOrderItemId, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = new SearchContext();
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        searchContext.setAttribute("commerceOrderId", (Serializable)Long.valueOf(commerceOrderId));
        if (parentCommerceOrderItemId != null) {
            searchContext.setAttribute("parentCommerceOrderItemId", (Serializable)parentCommerceOrderItemId);
        }
        searchContext.setCompanyId(commerceOrder.getCompanyId());
        searchContext.setEnd(end);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected List<CommerceOrderItem> getCommerceOrderItems(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrderItem> commerceOrderItems = new ArrayList<CommerceOrderItem>(documents.size());
        for (Document document : documents) {
            long commerceOrderItemId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrderItem commerceOrderItem = this.fetchCommerceOrderItem(commerceOrderItemId);
            if (commerceOrderItem == null) {
                commerceOrderItems = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceOrderItem.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceOrderItems == null) continue;
            commerceOrderItems.add(commerceOrderItem);
        }
        return commerceOrderItems;
    }

    protected BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceOrderItem.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(hits);
            if (commerceOrderItems == null) continue;
            return new BaseModelSearchResult(commerceOrderItems, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void updateWorkflow(CommerceOrder commerceOrder, ServiceContext serviceContext) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 0L, true);
        if (workflowDefinitionLink != null && commerceOrder.isApproved()) {
            this.commerceOrderLocalService.updateStatus(serviceContext.getUserId(), commerceOrder.getCommerceOrderId(), 2, serviceContext, Collections.emptyMap());
        }
    }

    protected void validate(Locale locale, CommerceOrder commerceOrder, CPDefinition cpDefinition, CPInstance cpInstance, int quantity) throws PortalException {
        List commerceCartValidatorResults;
        int count;
        if (commerceOrder.getUserId() == 0L && (count = this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrder.getCommerceOrderId())) >= this._commerceOrderConfiguration.guestCartItemMaxAllowed()) {
            throw new GuestCartItemMaxAllowedException();
        }
        if (cpDefinition != null && cpInstance != null && cpDefinition.getCPDefinitionId() != cpInstance.getCPDefinitionId()) {
            throw new NoSuchCPInstanceException(StringBundler.concat((Object[])new Object[]{"CPInstance ", cpInstance.getCPInstanceId(), " belongs to a different CPDefinition than ", cpDefinition.getCPDefinitionId()}));
        }
        if (!ExportImportThreadLocal.isImportInProcess() && !(commerceCartValidatorResults = this._commerceOrderValidatorRegistry.validate(locale, commerceOrder, cpInstance, quantity)).isEmpty()) {
            throw new CommerceOrderValidatorException(commerceCartValidatorResults);
        }
    }

    protected void validateParentCommerceOrderId(CommerceOrderItem commerceOrderItem) throws PortalException {
        if (commerceOrderItem.getParentCommerceOrderItemId() != 0L) {
            throw new ProductBundleException(StringBundler.concat((Object[])new Object[]{"Operation not allowed on an item ", commerceOrderItem.getCommerceOrderItemId(), " because it is a child commerce order item ", commerceOrderItem.getParentCommerceOrderItemId()}));
        }
    }

    private CommerceOrderItem _createCommerceOrderItem(long groupId, User user, CommerceOrder commerceOrder, CPInstance cpInstance, String json, long parentCommerceOrderItemId, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        this.validate(serviceContext.getLocale(), commerceOrder, cpDefinition, cpInstance, quantity);
        long commerceOrderItemId = this.counterLocalService.increment();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.create(commerceOrderItemId);
        commerceOrderItem.setGroupId(groupId);
        commerceOrderItem.setCompanyId(user.getCompanyId());
        commerceOrderItem.setUserId(user.getUserId());
        commerceOrderItem.setUserName(user.getFullName());
        commerceOrderItem.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderItem.setCProductId(cpDefinition.getCProductId());
        commerceOrderItem.setCPInstanceId(cpInstance.getCPInstanceId());
        commerceOrderItem.setParentCommerceOrderItemId(parentCommerceOrderItemId);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        commerceOrderItem.setJson(json);
        CommerceProductPrice commerceProductPrice = this._getCommerceProductPrice(cpInstance.getCPDefinitionId(), cpInstance.getCPInstanceId(), json, quantity, commerceContext);
        this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
        commerceOrderItem.setNameMap(cpDefinition.getNameMap());
        commerceOrderItem.setSku(cpInstance.getSku());
        commerceOrderItem.setManuallyAdjusted(false);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        commerceOrderItem.setSubscription(this._isSubscription(cpInstance));
        return commerceOrderItem;
    }

    private void _deleteBundleChildrenOrderItems(long commerceOrderItemId) throws PortalException {
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            childCommerceOrderItem.setParentCommerceOrderItemId(0L);
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(childCommerceOrderItem);
        }
    }

    private CommerceOrderItem _deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity;
        this._deleteBundleChildrenOrderItems(commerceOrderItem.getCommerceOrderItemId());
        this.commerceOrderItemPersistence.remove((BaseModel)commerceOrderItem);
        if (commerceOrderItem.getBookedQuantityId() > 0L && (commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(commerceOrderItem.getBookedQuantityId())) != null) {
            this._commerceInventoryBookedQuantityLocalService.deleteCommerceInventoryBookedQuantity(commerceInventoryBookedQuantity);
        }
        this.expandoRowLocalService.deleteRows(commerceOrderItem.getCommerceOrderItemId());
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        this.updateWorkflow(commerceOrder, serviceContext);
        return commerceOrderItem;
    }

    private CommerceProductPrice _getCommerceProductPrice(long cpDefinitionId, long cpInstanceId, String json, int quantity, CommerceContext commerceContext) throws PortalException {
        CommerceProductPriceCalculation commerceProductPriceCalculation = this._commerceProductPriceCalculationFactory.getCommerceProductPriceCalculation();
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCpInstanceId(cpInstanceId);
        commerceProductPriceRequest.setQuantity(quantity);
        commerceProductPriceRequest.setSecure(false);
        commerceProductPriceRequest.setCommerceContext(commerceContext);
        commerceProductPriceRequest.setCommerceOptionValues(this._getStaticOptionValuesNotLinkedToSku(cpDefinitionId, json));
        commerceProductPriceRequest.setCalculateTax(true);
        return commerceProductPriceCalculation.getCommerceProductPrice(commerceProductPriceRequest);
    }

    private BigDecimal _getConvertedPrice(long cpInstanceId, BigDecimal price, CommerceOrder commerceOrder) throws PortalException {
        return CommercePriceConverterUtil.getConvertedPrice(commerceOrder.getGroupId(), cpInstanceId, commerceOrder.getBillingAddressId(), commerceOrder.getShippingAddressId(), price, false, this._commerceTaxCalculation);
    }

    private String _getCPInstanceOptionValueRelsJSONString(long cpInstanceId) throws PortalException {
        JSONArray jsonArray = this._jsonHelper.toJSONArray(this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstanceId));
        return jsonArray.toString();
    }

    private CommerceProductPrice _getStaticCommerceProductPrice(long cpInstanceId, int quantity, BigDecimal optionValuePrice, CommerceOrder commerceOrder, CommerceCurrency commerceCurrency) throws PortalException {
        CommerceProductPriceImpl commerceProductPrice = new CommerceProductPriceImpl();
        if (optionValuePrice == null) {
            optionValuePrice = BigDecimal.ZERO;
        }
        commerceProductPrice.setUnitPrice(this._commerceMoneyFactory.create(commerceCurrency, optionValuePrice));
        commerceProductPrice.setUnitPromoPrice(this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO));
        commerceProductPrice.setUnitPromoPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO));
        BigDecimal unitPriceWithTaxAmount = optionValuePrice;
        BigDecimal finalPriceWithTaxAmount = optionValuePrice;
        if (cpInstanceId > 0L) {
            unitPriceWithTaxAmount = this._getConvertedPrice(cpInstanceId, optionValuePrice, commerceOrder);
            optionValuePrice = optionValuePrice.multiply(BigDecimal.valueOf(quantity));
            finalPriceWithTaxAmount = this._getConvertedPrice(cpInstanceId, optionValuePrice, commerceOrder);
        }
        commerceProductPrice.setUnitPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, unitPriceWithTaxAmount));
        commerceProductPrice.setFinalPrice(this._commerceMoneyFactory.create(commerceCurrency, optionValuePrice));
        commerceProductPrice.setFinalPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, finalPriceWithTaxAmount));
        commerceProductPrice.setCommerceDiscountValue(null);
        commerceProductPrice.setQuantity(quantity);
        return commerceProductPrice;
    }

    private List<CommerceOptionValue> _getStaticOptionValuesNotLinkedToSku(long cpDefinitionId, String jsonArrayString) throws PortalException {
        List commerceOptionValues = this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpDefinitionId, jsonArrayString);
        Stream commerceOptionValuesStream = commerceOptionValues.stream();
        Stream<CommerceOptionValue> commerceOptionValuesFiltered = commerceOptionValuesStream.filter(commerceOptionValue -> this._isStaticPriceType(commerceOptionValue.getPriceType()) && commerceOptionValue.getCPInstanceId() == 0L);
        return commerceOptionValuesFiltered.collect(Collectors.toList());
    }

    private boolean _isStaticPriceType(Object value) {
        return Objects.equals(value, "static");
    }

    private boolean _isSubscription(CPInstance cpInstance) throws PortalException {
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (cpDefinition.isSubscriptionEnabled() || cpDefinition.isDeliverySubscriptionEnabled()) {
            return true;
        }
        return cpInstance.isOverrideSubscriptionInfo() && (cpInstance.isSubscriptionEnabled() || cpInstance.isDeliverySubscriptionEnabled());
    }

    private boolean _jsonMatches(String json1, String json2) {
        if (this._jsonHelper.isEmpty(json1) && this._jsonHelper.isEmpty(json2)) {
            return true;
        }
        return this._jsonHelper.equals(json1, json2);
    }

    private void _setCommerceOrderItemDiscountValue(CommerceOrderItem commerceOrderItem, CommerceDiscountValue commerceDiscountValue, boolean includeTax) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1 && percentages[0] != null) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2 && percentages[1] != null) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3 && percentages[2] != null) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4 && percentages[3] != null) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (includeTax) {
            commerceOrderItem.setDiscountWithTaxAmount(discountAmount);
            commerceOrderItem.setDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrderItem.setDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrderItem.setDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrderItem.setDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
        } else {
            commerceOrderItem.setDiscountAmount(discountAmount);
            commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderItemPrice(CommerceOrderItem commerceOrderItem, CommerceProductPrice commerceProductPrice) {
        CommerceMoney finalPriceMoneyWithTaxAmount;
        CommerceMoney unitPromoMoneyPriceWithTaxAmount;
        CommerceMoney unitPriceMoney = commerceProductPrice.getUnitPrice();
        commerceOrderItem.setUnitPrice(unitPriceMoney.getPrice());
        BigDecimal promoPrice = BigDecimal.ZERO;
        BigDecimal promoPriceWithTaxAmount = BigDecimal.ZERO;
        CommerceMoney unitPromoPriceMoney = commerceProductPrice.getUnitPromoPrice();
        if (unitPromoPriceMoney != null) {
            promoPrice = unitPromoPriceMoney.getPrice();
        }
        if ((unitPromoMoneyPriceWithTaxAmount = commerceProductPrice.getUnitPromoPriceWithTaxAmount()) != null) {
            promoPriceWithTaxAmount = unitPromoMoneyPriceWithTaxAmount.getPrice();
        }
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setPromoPriceWithTaxAmount(promoPriceWithTaxAmount);
        CommerceMoney finalPriceMoney = commerceProductPrice.getFinalPrice();
        commerceOrderItem.setFinalPrice(finalPriceMoney.getPrice());
        CommerceMoney unitPriceMoneyWithTaxAmount = commerceProductPrice.getUnitPriceWithTaxAmount();
        if (unitPriceMoneyWithTaxAmount != null) {
            commerceOrderItem.setUnitPriceWithTaxAmount(unitPriceMoneyWithTaxAmount.getPrice());
        }
        if ((finalPriceMoneyWithTaxAmount = commerceProductPrice.getFinalPriceWithTaxAmount()) != null) {
            commerceOrderItem.setFinalPriceWithTaxAmount(finalPriceMoneyWithTaxAmount.getPrice());
        }
        commerceOrderItem.setCommercePriceListId(commerceProductPrice.getCommercePriceListId());
    }

    private void _setCommerceOrderItemPrice(CommerceOrderItem commerceOrderItem, CommerceProductPrice commerceProductPrice, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null || commerceOrderItem.isManuallyAdjusted()) {
            return;
        }
        if (commerceProductPrice == null) {
            commerceProductPrice = this._getCommerceProductPrice(commerceOrderItem.getCPDefinitionId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), commerceOrderItem.getQuantity(), commerceContext);
        }
        this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
    }

    private void _updateBookedQuantity(long userId, CommerceOrderItem commerceOrderItem, long bookedQuantityId, int quantity, int oldQuantity) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity;
        if (oldQuantity != quantity && bookedQuantityId > 0L && (commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(bookedQuantityId)) != null) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("orderId", String.valueOf(commerceOrderItem.getCommerceOrderId()));
            context.put("orderItemId", String.valueOf(commerceOrderItem.getCommerceOrderItemId()));
            this._commerceInventoryBookedQuantityLocalService.updateCommerceInventoryBookedQuantity(userId, commerceInventoryBookedQuantity.getCommerceInventoryBookedQuantityId(), quantity, context, commerceInventoryBookedQuantity.getMvccVersion());
        }
    }

    private CommerceOrderItem _updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, CommerceProductPrice commerceProductPrice, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this._updateBookedQuantity(serviceContext.getUserId(), commerceOrderItem, commerceOrderItem.getBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        if (commerceProductPrice == null) {
            commerceProductPrice = this._getCommerceProductPrice(commerceOrderItem.getCPDefinitionId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), quantity, commerceContext);
        }
        this.validate(serviceContext.getLocale(), commerceOrderItem.getCommerceOrder(), commerceOrderItem.getCPDefinition(), commerceOrderItem.fetchCPInstance(), quantity);
        this.updateWorkflow(commerceOrderItem.getCommerceOrder(), serviceContext);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setJson(json);
        this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        this.commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }
}

