/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceSubscriptionEntryIndexer
extends BaseIndexer<CommerceSubscriptionEntry> {
    public static final String CLASS_NAME = CommerceSubscriptionEntry.class.getName();
    public static final String FIELD_COMMERCE_ORDER_ITEM_ID = "commerceOrderItemId";
    public static final String FIELD_CP_INSTANCE_ID = "CPInstanceId";
    public static final String FIELD_MAX_SUBSCRIPTION_CYCLES = "maxSubscriptionCycles";
    public static final String FIELD_SKU = "sku";
    public static final String FIELD_SUBSCRIPTION_STATUS = "subscriptionStatus";
    private static final Log _log = LogFactoryUtil.getLog(CommerceSubscriptionEntryIndexer.class);
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Integer subscriptionStatus;
        Long maxSubscriptionCycles = (Long)searchContext.getAttribute(FIELD_MAX_SUBSCRIPTION_CYCLES);
        if (maxSubscriptionCycles != null) {
            contextBooleanFilter.addTerm(FIELD_MAX_SUBSCRIPTION_CYCLES, String.valueOf(maxSubscriptionCycles), BooleanClauseOccur.MUST);
        }
        if ((subscriptionStatus = (Integer)searchContext.getAttribute(FIELD_SUBSCRIPTION_STATUS)) != null) {
            contextBooleanFilter.addTerm(FIELD_SUBSCRIPTION_STATUS, String.valueOf(subscriptionStatus), BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_COMMERCE_ORDER_ITEM_ID, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_CP_INSTANCE_ID, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_SKU, false);
    }

    protected void doDelete(CommerceSubscriptionEntry commerceSubscriptionEntry) throws Exception {
        this.deleteDocument(commerceSubscriptionEntry.getCompanyId(), commerceSubscriptionEntry.getCommerceSubscriptionEntryId());
    }

    protected Document doGetDocument(CommerceSubscriptionEntry commerceSubscriptionEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing subscription entry " + commerceSubscriptionEntry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceSubscriptionEntry);
        document.addNumber(FIELD_COMMERCE_ORDER_ITEM_ID, commerceSubscriptionEntry.getCommerceOrderItemId());
        document.addNumber(FIELD_CP_INSTANCE_ID, commerceSubscriptionEntry.getCPInstanceId());
        document.addNumber(FIELD_MAX_SUBSCRIPTION_CYCLES, commerceSubscriptionEntry.getMaxSubscriptionCycles());
        document.addKeyword(FIELD_SUBSCRIPTION_STATUS, commerceSubscriptionEntry.getSubscriptionStatus());
        String sku = "";
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        if (commerceOrderItem != null) {
            sku = commerceOrderItem.getSku();
        }
        document.addText(FIELD_SKU, sku);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceSubscriptionEntry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceSubscriptionEntry commerceSubscriptionEntry) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceSubscriptionEntry.getCompanyId(), this.getDocument(commerceSubscriptionEntry), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceSubscriptionEntries(companyId);
    }

    protected void reindexCommerceSubscriptionEntries(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceSubscriptionEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceSubscriptionEntry -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceSubscriptionEntry)});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index subscription entry " + commerceSubscriptionEntry.getCommerceSubscriptionEntryId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

