/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.HashMap;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"commerce.order.status.key=1", "commerce.order.status.priority:Integer=30"}, service={CommerceOrderStatus.class})
public class PendingCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 1;
    public static final int PRIORITY = 30;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId) throws PortalException {
        if (this.isWorkflowEnabled(commerceOrder)) {
            commerceOrder.setStatus(1);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setScopeGroupId(commerceOrder.getGroupId());
            serviceContext.setUserId(userId);
            serviceContext.setWorkflowAction(1);
            commerceOrder = (CommerceOrder)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrder.getCompanyId(), (long)commerceOrder.getGroupId(), (long)userId, (String)CommerceOrder.class.getName(), (long)commerceOrder.getCommerceOrderId(), (Object)commerceOrder, (ServiceContext)serviceContext, new HashMap());
        }
        commerceOrder.setOrderStatus(1);
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 1;
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)CommerceOrderConstants.getOrderStatusLabel((int)1));
    }

    public int getPriority() {
        return 30;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return !commerceOrder.isOpen() && commerceOrder.isApproved();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        return commerceOrder.getOrderStatus() == 6 && this._commerceOrderValidatorRegistry.isValid(null, commerceOrder);
    }

    public boolean isWorkflowEnabled(CommerceOrder commerceOrder) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 1L, true);
        return workflowDefinitionLink != null;
    }
}

