/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/order_status"}, service={MessageListener.class})
public class CommerceOrderStatusMessageListener
extends BaseMessageListener {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceNotificationHelper _commerceNotificationHelper;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;

    protected void doReceive(Message message) throws Exception {
        int orderStatus = message.getInteger("orderStatus");
        long commerceOrderId = message.getLong("commerceOrderId");
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        this._commerceNotificationHelper.sendNotifications(commerceChannel.getGroupId(), commerceOrder.getUserId(), CommerceOrderConstants.getNotificationKey((int)orderStatus), (Object)commerceOrder);
    }
}

