/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShippingMethodEngineKeyException;
import com.liferay.commerce.exception.CommerceShippingMethodNameException;
import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.service.base.CommerceShippingMethodLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceShippingMethodLocalServiceImpl
extends CommerceShippingMethodLocalServiceBaseImpl {
    public CommerceAddressRestriction addCommerceAddressRestriction(long commerceShippingMethodId, long commerceCountryId, ServiceContext serviceContext) throws PortalException {
        return this.commerceAddressRestrictionLocalService.addCommerceAddressRestriction(CommerceShippingMethod.class.getName(), commerceShippingMethodId, commerceCountryId, serviceContext);
    }

    public CommerceShippingMethod addCommerceShippingMethod(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, String engineKey, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        this.validate(nameMap, engineKey);
        long commerceShippingMethodId = this.counterLocalService.increment();
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.create(commerceShippingMethodId);
        commerceShippingMethod.setGroupId(groupId);
        commerceShippingMethod.setCompanyId(user.getCompanyId());
        commerceShippingMethod.setUserId(user.getUserId());
        commerceShippingMethod.setUserName(user.getFullName());
        commerceShippingMethod.setNameMap(nameMap);
        commerceShippingMethod.setDescriptionMap(descriptionMap);
        if (imageFile != null) {
            commerceShippingMethod.setImageId(this.counterLocalService.increment());
        }
        commerceShippingMethod.setEngineKey(engineKey);
        commerceShippingMethod.setPriority(priority);
        commerceShippingMethod.setActive(active);
        commerceShippingMethod = (CommerceShippingMethod)this.commerceShippingMethodPersistence.update((BaseModel)commerceShippingMethod);
        if (imageFile != null) {
            this.imageLocalService.updateImage(commerceShippingMethod.getImageId(), imageFile);
        }
        return commerceShippingMethod;
    }

    public void deleteCommerceAddressRestriction(long commerceAddressRestrictionId) throws PortalException {
        this.commerceAddressRestrictionLocalService.deleteCommerceAddressRestriction(commerceAddressRestrictionId);
    }

    @Override
    public CommerceShippingMethod deleteCommerceShippingMethod(CommerceShippingMethod commerceShippingMethod) throws PortalException {
        this.commerceShippingMethodPersistence.remove((BaseModel)commerceShippingMethod);
        if (commerceShippingMethod.getImageId() > 0L) {
            this.imageLocalService.deleteImage(commerceShippingMethod.getImageId());
        }
        this.commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(CommerceShippingMethod.class.getName(), commerceShippingMethod.getCommerceShippingMethodId());
        return commerceShippingMethod;
    }

    @Override
    public CommerceShippingMethod deleteCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.findByPrimaryKey(commerceShippingMethodId);
        return this.commerceShippingMethodLocalService.deleteCommerceShippingMethod(commerceShippingMethod);
    }

    public void deleteCommerceShippingMethods(long groupId) throws PortalException {
        List commerceShippingMethods = this.commerceShippingMethodPersistence.findByGroupId(groupId);
        for (CommerceShippingMethod commerceShippingMethod : commerceShippingMethods) {
            this.commerceShippingMethodLocalService.deleteCommerceShippingMethod(commerceShippingMethod);
        }
    }

    public CommerceShippingMethod fetchCommerceShippingMethod(long groupId, String engineKey) {
        return this.commerceShippingMethodPersistence.fetchByG_E(groupId, engineKey);
    }

    public List<CommerceAddressRestriction> getCommerceAddressRestrictions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) {
        return this.commerceAddressRestrictionLocalService.getCommerceAddressRestrictions(CommerceShippingMethod.class.getName(), commerceShippingMethodId, start, end, orderByComparator);
    }

    public int getCommerceAddressRestrictionsCount(long commerceShippingMethodId) {
        return this.commerceAddressRestrictionLocalService.getCommerceAddressRestrictionsCount(CommerceShippingMethod.class.getName(), commerceShippingMethodId);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId) {
        return this.commerceShippingMethodPersistence.findByGroupId(groupId);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, boolean active) {
        return this.commerceShippingMethodPersistence.findByG_A(groupId, active);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, long commerceCountryId, boolean active) {
        ArrayList<CommerceShippingMethod> filteredCommerceShippingMethods = new ArrayList<CommerceShippingMethod>();
        List commerceShippingMethods = this.commerceShippingMethodPersistence.findByG_A(groupId, active);
        for (CommerceShippingMethod commercePaymentMethodGroupRel : commerceShippingMethods) {
            boolean restricted = this.commerceAddressRestrictionLocalService.isCommerceAddressRestricted(CommerceShippingMethod.class.getName(), commercePaymentMethodGroupRel.getCommerceShippingMethodId(), commerceCountryId);
            if (restricted) continue;
            filteredCommerceShippingMethods.add(commercePaymentMethodGroupRel);
        }
        return filteredCommerceShippingMethods;
    }

    public int getCommerceShippingMethodsCount(long groupId, boolean active) {
        return this.commerceShippingMethodPersistence.countByG_A(groupId, active);
    }

    public CommerceShippingMethod setActive(long commerceShippingMethodId, boolean active) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.findByPrimaryKey(commerceShippingMethodId);
        commerceShippingMethod.setActive(active);
        return (CommerceShippingMethod)this.commerceShippingMethodPersistence.update((BaseModel)commerceShippingMethod);
    }

    public CommerceShippingMethod updateCommerceShippingMethod(long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, double priority, boolean active) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.findByPrimaryKey(commerceShippingMethodId);
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        commerceShippingMethod.setNameMap(nameMap);
        commerceShippingMethod.setDescriptionMap(descriptionMap);
        if (imageFile != null && commerceShippingMethod.getImageId() <= 0L) {
            commerceShippingMethod.setImageId(this.counterLocalService.increment());
        }
        commerceShippingMethod.setPriority(priority);
        commerceShippingMethod.setActive(active);
        commerceShippingMethod = (CommerceShippingMethod)this.commerceShippingMethodPersistence.update((BaseModel)commerceShippingMethod);
        if (imageFile != null) {
            this.imageLocalService.updateImage(commerceShippingMethod.getImageId(), imageFile);
        }
        return commerceShippingMethod;
    }

    protected void validate(Map<Locale, String> nameMap, String engineKey) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommerceShippingMethodNameException();
        }
        if (Validator.isNull((String)engineKey)) {
            throw new CommerceShippingMethodEngineKeyException();
        }
    }
}

