/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.context;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;

public class CommerceContextImpl
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(CommerceContextImpl.class);
    private CommerceAccount _commerceAccount;
    private long[] _commerceAccountGroupIds;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final CommerceAccountHelper _commerceAccountHelper;
    private final long _commerceAccountId;
    private final CommerceAccountService _commerceAccountService;
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderService _commerceOrderService;
    private final long _companyId;
    private final long _groupId;
    private final long _orderId;

    public CommerceContextImpl(long companyId, long groupId, long orderId, long commerceAccountId, CommerceAccountHelper commerceAccountHelper, CommerceAccountService commerceAccountService, CommerceChannelLocalService commerceChannelLocalService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceOrderService commerceOrderService, ConfigurationProvider configurationProvider) {
        this._companyId = companyId;
        this._groupId = groupId;
        this._orderId = orderId;
        this._commerceAccountId = commerceAccountId;
        this._commerceAccountHelper = commerceAccountHelper;
        this._commerceAccountService = commerceAccountService;
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceOrderService = commerceOrderService;
        try {
            if (this.getCommerceChannelGroupId() > 0L) {
                this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this.getCommerceChannelGroupId(), "com.liferay.commerce.account"));
            }
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
    }

    public CommerceAccount getCommerceAccount() throws PortalException {
        if (this._commerceAccount != null) {
            return this._commerceAccount;
        }
        this._commerceAccount = this._commerceAccountService.getCommerceAccount(this._commerceAccountId);
        return this._commerceAccount;
    }

    public long[] getCommerceAccountGroupIds() throws PortalException {
        if (this._commerceAccountGroupIds != null) {
            return (long[])this._commerceAccountGroupIds.clone();
        }
        CommerceAccount commerceAccount = this.getCommerceAccount();
        if (commerceAccount == null) {
            return new long[0];
        }
        this._commerceAccountGroupIds = this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccount.getCommerceAccountId());
        return (long[])this._commerceAccountGroupIds.clone();
    }

    public long getCommerceChannelGroupId() throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this.getSiteGroupId());
        if (commerceChannel == null) {
            return 0L;
        }
        return commerceChannel.getGroupId();
    }

    public long getCommerceChannelId() throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this.getSiteGroupId());
        if (commerceChannel == null) {
            return 0L;
        }
        return commerceChannel.getCommerceChannelId();
    }

    public CommerceCurrency getCommerceCurrency() throws PortalException {
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._groupId);
        this._commerceCurrency = commerceChannel == null ? this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(this._companyId) : this._commerceCurrencyLocalService.getCommerceCurrency(this._companyId, commerceChannel.getCommerceCurrencyCode());
        return this._commerceCurrency;
    }

    public CommerceOrder getCommerceOrder() throws PortalException {
        if (this._commerceOrder != null) {
            return this._commerceOrder;
        }
        this._commerceOrder = this._commerceOrderService.fetchCommerceOrder(this._orderId);
        return this._commerceOrder;
    }

    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    public long getSiteGroupId() throws PortalException {
        return this._groupId;
    }
}

