/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.subscription;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.payment.engine.CommerceSubscriptionEngine;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPSubscriptionInfo;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryHelper;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceSubscriptionEntryHelper.class})
public class CommerceSubscriptionEntryHelperImpl
implements CommerceSubscriptionEntryHelper {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceSubscriptionEngine _commerceSubscriptionEngine;
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;

    public void checkCommerceSubscriptions(CommerceOrder commerceOrder) throws PortalException {
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        List commerceOrderItems = this._commerceOrderItemLocalService.getSubscriptionCommerceOrderItems(commerceOrder.getCommerceOrderId());
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            CPSubscriptionInfo cpSubscriptionInfo;
            CPInstance cpInstance = commerceOrderItem.getCPInstance();
            if (!this._isNewSubscription(commerceOrderItem) || (cpSubscriptionInfo = cpInstance.getCPSubscriptionInfo()) == null) continue;
            this._commerceSubscriptionEntryLocalService.addCommerceSubscriptionEntry(commerceAccount.getUserId(), commerceOrder.getGroupId(), commerceOrderItem.getCommerceOrderItemId(), cpSubscriptionInfo.getSubscriptionLength(), cpSubscriptionInfo.getSubscriptionType(), cpSubscriptionInfo.getMaxSubscriptionCycles(), cpSubscriptionInfo.getSubscriptionTypeSettingsProperties());
        }
    }

    public void checkSubscriptionEntriesStatus(List<CommerceSubscriptionEntry> commerceSubscriptionEntries) throws Exception {
        for (CommerceSubscriptionEntry commerceSubscriptionEntry : commerceSubscriptionEntries) {
            this.checkSubscriptionStatus(commerceSubscriptionEntry);
        }
    }

    public void checkSubscriptionStatus(CommerceSubscriptionEntry commerceSubscriptionEntry) throws Exception {
        Date now = new Date();
        Date nextIterationDate = commerceSubscriptionEntry.getNextIterationDate();
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        if (commerceOrderItem != null && now.after(nextIterationDate)) {
            CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
            boolean subscriptionValid = this._commerceSubscriptionEngine.getSubscriptionValidity(commerceOrder.getCommerceOrderId());
            if (subscriptionValid && Objects.equals(0, commerceSubscriptionEntry.getSubscriptionStatus())) {
                this._commerceSubscriptionEntryLocalService.incrementCommerceSubscriptionEntryCycle(commerceSubscriptionEntry.getCommerceSubscriptionEntryId());
            } else {
                this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), 1);
            }
        }
    }

    private boolean _isNewSubscription(CommerceOrderItem commerceOrderItem) {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.fetchCommerceSubscriptionEntry(commerceOrderItem.getCommerceOrderItemId());
        return commerceSubscriptionEntry == null;
    }
}

