/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.http;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemSoap;
import com.liferay.commerce.service.CommerceOrderItemServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.List;

public class CommerceOrderItemServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(CommerceOrderItemServiceSoap.class);

    public static CommerceOrderItemSoap addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.addCommerceOrderItem((long)commerceOrderId, (long)cpInstanceId, (int)quantity, (int)shippedQuantity, (String)json, (CommerceContext)commerceContext, (ServiceContext)serviceContext);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void deleteCommerceOrderItem(long commerceOrderItemId) throws RemoteException {
        try {
            CommerceOrderItemServiceUtil.deleteCommerceOrderItem((long)commerceOrderItemId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void deleteCommerceOrderItem(long commerceOrderItemId, CommerceContext commerceContext) throws RemoteException {
        try {
            CommerceOrderItemServiceUtil.deleteCommerceOrderItem((long)commerceOrderItemId, (CommerceContext)commerceContext);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void deleteCommerceOrderItems(long commerceOrderId) throws RemoteException {
        try {
            CommerceOrderItemServiceUtil.deleteCommerceOrderItems((long)commerceOrderId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.fetchByExternalReferenceCode((long)companyId, (String)externalReferenceCode);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap fetchCommerceOrderItem(long commerceOrderItemId) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.fetchCommerceOrderItem((long)commerceOrderItemId);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap[] getAvailableForShipmentCommerceOrderItems(long commerceOrderId) throws RemoteException {
        try {
            List returnValue = CommerceOrderItemServiceUtil.getAvailableForShipmentCommerceOrderItems((long)commerceOrderId);
            return CommerceOrderItemSoap.toSoapModels((List)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws RemoteException {
        try {
            int returnValue = CommerceOrderItemServiceUtil.getCommerceInventoryWarehouseItemQuantity((long)commerceOrderItemId, (long)commerceInventoryWarehouseId);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap getCommerceOrderItem(long commerceOrderItemId) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.getCommerceOrderItem((long)commerceOrderItemId);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap[] getCommerceOrderItems(long commerceOrderId, int start, int end) throws RemoteException {
        try {
            List returnValue = CommerceOrderItemServiceUtil.getCommerceOrderItems((long)commerceOrderId, (int)start, (int)end);
            return CommerceOrderItemSoap.toSoapModels((List)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getCommerceOrderItemsCount(long commerceOrderId) throws RemoteException {
        try {
            int returnValue = CommerceOrderItemServiceUtil.getCommerceOrderItemsCount((long)commerceOrderId);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) throws RemoteException {
        try {
            int returnValue = CommerceOrderItemServiceUtil.getCommerceOrderItemsCount((long)commerceOrderId, (long)cpInstanceId);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static int getCommerceOrderItemsQuantity(long commerceOrderId) throws RemoteException {
        try {
            int returnValue = CommerceOrderItemServiceUtil.getCommerceOrderItemsQuantity((long)commerceOrderId);
            return returnValue;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.updateCommerceOrderItem((long)commerceOrderItemId, (int)quantity, (CommerceContext)commerceContext, (ServiceContext)serviceContext);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.updateCommerceOrderItem((long)commerceOrderItemId, (int)quantity, (String)json, (CommerceContext)commerceContext, (ServiceContext)serviceContext);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.updateCommerceOrderItemInfo((long)commerceOrderItemId, (String)deliveryGroup, (long)shippingAddressId, (String)printedNote, (int)requestedDeliveryDateMonth, (int)requestedDeliveryDateDay, (int)requestedDeliveryDateYear, (int)requestedDeliveryDateHour, (int)requestedDeliveryDateMinute, (ServiceContext)serviceContext);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal unitPrice, BigDecimal promoPrice, BigDecimal discountAmount, BigDecimal finalPrice, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.updateCommerceOrderItemPrices((long)commerceOrderItemId, (BigDecimal)unitPrice, (BigDecimal)promoPrice, (BigDecimal)discountAmount, (BigDecimal)finalPrice, (BigDecimal)discountPercentageLevel1, (BigDecimal)discountPercentageLevel2, (BigDecimal)discountPercentageLevel3, (BigDecimal)discountPercentageLevel4);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    @Deprecated
    public static CommerceOrderItemSoap updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.updateCommerceOrderItemUnitPrice((long)commerceOrderItemId, (BigDecimal)unitPrice);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice, int quantity) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.updateCommerceOrderItemUnitPrice((long)commerceOrderItemId, (BigDecimal)unitPrice, (int)quantity);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static CommerceOrderItemSoap upsertCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrderItem returnValue = CommerceOrderItemServiceUtil.upsertCommerceOrderItem((long)commerceOrderId, (long)cpInstanceId, (int)quantity, (int)shippedQuantity, (String)json, (CommerceContext)commerceContext, (ServiceContext)serviceContext);
            return CommerceOrderItemSoap.toSoapModel((CommerceOrderItem)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }
}

