/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.NoSuchShipmentItemException;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.model.impl.CommerceShipmentItemImpl;
import com.liferay.commerce.model.impl.CommerceShipmentItemModelImpl;
import com.liferay.commerce.service.persistence.CommerceShipmentItemPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommerceShipmentItemPersistenceImpl
extends BasePersistenceImpl<CommerceShipmentItem>
implements CommerceShipmentItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceShipmentItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "commerceShipmentItem.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByCommerceShipment;
    private FinderPath _finderPathWithoutPaginationFindByCommerceShipment;
    private FinderPath _finderPathCountByCommerceShipment;
    private static final String _FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2 = "commerceShipmentItem.commerceShipmentId = ?";
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCESHIPMENTITEM = "SELECT commerceShipmentItem FROM CommerceShipmentItem commerceShipmentItem";
    private static final String _SQL_SELECT_COMMERCESHIPMENTITEM_WHERE_PKS_IN = "SELECT commerceShipmentItem FROM CommerceShipmentItem commerceShipmentItem WHERE commerceShipmentItemId IN (";
    private static final String _SQL_SELECT_COMMERCESHIPMENTITEM_WHERE = "SELECT commerceShipmentItem FROM CommerceShipmentItem commerceShipmentItem WHERE ";
    private static final String _SQL_COUNT_COMMERCESHIPMENTITEM = "SELECT COUNT(commerceShipmentItem) FROM CommerceShipmentItem commerceShipmentItem";
    private static final String _SQL_COUNT_COMMERCESHIPMENTITEM_WHERE = "SELECT COUNT(commerceShipmentItem) FROM CommerceShipmentItem commerceShipmentItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceShipmentItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceShipmentItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceShipmentItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentItemPersistenceImpl.class);

    public List<CommerceShipmentItem> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<CommerceShipmentItem> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<CommerceShipmentItem> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipmentItem commerceShipmentItem : list) {
                if (groupId == commerceShipmentItem.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipmentItem findByGroupId_First(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByGroupId_First(groupId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchShipmentItemException(msg.toString());
    }

    public CommerceShipmentItem fetchByGroupId_First(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        List<CommerceShipmentItem> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem findByGroupId_Last(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchShipmentItemException(msg.toString());
    }

    public CommerceShipmentItem fetchByGroupId_Last(long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipmentItem> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem[] findByGroupId_PrevAndNext(long commerceShipmentItemId, long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.findByPrimaryKey(commerceShipmentItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem[] array = new CommerceShipmentItemImpl[]{this.getByGroupId_PrevAndNext(session, commerceShipmentItem, groupId, orderByComparator, true), commerceShipmentItem, this.getByGroupId_PrevAndNext(session, commerceShipmentItem, groupId, orderByComparator, false)};
            CommerceShipmentItem[] commerceShipmentItemArray = array;
            return commerceShipmentItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem getByGroupId_PrevAndNext(Session session, CommerceShipmentItem commerceShipmentItem, long groupId, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceShipmentItem.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipmentItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceShipmentItem)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (CommerceShipmentItem commerceShipmentItem : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCESHIPMENTITEM_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId) {
        return this.findByCommerceShipment(commerceShipmentId, -1, -1, null);
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId, int start, int end) {
        return this.findByCommerceShipment(commerceShipmentId, start, end, null);
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findByCommerceShipment(commerceShipmentId, start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findByCommerceShipment(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCommerceShipment;
                finderArgs = new Object[]{commerceShipmentId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCommerceShipment;
            finderArgs = new Object[]{commerceShipmentId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipmentItem commerceShipmentItem : list) {
                if (commerceShipmentId == commerceShipmentItem.getCommerceShipmentId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
            query.append(_FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceShipmentId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipmentItem findByCommerceShipment_First(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByCommerceShipment_First(commerceShipmentId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceShipmentId=");
        msg.append(commerceShipmentId);
        msg.append("}");
        throw new NoSuchShipmentItemException(msg.toString());
    }

    public CommerceShipmentItem fetchByCommerceShipment_First(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        List<CommerceShipmentItem> list = this.findByCommerceShipment(commerceShipmentId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem findByCommerceShipment_Last(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByCommerceShipment_Last(commerceShipmentId, orderByComparator);
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceShipmentId=");
        msg.append(commerceShipmentId);
        msg.append("}");
        throw new NoSuchShipmentItemException(msg.toString());
    }

    public CommerceShipmentItem fetchByCommerceShipment_Last(long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        int count = this.countByCommerceShipment(commerceShipmentId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipmentItem> list = this.findByCommerceShipment(commerceShipmentId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipmentItem[] findByCommerceShipment_PrevAndNext(long commerceShipmentItemId, long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.findByPrimaryKey(commerceShipmentItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem[] array = new CommerceShipmentItemImpl[]{this.getByCommerceShipment_PrevAndNext(session, commerceShipmentItem, commerceShipmentId, orderByComparator, true), commerceShipmentItem, this.getByCommerceShipment_PrevAndNext(session, commerceShipmentItem, commerceShipmentId, orderByComparator, false)};
            CommerceShipmentItem[] commerceShipmentItemArray = array;
            return commerceShipmentItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem getByCommerceShipment_PrevAndNext(Session session, CommerceShipmentItem commerceShipmentItem, long commerceShipmentId, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE);
        query.append(_FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceShipmentItem.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(commerceShipmentId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipmentItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceShipmentItem)list.get(1);
        }
        return null;
    }

    public void removeByCommerceShipment(long commerceShipmentId) {
        for (CommerceShipmentItem commerceShipmentItem : this.findByCommerceShipment(commerceShipmentId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countByCommerceShipment(long commerceShipmentId) {
        FinderPath finderPath = this._finderPathCountByCommerceShipment;
        Object[] finderArgs = new Object[]{commerceShipmentId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCESHIPMENTITEM_WHERE);
            query.append(_FINDER_COLUMN_COMMERCESHIPMENT_COMMERCESHIPMENTID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceShipmentId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipmentItemPersistenceImpl() {
        this.setModelClass(CommerceShipmentItem.class);
    }

    public void cacheResult(CommerceShipmentItem commerceShipmentItem) {
        this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()), (Serializable)commerceShipmentItem);
        commerceShipmentItem.resetOriginalValues();
    }

    public void cacheResult(List<CommerceShipmentItem> commerceShipmentItems) {
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            if (this.entityCache.getResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey())) == null) {
                this.cacheResult(commerceShipmentItem);
                continue;
            }
            commerceShipmentItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceShipmentItemImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceShipmentItem commerceShipmentItem) {
        this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<CommerceShipmentItem> commerceShipmentItems) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()));
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey);
        }
    }

    public CommerceShipmentItem create(long commerceShipmentItemId) {
        CommerceShipmentItemImpl commerceShipmentItem = new CommerceShipmentItemImpl();
        commerceShipmentItem.setNew(true);
        commerceShipmentItem.setPrimaryKey(commerceShipmentItemId);
        commerceShipmentItem.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceShipmentItem;
    }

    public CommerceShipmentItem remove(long commerceShipmentItemId) throws NoSuchShipmentItemException {
        return this.remove(Long.valueOf(commerceShipmentItemId));
    }

    public CommerceShipmentItem remove(Serializable primaryKey) throws NoSuchShipmentItemException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)session.get(CommerceShipmentItemImpl.class, primaryKey);
            if (commerceShipmentItem == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchShipmentItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceShipmentItem commerceShipmentItem2 = (CommerceShipmentItem)this.remove((BaseModel)commerceShipmentItem);
            return commerceShipmentItem2;
        }
        catch (NoSuchShipmentItemException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipmentItem removeImpl(CommerceShipmentItem commerceShipmentItem) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceShipmentItem)) {
                commerceShipmentItem = (CommerceShipmentItem)session.get(CommerceShipmentItemImpl.class, commerceShipmentItem.getPrimaryKeyObj());
            }
            if (commerceShipmentItem != null) {
                session.delete((Object)commerceShipmentItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceShipmentItem != null) {
            this.clearCache(commerceShipmentItem);
        }
        return commerceShipmentItem;
    }

    public CommerceShipmentItem updateImpl(CommerceShipmentItem commerceShipmentItem) {
        boolean isNew = commerceShipmentItem.isNew();
        if (!(commerceShipmentItem instanceof CommerceShipmentItemModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceShipmentItem.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceShipmentItem);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceShipmentItem proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceShipmentItem implementation " + commerceShipmentItem.getClass());
        }
        CommerceShipmentItemModelImpl commerceShipmentItemModelImpl = (CommerceShipmentItemModelImpl)commerceShipmentItem;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceShipmentItem.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceShipmentItem.setCreateDate(now);
            } else {
                commerceShipmentItem.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceShipmentItemModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceShipmentItem.setModifiedDate(now);
            } else {
                commerceShipmentItem.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (commerceShipmentItem.isNew()) {
                session.save((Object)commerceShipmentItem);
                commerceShipmentItem.setNew(false);
            } else {
                commerceShipmentItem = (CommerceShipmentItem)session.merge((Object)commerceShipmentItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommerceShipmentItemModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commerceShipmentItemModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByGroupId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId()};
            this.finderCache.removeResult(this._finderPathCountByCommerceShipment, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceShipment, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commerceShipmentItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentItemModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{commerceShipmentItemModelImpl.getGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((commerceShipmentItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCommerceShipment.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentItemModelImpl.getOriginalCommerceShipmentId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceShipment, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceShipment, args);
                args = new Object[]{commerceShipmentItemModelImpl.getCommerceShipmentId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceShipment, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceShipment, args);
            }
        }
        this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, (Serializable)Long.valueOf(commerceShipmentItem.getPrimaryKey()), (Serializable)commerceShipmentItem, false);
        commerceShipmentItem.resetOriginalValues();
        return commerceShipmentItem;
    }

    public CommerceShipmentItem findByPrimaryKey(Serializable primaryKey) throws NoSuchShipmentItemException {
        CommerceShipmentItem commerceShipmentItem = this.fetchByPrimaryKey(primaryKey);
        if (commerceShipmentItem == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchShipmentItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceShipmentItem;
    }

    public CommerceShipmentItem findByPrimaryKey(long commerceShipmentItemId) throws NoSuchShipmentItemException {
        return this.findByPrimaryKey(Long.valueOf(commerceShipmentItemId));
    }

    public CommerceShipmentItem fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)serializable;
        if (commerceShipmentItem == null) {
            Session session = null;
            try {
                session = this.openSession();
                commerceShipmentItem = (CommerceShipmentItem)session.get(CommerceShipmentItemImpl.class, primaryKey);
                if (commerceShipmentItem != null) {
                    this.cacheResult(commerceShipmentItem);
                } else {
                    this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commerceShipmentItem;
    }

    public CommerceShipmentItem fetchByPrimaryKey(long commerceShipmentItemId) {
        return this.fetchByPrimaryKey(Long.valueOf(commerceShipmentItemId));
    }

    public Map<Serializable, CommerceShipmentItem> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommerceShipmentItem> map = new HashMap<Serializable, CommerceShipmentItem>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommerceShipmentItem commerceShipmentItem = this.fetchByPrimaryKey(primaryKey);
            if (commerceShipmentItem != null) {
                map.put(primaryKey, commerceShipmentItem);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommerceShipmentItem)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COMMERCESHIPMENTITEM_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (CommerceShipmentItem commerceShipmentItem : q.list()) {
                map.put(commerceShipmentItem.getPrimaryKeyObj(), commerceShipmentItem);
                this.cacheResult(commerceShipmentItem);
                uncachedPrimaryKeys.remove(commerceShipmentItem.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommerceShipmentItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceShipmentItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceShipmentItem> findAll(int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceShipmentItem> findAll(int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COMMERCESHIPMENTITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMMERCESHIPMENTITEM;
                sql = sql.concat(" ORDER BY commerceShipmentItem.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceShipmentItem commerceShipmentItem : this.findAll()) {
            this.remove((BaseModel)commerceShipmentItem);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMMERCESHIPMENTITEM);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceShipmentItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 6L);
        this._finderPathCountByGroupId = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCommerceShipment = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCommerceShipment", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCommerceShipment = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCommerceShipment", new String[]{Long.class.getName()}, 5L);
        this._finderPathCountByCommerceShipment = new FinderPath(CommerceShipmentItemModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCommerceShipment", new String[]{Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceShipmentItemImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

