/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.service.base.CPDefinitionInventoryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;

public class CPDefinitionInventoryLocalServiceImpl
extends CPDefinitionInventoryLocalServiceBaseImpl {
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CProductLocalService.class)
    private CProductLocalService _cProductLocalService;

    public CPDefinitionInventory addCPDefinitionInventory(long cpDefinitionId, String cpDefinitionInventoryEngine, String lowStockActivity, boolean displayAvailability, boolean displayStockQuantity, int minStockQuantity, boolean backOrders, int minOrderQuantity, int maxOrderQuantity, String allowedOrderQuantities, int multipleOrderQuantity) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            throw new PortalException("Unable to obtain valid service context");
        }
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long cpDefinitionInventoryId = this.counterLocalService.increment();
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryPersistence.create(cpDefinitionInventoryId);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        if (this._cpDefinitionLocalService.isVersionable(cpDefinitionId)) {
            cpDefinition = this._cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
        }
        cpDefinitionInventory.setGroupId(cpDefinition.getGroupId());
        cpDefinitionInventory.setCompanyId(user.getCompanyId());
        cpDefinitionInventory.setUserId(user.getUserId());
        cpDefinitionInventory.setUserName(user.getFullName());
        cpDefinitionInventory.setCPDefinitionId(cpDefinition.getCPDefinitionId());
        cpDefinitionInventory.setCPDefinitionInventoryEngine(cpDefinitionInventoryEngine);
        cpDefinitionInventory.setLowStockActivity(lowStockActivity);
        cpDefinitionInventory.setDisplayAvailability(displayAvailability);
        cpDefinitionInventory.setDisplayStockQuantity(displayStockQuantity);
        cpDefinitionInventory.setMinStockQuantity(minStockQuantity);
        cpDefinitionInventory.setBackOrders(backOrders);
        cpDefinitionInventory.setMinOrderQuantity(minOrderQuantity);
        cpDefinitionInventory.setMaxOrderQuantity(maxOrderQuantity);
        cpDefinitionInventory.setAllowedOrderQuantities(allowedOrderQuantities);
        cpDefinitionInventory.setMultipleOrderQuantity(multipleOrderQuantity);
        this.cpDefinitionInventoryPersistence.update((BaseModel)cpDefinitionInventory);
        return cpDefinitionInventory;
    }

    @Deprecated
    public CPDefinitionInventory addCPDefinitionInventory(long cpDefinitionId, String cpDefinitionInventoryEngine, String lowStockActivity, boolean displayAvailability, boolean displayStockQuantity, int minStockQuantity, boolean backOrders, int minOrderQuantity, int maxOrderQuantity, String allowedOrderQuantities, int multipleOrderQuantity, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionInventoryLocalService.addCPDefinitionInventory(cpDefinitionId, cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity);
    }

    public void cloneCPDefinitionInventory(long cpDefinitionId, long newCPDefinitionId) {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinitionId);
        if (cpDefinitionInventory != null) {
            CPDefinitionInventory newCPDefinitionInventory = (CPDefinitionInventory)cpDefinitionInventory.clone();
            newCPDefinitionInventory.setUuid(PortalUUIDUtil.generate());
            newCPDefinitionInventory.setCPDefinitionInventoryId(this.counterLocalService.increment());
            newCPDefinitionInventory.setCPDefinitionId(newCPDefinitionId);
            this.cpDefinitionInventoryLocalService.addCPDefinitionInventory(newCPDefinitionInventory);
        }
    }

    @Override
    @SystemEvent(type=1)
    public CPDefinitionInventory deleteCPDefinitionInventory(CPDefinitionInventory cpDefinitionInventory) {
        if (this._cpDefinitionLocalService.isVersionable(cpDefinitionInventory.getCPDefinitionId())) {
            try {
                CPDefinition newCPDefinition = this._cpDefinitionLocalService.copyCPDefinition(cpDefinitionInventory.getCPDefinitionId());
                cpDefinitionInventory = this.cpDefinitionInventoryPersistence.findByCPDefinitionId(newCPDefinition.getCPDefinitionId());
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
        return (CPDefinitionInventory)this.cpDefinitionInventoryPersistence.remove((BaseModel)cpDefinitionInventory);
    }

    @Override
    public CPDefinitionInventory deleteCPDefinitionInventory(long cpDefinitionInventoryId) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryPersistence.findByPrimaryKey(cpDefinitionInventoryId);
        return this.cpDefinitionInventoryLocalService.deleteCPDefinitionInventory(cpDefinitionInventory);
    }

    public void deleteCPDefinitionInventoryByCPDefinitionId(long cpDefinitionId) {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinitionId);
        if (cpDefinitionInventory != null) {
            this.cpDefinitionInventoryLocalService.deleteCPDefinitionInventory(cpDefinitionInventory);
        }
    }

    public CPDefinitionInventory fetchCPDefinitionInventoryByCPDefinitionId(long cpDefinitionId) {
        return this.cpDefinitionInventoryPersistence.fetchByCPDefinitionId(cpDefinitionId);
    }

    public CPDefinitionInventory updateCPDefinitionInventory(long cpDefinitionInventoryId, String cpDefinitionInventoryEngine, String lowStockActivity, boolean displayAvailability, boolean displayStockQuantity, int minStockQuantity, boolean backOrders, int minOrderQuantity, int maxOrderQuantity, String allowedOrderQuantities, int multipleOrderQuantity) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryPersistence.findByPrimaryKey(cpDefinitionInventoryId);
        if (this._cpDefinitionLocalService.isVersionable(cpDefinitionInventory.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this._cpDefinitionLocalService.copyCPDefinition(cpDefinitionInventory.getCPDefinitionId());
            cpDefinitionInventory = this.cpDefinitionInventoryPersistence.findByCPDefinitionId(newCPDefinition.getCPDefinitionId());
        }
        cpDefinitionInventory.setCPDefinitionInventoryEngine(cpDefinitionInventoryEngine);
        cpDefinitionInventory.setLowStockActivity(lowStockActivity);
        cpDefinitionInventory.setDisplayAvailability(displayAvailability);
        cpDefinitionInventory.setDisplayStockQuantity(displayStockQuantity);
        cpDefinitionInventory.setMinStockQuantity(minStockQuantity);
        cpDefinitionInventory.setBackOrders(backOrders);
        cpDefinitionInventory.setMinOrderQuantity(minOrderQuantity);
        cpDefinitionInventory.setMaxOrderQuantity(maxOrderQuantity);
        cpDefinitionInventory.setAllowedOrderQuantities(allowedOrderQuantities);
        cpDefinitionInventory.setMultipleOrderQuantity(multipleOrderQuantity);
        this.cpDefinitionInventoryPersistence.update((BaseModel)cpDefinitionInventory);
        return cpDefinitionInventory;
    }

    @Deprecated
    public CPDefinitionInventory updateCPDefinitionInventory(long cpDefinitionInventoryId, String cpDefinitionInventoryEngine, String lowStockActivity, boolean displayAvailability, boolean displayStockQuantity, int minStockQuantity, boolean backOrders, int minOrderQuantity, int maxOrderQuantity, String allowedOrderQuantities, int multipleOrderQuantity, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionInventoryLocalService.updateCPDefinitionInventory(cpDefinitionInventoryId, cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity);
    }
}

