/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.base;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;

public abstract class BaseCommerceServiceUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceServiceUpgradeProcess.class);

    protected void addColumn(Class<?> entityClass, String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        if (!this.hasColumn(tableName, columnName)) {
            this.alter(entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, columnName + " " + columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", columnName, tableName));
        }
    }

    protected abstract void doUpgrade() throws Exception;

    protected void dropColumn(String tableName, String columnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping column %s from table %s", columnName, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " drop column ", columnName}));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already does not exist on table %s", columnName, tableName));
        }
    }

    protected void renameColumn(Class<?> tableClass, String tableName, String oldColumnName, String newColumnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Renaming column %s to table %s", oldColumnName, tableName));
        }
        if (!this.hasColumn(tableName, newColumnName)) {
            this.alter(tableClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnName((UpgradeProcess)this, oldColumnName, newColumnName)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", newColumnName, tableName));
        }
    }
}

