/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.base.CommerceShipmentServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class CommerceShipmentServiceImpl
extends CommerceShipmentServiceBaseImpl {
    @ServiceReference(type=CommerceChannelService.class)
    private CommerceChannelService _commerceChannelService;

    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.addCommerceShipment(commerceOrderId, serviceContext);
    }

    public void deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment);
    }

    public CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipments(commerceChannelGroupIds, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        if (commerceChannels.isEmpty()) {
            return Collections.emptyList();
        }
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipments(commerceChannelGroupIds, start, end, orderByComparator);
    }

    public int getCommerceShipmentsCount(long companyId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        if (commerceChannels.isEmpty()) {
            return 0;
        }
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(commerceChannelGroupIds);
    }

    public int getCommerceShipmentsCount(long companyId, int status) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(commerceChannelGroupIds, status);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }
}

