/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommerceAddressRestrictionModel;
import com.liferay.commerce.model.CommerceAddressRestrictionSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceAddressRestriction service. Represents a row in the &quot;CommerceAddressRestriction&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface </code>CommerceAddressRestrictionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAddressRestrictionImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceAddressRestrictionImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceAddressRestrictionModelImpl
	extends BaseModelImpl<CommerceAddressRestriction>
	implements CommerceAddressRestrictionModel {

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce address restriction model instance should use the <code>CommerceAddressRestriction</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceAddressRestriction";

	public static final Object[][] TABLE_COLUMNS = {
		{"commerceAddressRestrictionId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"commerceCountryId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("commerceAddressRestrictionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCountryId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceAddressRestriction (commerceAddressRestrictionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,commerceCountryId LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceAddressRestriction";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceAddressRestriction.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceAddressRestriction.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceAddressRestriction"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceAddressRestriction"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceAddressRestriction"),
		true);

	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	public static final long COMMERCECOUNTRYID_COLUMN_BITMASK = 4L;

	public static final long CREATEDATE_COLUMN_BITMASK = 8L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceAddressRestriction toModel(
		CommerceAddressRestrictionSoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommerceAddressRestriction model = new CommerceAddressRestrictionImpl();

		model.setCommerceAddressRestrictionId(
			soapModel.getCommerceAddressRestrictionId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setCommerceCountryId(soapModel.getCommerceCountryId());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceAddressRestriction> toModels(
		CommerceAddressRestrictionSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceAddressRestriction> models =
			new ArrayList<CommerceAddressRestriction>(soapModels.length);

		for (CommerceAddressRestrictionSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceAddressRestriction"));

	public CommerceAddressRestrictionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceAddressRestrictionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceAddressRestrictionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceAddressRestrictionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceAddressRestriction.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceAddressRestriction.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceAddressRestriction, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceAddressRestriction, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAddressRestriction, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceAddressRestriction)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceAddressRestriction, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceAddressRestriction, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceAddressRestriction)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceAddressRestriction, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceAddressRestriction, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceAddressRestriction>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceAddressRestriction.class.getClassLoader(),
			CommerceAddressRestriction.class, ModelWrapper.class);

		try {
			Constructor<CommerceAddressRestriction> constructor =
				(Constructor<CommerceAddressRestriction>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException roe) {
					throw new InternalError(roe);
				}
			};
		}
		catch (NoSuchMethodException nsme) {
			throw new InternalError(nsme);
		}
	}

	private static final Map
		<String, Function<CommerceAddressRestriction, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<CommerceAddressRestriction, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceAddressRestriction, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceAddressRestriction, Object>>();
		Map<String, BiConsumer<CommerceAddressRestriction, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceAddressRestriction, ?>>();

		attributeGetterFunctions.put(
			"commerceAddressRestrictionId",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.
						getCommerceAddressRestrictionId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceAddressRestrictionId",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object commerceAddressRestrictionIdObject) {

					commerceAddressRestriction.setCommerceAddressRestrictionId(
						(Long)commerceAddressRestrictionIdObject);
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getGroupId();
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object groupIdObject) {

					commerceAddressRestriction.setGroupId((Long)groupIdObject);
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getCompanyId();
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object companyIdObject) {

					commerceAddressRestriction.setCompanyId(
						(Long)companyIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object userIdObject) {

					commerceAddressRestriction.setUserId((Long)userIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object userNameObject) {

					commerceAddressRestriction.setUserName(
						(String)userNameObject);
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getCreateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object createDateObject) {

					commerceAddressRestriction.setCreateDate(
						(Date)createDateObject);
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getModifiedDate();
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object modifiedDateObject) {

					commerceAddressRestriction.setModifiedDate(
						(Date)modifiedDateObject);
				}

			});
		attributeGetterFunctions.put(
			"classNameId",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getClassNameId();
				}

			});
		attributeSetterBiConsumers.put(
			"classNameId",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object classNameIdObject) {

					commerceAddressRestriction.setClassNameId(
						(Long)classNameIdObject);
				}

			});
		attributeGetterFunctions.put(
			"classPK",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getClassPK();
				}

			});
		attributeSetterBiConsumers.put(
			"classPK",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object classPKObject) {

					commerceAddressRestriction.setClassPK((Long)classPKObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceCountryId",
			new Function<CommerceAddressRestriction, Object>() {

				@Override
				public Object apply(
					CommerceAddressRestriction commerceAddressRestriction) {

					return commerceAddressRestriction.getCommerceCountryId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceCountryId",
			new BiConsumer<CommerceAddressRestriction, Object>() {

				@Override
				public void accept(
					CommerceAddressRestriction commerceAddressRestriction,
					Object commerceCountryIdObject) {

					commerceAddressRestriction.setCommerceCountryId(
						(Long)commerceCountryIdObject);
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getCommerceAddressRestrictionId() {
		return _commerceAddressRestrictionId;
	}

	@Override
	public void setCommerceAddressRestrictionId(
		long commerceAddressRestrictionId) {

		_commerceAddressRestrictionId = commerceAddressRestrictionId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		_columnBitmask |= CLASSNAMEID_COLUMN_BITMASK;

		if (!_setOriginalClassNameId) {
			_setOriginalClassNameId = true;

			_originalClassNameId = _classNameId;
		}

		_classNameId = classNameId;
	}

	public long getOriginalClassNameId() {
		return _originalClassNameId;
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		_columnBitmask |= CLASSPK_COLUMN_BITMASK;

		if (!_setOriginalClassPK) {
			_setOriginalClassPK = true;

			_originalClassPK = _classPK;
		}

		_classPK = classPK;
	}

	public long getOriginalClassPK() {
		return _originalClassPK;
	}

	@JSON
	@Override
	public long getCommerceCountryId() {
		return _commerceCountryId;
	}

	@Override
	public void setCommerceCountryId(long commerceCountryId) {
		_columnBitmask |= COMMERCECOUNTRYID_COLUMN_BITMASK;

		if (!_setOriginalCommerceCountryId) {
			_setOriginalCommerceCountryId = true;

			_originalCommerceCountryId = _commerceCountryId;
		}

		_commerceCountryId = commerceCountryId;
	}

	public long getOriginalCommerceCountryId() {
		return _originalCommerceCountryId;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceAddressRestriction.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceAddressRestriction toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceAddressRestriction>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceAddressRestrictionImpl commerceAddressRestrictionImpl =
			new CommerceAddressRestrictionImpl();

		commerceAddressRestrictionImpl.setCommerceAddressRestrictionId(
			getCommerceAddressRestrictionId());
		commerceAddressRestrictionImpl.setGroupId(getGroupId());
		commerceAddressRestrictionImpl.setCompanyId(getCompanyId());
		commerceAddressRestrictionImpl.setUserId(getUserId());
		commerceAddressRestrictionImpl.setUserName(getUserName());
		commerceAddressRestrictionImpl.setCreateDate(getCreateDate());
		commerceAddressRestrictionImpl.setModifiedDate(getModifiedDate());
		commerceAddressRestrictionImpl.setClassNameId(getClassNameId());
		commerceAddressRestrictionImpl.setClassPK(getClassPK());
		commerceAddressRestrictionImpl.setCommerceCountryId(
			getCommerceCountryId());

		commerceAddressRestrictionImpl.resetOriginalValues();

		return commerceAddressRestrictionImpl;
	}

	@Override
	public int compareTo(
		CommerceAddressRestriction commerceAddressRestriction) {

		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceAddressRestriction.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceAddressRestriction)) {
			return false;
		}

		CommerceAddressRestriction commerceAddressRestriction =
			(CommerceAddressRestriction)obj;

		long primaryKey = commerceAddressRestriction.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceAddressRestrictionModelImpl
			commerceAddressRestrictionModelImpl = this;

		commerceAddressRestrictionModelImpl._setModifiedDate = false;

		commerceAddressRestrictionModelImpl._originalClassNameId =
			commerceAddressRestrictionModelImpl._classNameId;

		commerceAddressRestrictionModelImpl._setOriginalClassNameId = false;

		commerceAddressRestrictionModelImpl._originalClassPK =
			commerceAddressRestrictionModelImpl._classPK;

		commerceAddressRestrictionModelImpl._setOriginalClassPK = false;

		commerceAddressRestrictionModelImpl._originalCommerceCountryId =
			commerceAddressRestrictionModelImpl._commerceCountryId;

		commerceAddressRestrictionModelImpl._setOriginalCommerceCountryId =
			false;

		commerceAddressRestrictionModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceAddressRestriction> toCacheModel() {
		CommerceAddressRestrictionCacheModel
			commerceAddressRestrictionCacheModel =
				new CommerceAddressRestrictionCacheModel();

		commerceAddressRestrictionCacheModel.commerceAddressRestrictionId =
			getCommerceAddressRestrictionId();

		commerceAddressRestrictionCacheModel.groupId = getGroupId();

		commerceAddressRestrictionCacheModel.companyId = getCompanyId();

		commerceAddressRestrictionCacheModel.userId = getUserId();

		commerceAddressRestrictionCacheModel.userName = getUserName();

		String userName = commerceAddressRestrictionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceAddressRestrictionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceAddressRestrictionCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceAddressRestrictionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceAddressRestrictionCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceAddressRestrictionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceAddressRestrictionCacheModel.classNameId = getClassNameId();

		commerceAddressRestrictionCacheModel.classPK = getClassPK();

		commerceAddressRestrictionCacheModel.commerceCountryId =
			getCommerceCountryId();

		return commerceAddressRestrictionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceAddressRestriction, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceAddressRestriction, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAddressRestriction, Object>
				attributeGetterFunction = entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceAddressRestriction)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceAddressRestriction, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceAddressRestriction, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAddressRestriction, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceAddressRestriction)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceAddressRestriction>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private long _commerceAddressRestrictionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _originalClassNameId;
	private boolean _setOriginalClassNameId;
	private long _classPK;
	private long _originalClassPK;
	private boolean _setOriginalClassPK;
	private long _commerceCountryId;
	private long _originalCommerceCountryId;
	private boolean _setOriginalCommerceCountryId;
	private long _columnBitmask;
	private CommerceAddressRestriction _escapedModel;

}