/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.constants.CommerceAddressConstants;
import com.liferay.commerce.exception.CommerceAddressCityException;
import com.liferay.commerce.exception.CommerceAddressCountryException;
import com.liferay.commerce.exception.CommerceAddressNameException;
import com.liferay.commerce.exception.CommerceAddressStreetException;
import com.liferay.commerce.exception.CommerceAddressTypeException;
import com.liferay.commerce.exception.CommerceAddressZipException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceGeocoder;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.search.facet.NegatableMultiValueFacet;
import com.liferay.commerce.service.base.CommerceAddressLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CommerceAddressLocalServiceImpl
extends CommerceAddressLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};
    @ServiceReference(type=CommerceGeocoder.class)
    private CommerceGeocoder _commerceGeocoder;
    @ServiceReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;

    @Deprecated
    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        int type = 2;
        if (defaultBilling && !defaultShipping) {
            type = 1;
        } else if (!defaultBilling && defaultShipping) {
            type = 3;
        }
        return this.commerceAddressLocalService.addCommerceAddress(className, classPK, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        return this.commerceAddressLocalService.addCommerceAddress(className, classPK, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, type, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, int type, String externalReferenceCode, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long companyId = user.getCompanyId();
        this.validate(name, street1, city, zip, commerceCountryId, type);
        long commerceAddressId = this.counterLocalService.increment();
        CommerceAddress commerceAddress = this.commerceAddressPersistence.create(commerceAddressId);
        commerceAddress.setCompanyId(companyId);
        commerceAddress.setUserId(user.getUserId());
        commerceAddress.setUserName(user.getFullName());
        commerceAddress.setClassName(className);
        commerceAddress.setClassPK(classPK);
        commerceAddress.setName(name);
        commerceAddress.setDescription(description);
        commerceAddress.setStreet1(street1);
        commerceAddress.setStreet2(street2);
        commerceAddress.setStreet3(street3);
        commerceAddress.setCity(city);
        commerceAddress.setZip(zip);
        commerceAddress.setCommerceRegionId(commerceRegionId);
        commerceAddress.setCommerceCountryId(commerceCountryId);
        commerceAddress.setPhoneNumber(phoneNumber);
        commerceAddress.setType(type);
        commerceAddress.setExternalReferenceCode(externalReferenceCode);
        this.commerceAddressPersistence.update((BaseModel)commerceAddress);
        return commerceAddress;
    }

    public CommerceAddress copyCommerceAddress(long commerceAddressId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        return this.commerceAddressLocalService.addCommerceAddress(className, classPK, commerceAddress.getName(), commerceAddress.getDescription(), commerceAddress.getStreet1(), commerceAddress.getStreet2(), commerceAddress.getStreet3(), commerceAddress.getCity(), commerceAddress.getZip(), commerceAddress.getCommerceRegionId(), commerceAddress.getCommerceCountryId(), commerceAddress.getPhoneNumber(), false, false, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceAddress deleteCommerceAddress(CommerceAddress commerceAddress) throws PortalException {
        this.commerceAddressPersistence.remove((BaseModel)commerceAddress);
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByBillingAddress(commerceAddress.getCommerceAddressId());
        this.removeCommerceOrderAddresses(commerceOrders, commerceAddress.getCommerceAddressId());
        commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(commerceAddress.getCommerceAddressId());
        this.removeCommerceOrderAddresses(commerceOrders, commerceAddress.getCommerceAddressId());
        return commerceAddress;
    }

    @Override
    public CommerceAddress deleteCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        return this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
    }

    public void deleteCommerceAddresses(String className, long classPK) throws PortalException {
        List commerceAddresses = this.commerceAddressPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK);
        for (CommerceAddress commerceAddress : commerceAddresses) {
            this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
        }
    }

    public void deleteCountryCommerceAddresses(long commerceCountryId) throws PortalException {
        List commerceAddresses = this.commerceAddressPersistence.findByCommerceCountryId(commerceCountryId);
        for (CommerceAddress commerceAddress : commerceAddresses) {
            this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
        }
    }

    public void deleteRegionCommerceAddresses(long commerceRegionId) throws PortalException {
        List commerceAddresses = this.commerceAddressPersistence.findByCommerceRegionId(commerceRegionId);
        for (CommerceAddress commerceAddress : commerceAddresses) {
            this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
        }
    }

    public CommerceAddress fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        return this.commerceAddressPersistence.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress geolocateCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        double[] coordinates = this._commerceGeocoder.getCoordinates(commerceAddress.getStreet1(), commerceAddress.getCity(), commerceAddress.getZip(), commerceAddress.getCommerceRegion(), commerceAddress.getCommerceCountry());
        commerceAddress.setLatitude(coordinates[0]);
        commerceAddress.setLongitude(coordinates[1]);
        return (CommerceAddress)this.commerceAddressPersistence.update((BaseModel)commerceAddress);
    }

    public List<CommerceAddress> getBillingAndShippingCommerceAddresses(long companyId, String className, long classPK) {
        return this.commerceAddressPersistence.findByC_C_C_C(companyId, this.classNameLocalService.getClassNameId(className), classPK, 2);
    }

    public List<CommerceAddress> getBillingCommerceAddresses(long companyId, String className, long classPK) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(new int[]{1, 2}, companyId, className, classPK, null, -1, -1, null);
        BaseModelSearchResult<CommerceAddress> billingAddresses = this.searchCommerceAddresses(searchContext);
        return billingAddresses.getBaseModels();
    }

    @Deprecated
    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return new ArrayList<CommerceAddress>();
        }
        return this.commerceAddressPersistence.findByC_C_C(group.getCompanyId(), this.classNameLocalService.getClassNameId(className), classPK);
    }

    @Deprecated
    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return new ArrayList<CommerceAddress>();
        }
        return this.commerceAddressPersistence.findByC_C_C(group.getCompanyId(), this.classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddresses(String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        return this.commerceAddressPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddressesByCompanyId(long companyId, String className, long classPK) {
        return this.commerceAddressPersistence.findByC_C_C(companyId, this.classNameLocalService.getClassNameId(className), classPK);
    }

    public List<CommerceAddress> getCommerceAddressesByCompanyId(long companyId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        return this.commerceAddressPersistence.findByC_C_C(companyId, this.classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    @Deprecated
    public int getCommerceAddressesCount(long groupId, String className, long classPK) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return 0;
        }
        return this.commerceAddressPersistence.countByC_C_C(group.getCompanyId(), this.classNameLocalService.getClassNameId(className), classPK);
    }

    public int getCommerceAddressesCount(String className, long classPK) {
        return this.commerceAddressPersistence.countByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public int getCommerceAddressesCountByCompanyId(long companyId, String className, long classPK) {
        return this.commerceAddressPersistence.countByC_C_C(companyId, this.classNameLocalService.getClassNameId(className), classPK);
    }

    public List<CommerceAddress> getShippingCommerceAddresses(long companyId, String className, long classPK) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(new int[]{3, 2}, companyId, className, classPK, null, -1, -1, null);
        BaseModelSearchResult<CommerceAddress> shippingAddresses = this.searchCommerceAddresses(searchContext);
        return shippingAddresses.getBaseModels();
    }

    @Deprecated
    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, long groupId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, className, classPK, keywords, start, end, sort);
        return this.searchCommerceAddresses(searchContext);
    }

    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, className, classPK, keywords, start, end, sort);
        return this.searchCommerceAddresses(searchContext);
    }

    @Deprecated
    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        int type = 2;
        if (defaultBilling && !defaultShipping) {
            type = 1;
        } else if (!defaultBilling && defaultShipping) {
            type = 3;
        }
        return this.updateCommerceAddress(commerceAddressId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        this.validate(name, street1, city, zip, commerceCountryId, type);
        commerceAddress.setName(name);
        commerceAddress.setDescription(description);
        commerceAddress.setStreet1(street1);
        commerceAddress.setStreet2(street2);
        commerceAddress.setStreet3(street3);
        commerceAddress.setCity(city);
        commerceAddress.setZip(zip);
        commerceAddress.setCommerceRegionId(commerceRegionId);
        commerceAddress.setCommerceCountryId(commerceCountryId);
        commerceAddress.setLatitude(0.0);
        commerceAddress.setLongitude(0.0);
        commerceAddress.setPhoneNumber(phoneNumber);
        commerceAddress.setType(type);
        this.commerceAddressPersistence.update((BaseModel)commerceAddress);
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(commerceAddressId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            this.commerceOrderLocalService.resetCommerceOrderShipping(commerceOrder.getCommerceOrderId());
        }
        return commerceAddress;
    }

    protected SearchContext buildSearchContext(int[] addressTypes, long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = this.buildSearchContext(companyId, className, classPK, keywords, start, end, sort);
        NegatableMultiValueFacet negatableMultiValueFacet = new NegatableMultiValueFacet(searchContext);
        negatableMultiValueFacet.setFieldName("type");
        searchContext.addFacet((Facet)negatableMultiValueFacet);
        negatableMultiValueFacet.setNegated(false);
        searchContext.setAttribute(negatableMultiValueFacet.getFieldId(), (Serializable)((Object)StringUtil.merge((int[])addressTypes)));
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("classNameId", this.classNameLocalService.getClassNameId(className));
        attributes.put("classPK", classPK);
        attributes.put("name", keywords);
        attributes.put("city", keywords);
        attributes.put("countryName", keywords);
        attributes.put("regionName", keywords);
        attributes.put("zip", keywords);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setStart(start);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        return searchContext;
    }

    protected List<CommerceAddress> getCommerceAddresses(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceAddress> commerceAddresses = new ArrayList<CommerceAddress>(documents.size());
        for (Document document : documents) {
            long commerceAddressId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceAddress commerceAddress = this.fetchCommerceAddress(commerceAddressId);
            if (commerceAddress == null) {
                commerceAddresses = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceAddress.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceAddresses == null) continue;
            commerceAddresses.add(commerceAddress);
        }
        return commerceAddresses;
    }

    protected void removeCommerceOrderAddresses(List<CommerceOrder> commerceOrders, long commerceAddressId) throws PortalException {
        for (CommerceOrder commerceOrder : commerceOrders) {
            long billingAddressId = commerceOrder.getBillingAddressId();
            long shippingAddressId = commerceOrder.getShippingAddressId();
            long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
            String shippingOptionName = commerceOrder.getShippingOptionName();
            BigDecimal shippingPrice = commerceOrder.getShippingAmount();
            if (billingAddressId == commerceAddressId) {
                billingAddressId = 0L;
            }
            if (shippingAddressId == commerceAddressId) {
                shippingAddressId = 0L;
                commerceShippingMethodId = 0L;
                shippingOptionName = null;
                shippingPrice = BigDecimal.ZERO;
            }
            this.commerceOrderLocalService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), billingAddressId, shippingAddressId, commerceOrder.getCommercePaymentMethodKey(), commerceShippingMethodId, shippingOptionName, commerceOrder.getPurchaseOrderNumber(), commerceOrder.getSubtotal(), shippingPrice, commerceOrder.getTotal(), commerceOrder.getAdvanceStatus(), null);
        }
    }

    protected BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceAddress.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceAddress> commerceAddresses = this.getCommerceAddresses(hits);
            if (commerceAddresses == null) continue;
            return new BaseModelSearchResult(commerceAddresses, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(String name, String street1, String city, String zip, long commerceCountryId, int type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CommerceAddressNameException();
        }
        if (Validator.isNull((String)street1)) {
            throw new CommerceAddressStreetException();
        }
        if (Validator.isNull((String)city)) {
            throw new CommerceAddressCityException();
        }
        if (Validator.isNull((String)zip)) {
            throw new CommerceAddressZipException();
        }
        if (commerceCountryId <= 0L) {
            throw new CommerceAddressCountryException();
        }
        if (!ArrayUtil.contains((int[])CommerceAddressConstants.ADDRESS_TYPES, (int)type)) {
            throw new CommerceAddressTypeException();
        }
    }
}

