/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.impl.CommerceOrderItemImpl;
import com.liferay.commerce.service.persistence.CommerceOrderItemFinder;
import com.liferay.commerce.service.persistence.impl.CommerceOrderItemFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Iterator;
import java.util.List;

public class CommerceOrderItemFinderImpl
extends CommerceOrderItemFinderBaseImpl
implements CommerceOrderItemFinder {
    public static final String FIND_BY_AVAILABLE_QUANTITY = CommerceOrderItemFinder.class.getName() + ".findByAvailableQuantity";
    public static final String GET_COMMERCE_ORDER_ITEMS_QUANTITY = CommerceOrderItemFinder.class.getName() + ".getCommerceOrderItemsQuantity";
    public static final String GET_CP_INSTANCE_QUANTITY = CommerceOrderItemFinder.class.getName() + ".getCPInstanceQuantity";
    public static final String SUM_VALUE = "SUM_VALUE";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public List<CommerceOrderItem> findByAvailableQuantity(long commerceOrderId) {
        return this.findByAvailableQuantity(commerceOrderId, -1, -1);
    }

    public List<CommerceOrderItem> findByAvailableQuantity(long commerceOrderId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_AVAILABLE_QUANTITY);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceOrderItem", CommerceOrderItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(commerceOrderId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) {
        Session session = null;
        try {
            Long sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), GET_COMMERCE_ORDER_ITEMS_QUANTITY);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar(SUM_VALUE, Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(commerceOrderId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (sum = (Long)itr.next()) != null) {
                int n = sum.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getCPInstanceQuantity(long cpInstanceId, int status) {
        Session session = null;
        try {
            Long sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), GET_CP_INSTANCE_QUANTITY);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar(SUM_VALUE, Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(cpInstanceId);
            qPos.add(status);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (sum = (Long)itr.next()) != null) {
                int n = sum.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

