/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidator;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.order.validator.key=version", "commerce.order.validator.priority:Integer=30"}, service={CommerceOrderValidator.class})
public class VersionCommerceOrderValidatorImpl
implements CommerceOrderValidator {
    public static final String KEY = "version";
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    public String getKey() {
        return KEY;
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrder commerceOrder, CPInstance cpInstance, int quantity) throws PortalException {
        return new CommerceOrderValidatorResult(true);
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrderItem commerceOrderItem) throws PortalException {
        if (commerceOrderItem.getCPInstanceId() != 0L && commerceOrderItem.getCProductId() != 0L) {
            CPInstance cpInstance = commerceOrderItem.getCPInstance();
            CProduct cProduct = commerceOrderItem.getCProduct();
            if (cpInstance.getCPDefinitionId() != cProduct.getPublishedCPDefinitionId() && cProduct.getPublishedCPDefinitionId() != 0L) {
                boolean instanceUpdated = this._updateInstance(commerceOrderItem, cProduct);
                if (instanceUpdated) {
                    return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "this-product-will-be-automatically-updated-to-a-newer-version"));
                }
                return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "there-is-a-newer-version-of-this-product-available"));
            }
        }
        return new CommerceOrderValidatorResult(true);
    }

    protected void setCommerceOrderItemLocalService(CommerceOrderItemLocalService commerceOrderItemLocalService) {
        this._commerceOrderItemLocalService = commerceOrderItemLocalService;
    }

    protected void setCPInstanceLocalService(CPInstanceLocalService cpInstanceLocalService) {
        this._cpInstanceLocalService = cpInstanceLocalService;
    }

    private String _getLocalizedMessage(Locale locale, String key) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)key);
    }

    private boolean _updateInstance(CommerceOrderItem commerceOrderItem, CProduct cProduct) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cProduct.getPublishedCPDefinitionId(), commerceOrderItem.getSku());
        if (cpInstance != null) {
            commerceOrderItem.setCPInstanceId(cpInstance.getCPInstanceId());
            this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
            return true;
        }
        return false;
    }
}

