/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.product.content.contributor;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Portal;
import java.math.BigDecimal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.product.content.contributor.name=price"}, service={CPContentContributor.class})
public class PriceCPContentContributor
implements CPContentContributor {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public String getName() {
        return "price";
    }

    public JSONObject getValue(CPInstance cpInstance, HttpServletRequest httpServletRequest) throws PortalException {
        CommerceContext commerceContext = (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (cpInstance == null) {
            return jsonObject;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest));
        if (commerceChannel == null) {
            return jsonObject;
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(cpInstance.getCPInstanceId(), cpDefinitionInventoryEngine.getMinOrderQuantity(cpInstance), commerceContext);
        CommerceMoney unitPrice = commerceProductPrice.getUnitPrice();
        if (unitPrice != null) {
            Locale locale = this._portal.getLocale(httpServletRequest);
            jsonObject.put("price", unitPrice.format(locale));
            CommerceMoney promoPrice = commerceProductPrice.getUnitPromoPrice();
            BigDecimal promo = promoPrice.getPrice();
            if (promoPrice != null && promo.compareTo(BigDecimal.ZERO) > 0 && promo.compareTo(unitPrice.getPrice()) <= 0) {
                jsonObject.put("promoPrice", promoPrice.format(locale));
            }
        }
        return jsonObject;
    }
}

