/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.base.CommerceOrderServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class CommerceOrderServiceImpl
extends CommerceOrderServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceOrderServiceImpl.class, (String)"_commerceOrderModelResourcePermission", CommerceOrder.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceOrderServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce.order");
    @ServiceReference(type=CommerceAccountLocalService.class)
    private CommerceAccountLocalService _commerceAccountLocalService;
    @ServiceReference(type=CommerceInventoryBookedQuantityLocalService.class)
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;

    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_COMMERCE_ORDER");
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId);
    }

    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_COMMERCE_ORDER");
        return this.commerceOrderLocalService.addCommerceOrder(this.getUserId(), groupId, commerceAccountId, commerceCurrencyId, shippingAddressId, purchaseOrderNumber);
    }

    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_COMMERCE_ORDER");
        return this.commerceOrderLocalService.addCommerceOrder(this.getUserId(), groupId, commerceAccountId, shippingAddressId, purchaseOrderNumber);
    }

    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    public CommerceOrder approveCommerceOrder(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "APPROVE_COMMERCE_ORDER");
        return this.commerceOrderLocalService.approveCommerceOrder(this.getUserId(), commerceOrderId);
    }

    public CommerceOrder checkoutCommerceOrder(long commerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        this._bookQuantities(this.getCommerceOrder(commerceOrderId));
        return this.commerceOrderLocalService.checkoutCommerceOrder(commerceOrderId, commerceContext, serviceContext);
    }

    public void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "DELETE");
        this.commerceOrderLocalService.deleteCommerceOrder(commerceOrderId);
    }

    public CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.executeWorkflowTransition(this.getUserId(), commerceOrderId, workflowTaskId, transitionName, comment);
    }

    public CommerceOrder fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchByExternalReferenceCode(companyId, externalReferenceCode);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceOrderId);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(uuid, groupId);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public int[] getAvailableOrderStatuses(long commerceOrderId) throws PortalException {
        if (commerceOrderId > 0L) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        }
        return this.commerceOrderLocalService.getAvailableOrderStatuses(commerceOrderId);
    }

    public CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        this._checkAccountOrderPermissions(groupId, commerceAccountId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public int getCommerceOrdersCount(long groupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long commerceAccountId) throws PortalException {
        this._checkAccountOrderPermissions(groupId, commerceAccountId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId, commerceAccountId);
    }

    public List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        this._checkAccountOrderPermissions(groupId, commerceAccountId, "VIEW_OPEN_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getUserCommerceOrders(groupId, this.getUserId(), commerceAccountId, Integer.valueOf(2), false, keywords, start, end);
    }

    public int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        this._checkAccountOrderPermissions(groupId, commerceAccountId, "VIEW_OPEN_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getUserCommerceOrdersCount(groupId, this.getUserId(), commerceAccountId, Integer.valueOf(2), false, keywords);
    }

    public List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        this._checkAccountOrderPermissions(groupId, commerceAccountId, "VIEW_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getUserCommerceOrders(groupId, this.getUserId(), commerceAccountId, Integer.valueOf(2), true, keywords, start, end);
    }

    public int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        this._checkAccountOrderPermissions(groupId, commerceAccountId, "VIEW_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getUserCommerceOrdersCount(groupId, this.getUserId(), commerceAccountId, Integer.valueOf(2), true, keywords);
    }

    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), guestCommerceOrderId, "VIEW");
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), userCommerceOrderId, "UPDATE");
        this.commerceOrderLocalService.mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    public CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderLocalService.reorderCommerceOrder(this.getUserId(), commerceOrderId, commerceContext);
    }

    public CommerceOrder submitCommerceOrder(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.submitCommerceOrder(this.getUserId(), commerceOrderId);
    }

    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, commerceContext);
    }

    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, externalReferenceCode, commerceContext);
    }

    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        return this.commerceOrderLocalService.updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    public CommerceOrder updateCustomFields(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCustomFields(commerceOrderId, serviceContext);
    }

    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    public CommerceOrder updateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, orderStatus);
    }

    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        _commerceOrderModelResourcePermission.check(permissionChecker, commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePaymentStatus(permissionChecker.getUserId(), commerceOrderId, paymentStatus);
    }

    public CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        _commerceOrderModelResourcePermission.check(permissionChecker, commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePaymentStatusAndTransactionId(permissionChecker.getUserId(), commerceOrderId, paymentStatus, transactionId);
    }

    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateTransactionId(long commerceOrderId, String transactionId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateTransactionId(commerceOrderId, transactionId);
    }

    public CommerceOrder updateUser(long commerceOrderId, long userId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateUser(commerceOrderId, userId);
    }

    public CommerceOrder upsertCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), externalReferenceCode);
        if (commerceOrder == null) {
            _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_COMMERCE_ORDER");
        } else {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE");
        }
        return this.commerceOrderLocalService.upsertCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, paymentStatus, orderStatus, advanceStatus, externalReferenceCode, commerceContext, serviceContext);
    }

    private void _bookQuantities(CommerceOrder commerceOrder) throws PortalException {
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("OrderId ", String.valueOf(commerceOrderItem.getCommerceOrderId()));
            context.put("OrderItemId ", String.valueOf(commerceOrderItem.getCommerceOrderItemId()));
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.addCommerceBookedQuantity(commerceOrderItem.getUserId(), commerceOrderItem.getSku(), commerceOrderItem.getQuantity(), null, context);
            this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryBookedQuantity.getCommerceInventoryBookedQuantityId());
        }
    }

    private void _checkAccountOrderPermissions(long groupId, long commerceAccountId, String action) throws PortalException {
        CommerceAccount commerceAccount = this._commerceAccountLocalService.fetchCommerceAccount(commerceAccountId);
        if (commerceAccount == null) {
            _portletResourcePermission.check(this.getPermissionChecker(), groupId, action);
        } else if (commerceAccount.isBusinessAccount()) {
            _portletResourcePermission.check(this.getPermissionChecker(), commerceAccount.getCommerceAccountGroup(), action);
        }
    }
}

