/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.service.base.CommerceCountryServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceCountryServiceImpl
extends CommerceCountryServiceBaseImpl {
    public CommerceCountry addCommerceCountry(Map<Locale, String> nameMap, boolean billingAllowed, boolean shippingAllowed, String twoLettersISOCode, String threeLettersISOCode, int numericISOCode, boolean subjectToVAT, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.addCommerceCountry(nameMap, billingAllowed, shippingAllowed, twoLettersISOCode, threeLettersISOCode, numericISOCode, subjectToVAT, priority, active, serviceContext);
    }

    public void deleteCommerceCountry(long commerceCountryId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        this.commerceCountryLocalService.deleteCommerceCountry(commerceCountryId);
    }

    public List<CommerceCountry> getBillingCommerceCountries(long companyId, boolean billingAllowed, boolean active) {
        return this.commerceCountryLocalService.getBillingCommerceCountries(companyId, billingAllowed, active);
    }

    public List<CommerceCountry> getBillingCommerceCountriesByChannelId(long commerceChannelId, int start, int end) {
        return this.commerceCountryLocalService.getBillingCommerceCountriesByChannelId(commerceChannelId, start, end);
    }

    public List<CommerceCountry> getCommerceCountries(long companyId, boolean active) {
        return this.commerceCountryLocalService.getCommerceCountries(companyId, active);
    }

    public List<CommerceCountry> getCommerceCountries(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountries(companyId, active, start, end, orderByComparator);
    }

    public List<CommerceCountry> getCommerceCountries(long companyId, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountries(companyId, start, end, orderByComparator);
    }

    public int getCommerceCountriesCount(long companyId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountriesCount(companyId);
    }

    public int getCommerceCountriesCount(long companyId, boolean active) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountriesCount(companyId, active);
    }

    public CommerceCountry getCommerceCountry(long commerceCountryId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountry(commerceCountryId);
    }

    public CommerceCountry getCommerceCountry(long companyId, String twoLettersISOCode) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountry(companyId, twoLettersISOCode);
    }

    public List<CommerceCountry> getShippingCommerceCountries(long companyId, boolean shippingAllowed, boolean active) {
        return this.commerceCountryLocalService.getShippingCommerceCountries(companyId, shippingAllowed, active);
    }

    public List<CommerceCountry> getShippingCommerceCountriesByChannelId(long commerceChannelId, int start, int end) {
        return this.commerceCountryLocalService.getShippingCommerceCountriesByChannelId(commerceChannelId, start, end);
    }

    public List<CommerceCountry> getWarehouseCommerceCountries(long companyId, boolean all) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getWarehouseCommerceCountries(companyId, all);
    }

    public BaseModelSearchResult<CommerceCountry> searchCommerceCountries(SearchContext searchContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.searchCommerceCountries(searchContext);
    }

    public CommerceCountry setActive(long commerceCountryId, boolean active) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.setActive(commerceCountryId, active);
    }

    public CommerceCountry updateCommerceCountry(long commerceCountryId, Map<Locale, String> nameMap, boolean billingAllowed, boolean shippingAllowed, String twoLettersISOCode, String threeLettersISOCode, int numericISOCode, boolean subjectToVAT, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.updateCommerceCountry(commerceCountryId, nameMap, billingAllowed, shippingAllowed, twoLettersISOCode, threeLettersISOCode, numericISOCode, subjectToVAT, priority, active, serviceContext);
    }

    public CommerceCountry updateCommerceCountryChannelFilter(long commerceCountryId, boolean enable) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.updateCommerceCountryChannelFilter(commerceCountryId, enable);
    }
}

