/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountGroupModel;
import com.liferay.commerce.account.service.CommerceAccountGroupLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceProductPriceCalculation.class})
public class CommerceProductPriceCalculationImpl
implements CommerceProductPriceCalculation {
    @Reference
    private CommerceAccountGroupLocalService _commerceAccountGroupLocalService;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference(target="(resource.name=com.liferay.commerce.product)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        CommerceMoney unitPrice = this.getUnitPrice(cpInstanceId, quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
        CommerceMoney promoPrice = this.getPromoPrice(cpInstanceId, quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
        CommerceProductPriceImpl commerceProductPrice = new CommerceProductPriceImpl();
        commerceProductPrice.setQuantity(quantity);
        commerceProductPrice.setUnitPrice(unitPrice);
        commerceProductPrice.setUnitPromoPrice(promoPrice);
        BigDecimal finalPrice = unitPrice.getPrice();
        BigDecimal promo = promoPrice.getPrice();
        if (promo != null && promo.compareTo(BigDecimal.ZERO) > 0 && promo.compareTo(unitPrice.getPrice()) <= 0) {
            finalPrice = promoPrice.getPrice();
        }
        CommerceDiscountValue commerceDiscountValue = this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPrice, commerceContext);
        finalPrice = finalPrice.multiply(BigDecimal.valueOf(quantity));
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmount = commerceDiscountValue.getDiscountAmount();
            finalPrice = finalPrice.subtract(discountAmount.getPrice());
        }
        commerceProductPrice.setCommerceDiscountValue(commerceDiscountValue);
        commerceProductPrice.setFinalPrice(this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPrice));
        return commerceProductPrice;
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceProductPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        CommerceProductPrice commerceProductPrice = this.getCommerceProductPrice(cpInstanceId, quantity, commerceContext);
        if (commerceProductPrice == null) {
            return null;
        }
        return commerceProductPrice.getFinalPrice();
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getFinalPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getPromoPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        BigDecimal priceListPrice;
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        BigDecimal price = cpInstance.getPromoPrice();
        Optional<CommercePriceList> commercePriceList = this._getPriceList(cpInstance.getGroupId(), commerceContext);
        if (commercePriceList.isPresent() && (priceListPrice = this._getPriceListPrice(cpInstanceId, quantity, commercePriceList.get(), commerceContext.getCommerceCurrency(), true)) != null) {
            return this._commerceMoneyFactory.create(commerceCurrency, priceListPrice);
        }
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpInstance.getGroupId());
        CommerceCurrency catalogCommerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceCatalog.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
        if (catalogCommerceCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(catalogCommerceCurrency.getRate(), RoundingMode.valueOf(catalogCommerceCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        return this._commerceMoneyFactory.create(commerceCurrency, price);
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        CommerceMoney commerceMoney = null;
        BigDecimal maxPrice = BigDecimal.ZERO;
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (maxPrice.compareTo(cpInstanceCommerceMoney.getPrice()) >= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            maxPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMaxPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        CommerceMoney commerceMoney = null;
        BigDecimal minPrice = BigDecimal.ZERO;
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (commerceMoney != null && minPrice.compareTo(cpInstanceCommerceMoney.getPrice()) <= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            minPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMinPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        BigDecimal priceListPrice;
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        BigDecimal price = cpInstance.getPrice();
        Optional<CommercePriceList> commercePriceList = this._getPriceList(cpInstance.getGroupId(), commerceContext);
        if (commercePriceList.isPresent() && (priceListPrice = this._getPriceListPrice(cpInstanceId, quantity, commercePriceList.get(), commerceContext.getCommerceCurrency(), false)) != null) {
            return this._commerceMoneyFactory.create(commerceCurrency, priceListPrice);
        }
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpInstance.getGroupId());
        CommerceCurrency catalogCommerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceCatalog.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
        if (catalogCommerceCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(catalogCommerceCurrency.getRate(), RoundingMode.valueOf(catalogCommerceCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        return this._commerceMoneyFactory.create(commerceCurrency, price);
    }

    private Optional<CommercePriceList> _getPriceList(long groupId, CommerceContext commerceContext) throws PortalException {
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount == null) {
            return Optional.empty();
        }
        List commerceAccountGroups = this._commerceAccountGroupLocalService.getCommerceAccountGroupsByCommerceAccountId(commerceAccount.getCommerceAccountId());
        Stream stream = commerceAccountGroups.stream();
        long[] commerceAccountGroupIds = stream.mapToLong(CommerceAccountGroupModel::getCommerceAccountGroupId).toArray();
        return this._commercePriceListLocalService.getCommercePriceList(commerceAccount.getCompanyId(), groupId, commerceAccount.getCommerceAccountId(), commerceAccountGroupIds);
    }

    private BigDecimal _getPriceListPrice(long cpInstanceId, int quantity, CommercePriceList commercePriceList, CommerceCurrency commerceCurrency, boolean promo) throws PortalException {
        BigDecimal price = null;
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(cpInstanceId, commercePriceList.getCommercePriceListId());
        if (commercePriceEntry != null) {
            CommerceCurrency priceListCurrency;
            CommerceTierPriceEntry commerceTierPriceEntry;
            price = promo ? commercePriceEntry.getPromoPrice() : commercePriceEntry.getPrice();
            if (commercePriceEntry.isHasTierPrice() && (commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.findClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity)) != null) {
                price = promo ? commerceTierPriceEntry.getPromoPrice() : commerceTierPriceEntry.getPrice();
            }
            if ((priceListCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId())).getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
                price = price.divide(priceListCurrency.getRate(), RoundingMode.valueOf(priceListCurrency.getRoundingMode()));
                price = price.multiply(commerceCurrency.getRate());
            }
        }
        return price;
    }

    private boolean _hasViewPricePermission(CommerceContext commerceContext) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount != null && commerceAccount.getType() == 2) {
            return this._portletResourcePermission.contains(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "VIEW_PRICE");
        }
        return this._portletResourcePermission.contains(permissionChecker, commerceContext.getSiteGroupId(), "VIEW_PRICE");
    }
}

