/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.price.CommerceOrderPriceImpl;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderPriceCalculation.class})
public class CommerceOrderPriceCalculationImpl
implements CommerceOrderPriceCalculation {
    @Reference
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommerceTaxCalculation _commerceTaxCalculation;
    @Reference(target="(resource.name=com.liferay.commerce.product)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceOrderPrice getCommerceOrderPrice(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceDiscountValue orderTotalCommerceDiscountValue;
        CommerceMoney discountAmount;
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        if (commerceOrder == null) {
            return this._getEmptyCommerceOrderPrice(commerceContext.getCommerceCurrency());
        }
        if (!commerceOrder.isOpen()) {
            return this._getCommerceOrderPriceFromOrder(commerceOrder);
        }
        CommerceMoney subtotalMoney = this.getSubtotal(commerceOrder, secure, commerceContext);
        CommerceMoney taxValue = this.getTaxValue(commerceOrder, secure, commerceContext);
        BigDecimal shippingAmount = commerceOrder.getShippingAmount();
        BigDecimal subtotalAmount = subtotalMoney.getPrice();
        CommerceDiscountValue orderShippingCommerceDiscountValue = this._commerceDiscountCalculation.getOrderShippingCommerceDiscountValue(commerceOrder, shippingAmount, commerceContext);
        CommerceDiscountValue orderSubtotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderSubtotalCommerceDiscountValue(commerceOrder, subtotalAmount, commerceContext);
        BigDecimal totalAmount = subtotalAmount;
        if (orderSubtotalCommerceDiscountValue != null) {
            discountAmount = orderSubtotalCommerceDiscountValue.getDiscountAmount();
            totalAmount = totalAmount.subtract(discountAmount.getPrice());
        }
        totalAmount = totalAmount.add(shippingAmount);
        if (orderShippingCommerceDiscountValue != null) {
            discountAmount = orderShippingCommerceDiscountValue.getDiscountAmount();
            totalAmount = totalAmount.subtract(discountAmount.getPrice());
        }
        if ((orderTotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderTotalCommerceDiscountValue(commerceOrder, totalAmount = totalAmount.add(taxValue.getPrice()), commerceContext)) != null) {
            CommerceMoney discountAmount2 = orderTotalCommerceDiscountValue.getDiscountAmount();
            totalAmount = totalAmount.subtract(discountAmount2.getPrice());
        }
        CommerceOrderPriceImpl commerceOrderPrice = new CommerceOrderPriceImpl();
        commerceOrderPrice.setShippingDiscountValue(orderShippingCommerceDiscountValue);
        commerceOrderPrice.setSubtotalDiscountValue(orderSubtotalCommerceDiscountValue);
        commerceOrderPrice.setTotalDiscountValue(orderTotalCommerceDiscountValue);
        commerceOrderPrice.setShippingValue(this._commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), shippingAmount));
        commerceOrderPrice.setSubtotal(subtotalMoney);
        commerceOrderPrice.setTaxValue(taxValue);
        commerceOrderPrice.setTotal(this._commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), totalAmount));
        return commerceOrderPrice;
    }

    public CommerceOrderPrice getCommerceOrderPrice(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceOrderPrice(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getSubtotal(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        BigDecimal subtotal = BigDecimal.ZERO;
        if (commerceOrder == null) {
            return this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), subtotal);
        }
        if (!commerceOrder.isOpen()) {
            return this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getSubtotal());
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            subtotal = subtotal.add(commerceOrderItem.getFinalPrice());
        }
        return this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), subtotal);
    }

    public CommerceMoney getSubtotal(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getSubtotal(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getTaxValue(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        if (commerceOrder == null) {
            this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
        }
        if (!commerceOrder.isOpen()) {
            return this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getTaxAmount());
        }
        return this._commerceTaxCalculation.getTaxAmount(commerceOrder, commerceContext);
    }

    public CommerceMoney getTaxValue(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getTaxValue(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getTotal(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (secure && !this._hasViewPricePermission(commerceContext)) {
            return null;
        }
        if (!commerceOrder.isOpen()) {
            return this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getTotal());
        }
        CommerceOrderPrice commerceOrderPrice = this.getCommerceOrderPrice(commerceOrder, commerceContext);
        return commerceOrderPrice.getTotal();
    }

    public CommerceMoney getTotal(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getTotal(commerceOrder, true, commerceContext);
    }

    private CommerceDiscountValue _createCommerceDiscountValue(BigDecimal amount, CommerceCurrency commerceCurrency, BigDecimal discountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4) {
        if (discountAmount == null || amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            return new CommerceDiscountValue(0L, this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO), BigDecimal.ZERO, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        }
        BigDecimal[] discountPercentageValues = new BigDecimal[]{level1, level2, level3, level4};
        BigDecimal discountPercentage = discountAmount.divide(amount.add(discountAmount), RoundingMode.valueOf(commerceCurrency.getRoundingMode()));
        discountPercentage = discountPercentage.multiply(BigDecimal.valueOf(100L));
        return new CommerceDiscountValue(0L, this._commerceMoneyFactory.create(commerceCurrency, discountAmount), discountPercentage, discountPercentageValues);
    }

    private CommerceOrderPrice _getCommerceOrderPriceFromOrder(CommerceOrder commerceOrder) throws PortalException {
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        CommerceDiscountValue shippingDiscountValue = this._createCommerceDiscountValue(commerceOrder.getShippingAmount(), commerceCurrency, commerceOrder.getShippingDiscountAmount(), commerceOrder.getShippingDiscountPercentageLevel1(), commerceOrder.getShippingDiscountPercentageLevel2(), commerceOrder.getShippingDiscountPercentageLevel3(), commerceOrder.getShippingDiscountPercentageLevel4());
        CommerceDiscountValue subtotalDiscountValue = this._createCommerceDiscountValue(commerceOrder.getSubtotal(), commerceCurrency, commerceOrder.getSubtotalDiscountAmount(), commerceOrder.getSubtotalDiscountPercentageLevel1(), commerceOrder.getSubtotalDiscountPercentageLevel2(), commerceOrder.getSubtotalDiscountPercentageLevel3(), commerceOrder.getSubtotalDiscountPercentageLevel4());
        CommerceDiscountValue totalDiscountValue = this._createCommerceDiscountValue(commerceOrder.getTotal(), commerceCurrency, commerceOrder.getTotalDiscountAmount(), commerceOrder.getTotalDiscountPercentageLevel1(), commerceOrder.getTotalDiscountPercentageLevel2(), commerceOrder.getTotalDiscountPercentageLevel3(), commerceOrder.getTotalDiscountPercentageLevel4());
        CommerceOrderPriceImpl commerceOrderPrice = new CommerceOrderPriceImpl();
        commerceOrderPrice.setShippingDiscountValue(shippingDiscountValue);
        commerceOrderPrice.setSubtotalDiscountValue(subtotalDiscountValue);
        commerceOrderPrice.setTotalDiscountValue(totalDiscountValue);
        commerceOrderPrice.setShippingValue(this._commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getShippingAmount()));
        commerceOrderPrice.setSubtotal(this._commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getSubtotal()));
        commerceOrderPrice.setTaxValue(this._commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getTaxAmount()));
        commerceOrderPrice.setTotal(this._commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getTotal()));
        return commerceOrderPrice;
    }

    private CommerceOrderPriceImpl _getEmptyCommerceOrderPrice(CommerceCurrency commerceCurrency) {
        CommerceMoney zero = this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO);
        CommerceOrderPriceImpl commerceOrderPrice = new CommerceOrderPriceImpl();
        commerceOrderPrice.setShippingDiscountValue(null);
        commerceOrderPrice.setSubtotalDiscountValue(null);
        commerceOrderPrice.setTotalDiscountValue(null);
        commerceOrderPrice.setShippingValue(zero);
        commerceOrderPrice.setSubtotal(zero);
        commerceOrderPrice.setTaxValue(zero);
        commerceOrderPrice.setTotal(zero);
        return commerceOrderPrice;
    }

    private boolean _hasViewPricePermission(CommerceContext commerceContext) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount != null && commerceAccount.getType() == 2) {
            return this._portletResourcePermission.contains(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "VIEW_PRICE");
        }
        return this._portletResourcePermission.contains(permissionChecker, commerceContext.getSiteGroupId(), "VIEW_PRICE");
    }
}

