/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.base.CommerceShipmentItemLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class CommerceShipmentItemLocalServiceImpl
extends CommerceShipmentItemLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentItemLocalServiceImpl.class);
    @ServiceReference(type=CommerceInventoryEngine.class)
    private CommerceInventoryEngine _commerceInventoryEngine;
    @ServiceReference(type=CommerceInventoryWarehouseItemLocalService.class)
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem addCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, int quantity, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this.validate(commerceOrderItem, commerceInventoryWarehouseId, quantity, quantity);
        long commerceShipmentItemId = this.counterLocalService.increment();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.create(commerceShipmentItemId);
        commerceShipmentItem.setGroupId(groupId);
        commerceShipmentItem.setCompanyId(user.getCompanyId());
        commerceShipmentItem.setUserId(user.getUserId());
        commerceShipmentItem.setUserName(user.getFullName());
        commerceShipmentItem.setCommerceShipmentId(commerceShipmentId);
        commerceShipmentItem.setCommerceOrderItemId(commerceOrderItemId);
        commerceShipmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        commerceOrderItem = this.commerceOrderItemLocalService.incrementShippedQuantity(commerceOrderItemId, quantity);
        this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId());
        return commerceShipmentItem;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipmentItem deleteCommerceShipmentItem(CommerceShipmentItem commerceShipmentItem) {
        CommerceOrderItem commerceOrderItem = null;
        int shippedQuantity = commerceShipmentItem.getQuantity() * -1;
        try {
            commerceOrderItem = this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), shippedQuantity);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        try {
            this._restoreStockQuantity(commerceOrderItem, commerceShipmentItem);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        this.commerceShipmentItemPersistence.remove((BaseModel)commerceShipmentItem);
        return commerceShipmentItem;
    }

    @Override
    public CommerceShipmentItem deleteCommerceShipmentItem(long commerceShipmentItemId) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem);
    }

    public void deleteCommerceShipmentItems(long commerceShipment) {
        List commerceShipmentItems = this.commerceShipmentItemPersistence.findByCommerceShipment(commerceShipment);
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem);
        }
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceOrderItemId) {
        return this.commerceShipmentItemFinder.findByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByCommerceShipment(commerceShipmentId, start, end, orderByComparator);
    }

    public int getCommerceShipmentItemsCount(long commerceShipmentId) {
        return this.commerceShipmentItemPersistence.countByCommerceShipment(commerceShipmentId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, int quantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        int newQuantity = quantity - commerceShipmentItem.getQuantity();
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        this.validate(commerceOrderItem, commerceShipmentItem.getCommerceInventoryWarehouseId(), quantity, newQuantity);
        this.commerceOrderItemLocalService.incrementShippedQuantity(commerceOrderItem.getCommerceOrderItemId(), newQuantity);
        this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId());
        return commerceShipmentItem;
    }

    protected void validate(CommerceOrderItem commerceOrderItem, long commerceInventoryWarehouseId, int quantity, int newQuantity) throws PortalException {
        int availableQuantity = commerceOrderItem.getQuantity() - commerceOrderItem.getShippedQuantity();
        int commerceInventoryWarehouseQuantity = this.commerceOrderItemLocalService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouseId);
        if (quantity <= 0 || newQuantity > availableQuantity || newQuantity > commerceInventoryWarehouseQuantity) {
            throw new CommerceShipmentItemQuantityException();
        }
    }

    private CommerceInventoryWarehouseItem _fetchCommerceInventoryWarehouseItem(long commerceShipmentItemId, String sku) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceShipmentItem.getCommerceInventoryWarehouseId(), sku);
    }

    private void _restoreStockQuantity(CommerceOrderItem commerceOrderItem, CommerceShipmentItem commerceShipmentItem) throws PortalException {
        this._commerceInventoryEngine.increaseStockQuantity(commerceShipmentItem.getUserId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), commerceOrderItem.getSku(), commerceShipmentItem.getQuantity());
    }

    private void _updateStockQuantity(CommerceOrderItem commerceOrderItem, long commerceShipmentItemId) throws PortalException {
        if (commerceOrderItem == null) {
            return;
        }
        final CPInstance cpInstance = commerceOrderItem.getCPInstance();
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._fetchCommerceInventoryWarehouseItem(commerceShipmentItemId, cpInstance.getSku());
        if (commerceInventoryWarehouseItem == null) {
            return;
        }
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("commerceOrderId", String.valueOf(commerceOrderItem.getCommerceOrderId()));
        context.put("commerceOrderItemId", String.valueOf(commerceOrderItem.getCommerceOrderItemId()));
        context.put("commerceShipmentId", String.valueOf(commerceShipmentItem.getCommerceShipmentId()));
        context.put("commerceShipmentItemId", String.valueOf(commerceShipmentItemId));
        this._commerceInventoryEngine.consumeQuantity(commerceShipmentItem.getUserId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), commerceOrderItem.getSku(), commerceShipmentItem.getQuantity(), commerceOrderItem.getBookedQuantityId(), context);
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("cpInstanceId", (Object)cpInstance.getCPInstanceId());
                MessageBusUtil.sendMessage((String)"liferay/stock_quantity", (Message)message);
                return null;
            }
        });
    }
}

