/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.NoSuchAvailabilityEstimateException;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.service.base.CPDAvailabilityEstimateLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.spring.extender.service.ServiceReference;

public class CPDAvailabilityEstimateLocalServiceImpl
extends CPDAvailabilityEstimateLocalServiceBaseImpl {
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;

    @Override
    @SystemEvent(type=1)
    public CPDAvailabilityEstimate deleteCPDAvailabilityEstimate(CPDAvailabilityEstimate cpdAvailabilityEstimate) {
        return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.remove((BaseModel)cpdAvailabilityEstimate);
    }

    @Override
    public CPDAvailabilityEstimate deleteCPDAvailabilityEstimate(long cpdAvailabilityEstimateId) throws PortalException {
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.findByPrimaryKey(cpdAvailabilityEstimateId);
        return this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimate(cpdAvailabilityEstimate);
    }

    @Deprecated
    public void deleteCPDAvailabilityEstimateByCPDefinitionId(long cpDefinitionId) {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition != null) {
            this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimateByCProductId(cpDefinition.getCProductId());
        }
    }

    public void deleteCPDAvailabilityEstimateByCProductId(long cProductId) {
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimateLocalService.fetchCPDAvailabilityEstimateByCProductId(cProductId);
        if (cpdAvailabilityEstimate != null) {
            this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimate(cpdAvailabilityEstimate);
        }
    }

    public void deleteCPDAvailabilityEstimates(long commerceAvailabilityEstimateId) {
        this.cpdAvailabilityEstimatePersistence.removeByCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
    }

    @Deprecated
    public CPDAvailabilityEstimate fetchCPDAvailabilityEstimateByCPDefinitionId(long cpDefinitionId) {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            return null;
        }
        return this.cpdAvailabilityEstimateLocalService.fetchCPDAvailabilityEstimateByCProductId(cpDefinition.getCProductId());
    }

    public CPDAvailabilityEstimate fetchCPDAvailabilityEstimateByCProductId(long cProductId) {
        return this.cpdAvailabilityEstimatePersistence.fetchByCProductId(cProductId);
    }

    @Deprecated
    public CPDAvailabilityEstimate updateCPDAvailabilityEstimate(long cpdAvailabilityEstimateId, long cpDefinitionId, long commerceAvailabilityEstimateId, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this.cpdAvailabilityEstimateLocalService.updateCPDAvailabilityEstimateByCProductId(cpdAvailabilityEstimateId, cpDefinition.getCProductId(), commerceAvailabilityEstimateId, serviceContext);
    }

    public CPDAvailabilityEstimate updateCPDAvailabilityEstimateByCProductId(long cpdAvailabilityEstimateId, long cProductId, long commerceAvailabilityEstimateId, ServiceContext serviceContext) throws PortalException {
        this.validate(commerceAvailabilityEstimateId);
        if (cpdAvailabilityEstimateId > 0L) {
            CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.findByPrimaryKey(cpdAvailabilityEstimateId);
            cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
            return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        }
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.fetchCPDAvailabilityEstimateByCProductId(cProductId);
        if (cpdAvailabilityEstimate != null) {
            cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
            return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        }
        return this.addCPDAvailabilityEstimateByCProductId(cProductId, commerceAvailabilityEstimateId, serviceContext);
    }

    protected CPDAvailabilityEstimate addCPDAvailabilityEstimateByCProductId(long cProductId, long commerceAvailabilityEstimateId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long cpdAvailabilityEstimateId = this.counterLocalService.increment();
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.create(cpdAvailabilityEstimateId);
        cpdAvailabilityEstimate.setUuid(serviceContext.getUuid());
        cpdAvailabilityEstimate.setCompanyId(user.getCompanyId());
        cpdAvailabilityEstimate.setUserId(user.getUserId());
        cpdAvailabilityEstimate.setUserName(user.getFullName());
        cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
        cpdAvailabilityEstimate.setCProductId(cProductId);
        this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        return cpdAvailabilityEstimate;
    }

    protected void validate(long commerceAvailabilityEstimateId) throws PortalException {
        CommerceAvailabilityEstimate commerceAvailabilityEstimate;
        if (commerceAvailabilityEstimateId > 0L && (commerceAvailabilityEstimate = this.commerceAvailabilityEstimateLocalService.fetchCommerceAvailabilityEstimate(commerceAvailabilityEstimateId)) == null) {
            throw new NoSuchAvailabilityEstimateException();
        }
    }
}

