/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.context;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.http.HttpServletRequest;

public class CommerceContextHttpImpl
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(CommerceContextHttpImpl.class);
    private CommerceAccount _commerceAccount;
    private long[] _commerceAccountGroupIds;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final CommerceAccountHelper _commerceAccountHelper;
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderHttpHelper _commerceOrderHttpHelper;
    private final HttpServletRequest _httpServletRequest;
    private final Portal _portal;

    public CommerceContextHttpImpl(HttpServletRequest httpServletRequest, CommerceAccountHelper commerceAccountHelper, CommerceChannelLocalService commerceChannelLocalService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceOrderHttpHelper commerceOrderHttpHelper, ConfigurationProvider configurationProvider, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._commerceAccountHelper = commerceAccountHelper;
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceOrderHttpHelper = commerceOrderHttpHelper;
        this._portal = portal;
        try {
            this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._portal.getScopeGroupId(httpServletRequest), "com.liferay.commerce.account"));
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
    }

    public CommerceAccount getCommerceAccount() throws PortalException {
        if (this._commerceAccount != null) {
            return this._commerceAccount;
        }
        this._commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(this._httpServletRequest);
        return this._commerceAccount;
    }

    public long[] getCommerceAccountGroupIds() throws PortalException {
        if (this._commerceAccountGroupIds != null) {
            return this._commerceAccountGroupIds;
        }
        CommerceAccount commerceAccount = this.getCommerceAccount();
        if (commerceAccount == null) {
            return new long[0];
        }
        this._commerceAccountGroupIds = this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccount.getCommerceAccountId());
        return this._commerceAccountGroupIds;
    }

    public long getCommerceChannelGroupId() throws PortalException {
        return this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(this.getSiteGroupId());
    }

    public long getCommerceChannelId() throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this.getSiteGroupId());
        if (commerceChannel == null) {
            return 0L;
        }
        return commerceChannel.getCommerceChannelId();
    }

    public CommerceCurrency getCommerceCurrency() throws PortalException {
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
        this._commerceCurrency = commerceChannel == null ? this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(this._portal.getCompanyId(this._httpServletRequest)) : this._commerceCurrencyLocalService.getCommerceCurrency(this._portal.getCompanyId(this._httpServletRequest), commerceChannel.getCommerceCurrencyCode());
        return this._commerceCurrency;
    }

    public CommerceOrder getCommerceOrder() throws PortalException {
        if (this._commerceOrder != null) {
            return this._commerceOrder;
        }
        this._commerceOrder = this._commerceOrderHttpHelper.getCurrentCommerceOrder(this._httpServletRequest);
        return this._commerceOrder;
    }

    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    public long getSiteGroupId() throws PortalException {
        return this._portal.getScopeGroupId(this._httpServletRequest);
    }
}

