/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceAddressCityException;
import com.liferay.commerce.exception.CommerceAddressCountryException;
import com.liferay.commerce.exception.CommerceAddressNameException;
import com.liferay.commerce.exception.CommerceAddressStreetException;
import com.liferay.commerce.exception.CommerceAddressZipException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceGeocoder;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.base.CommerceAddressLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CommerceAddressLocalServiceImpl
extends CommerceAddressLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    @ServiceReference(type=CommerceGeocoder.class)
    private CommerceGeocoder _commerceGeocoder;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        this.validate(0L, groupId, className, classPK, name, street1, city, zip, commerceCountryId, defaultBilling, defaultShipping);
        long commerceAddressId = this.counterLocalService.increment();
        CommerceAddress commerceAddress = this.commerceAddressPersistence.create(commerceAddressId);
        commerceAddress.setGroupId(groupId);
        commerceAddress.setCompanyId(user.getCompanyId());
        commerceAddress.setUserId(user.getUserId());
        commerceAddress.setUserName(user.getFullName());
        commerceAddress.setClassName(className);
        commerceAddress.setClassPK(classPK);
        commerceAddress.setName(name);
        commerceAddress.setDescription(description);
        commerceAddress.setStreet1(street1);
        commerceAddress.setStreet2(street2);
        commerceAddress.setStreet3(street3);
        commerceAddress.setCity(city);
        commerceAddress.setZip(zip);
        commerceAddress.setCommerceRegionId(commerceRegionId);
        commerceAddress.setCommerceCountryId(commerceCountryId);
        commerceAddress.setPhoneNumber(phoneNumber);
        commerceAddress.setDefaultBilling(defaultBilling);
        commerceAddress.setDefaultShipping(defaultShipping);
        this.commerceAddressPersistence.update((BaseModel)commerceAddress);
        return commerceAddress;
    }

    public CommerceAddress copyCommerceAddress(long commerceAddressId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        return this.commerceAddressLocalService.addCommerceAddress(className, classPK, commerceAddress.getName(), commerceAddress.getDescription(), commerceAddress.getStreet1(), commerceAddress.getStreet2(), commerceAddress.getStreet3(), commerceAddress.getCity(), commerceAddress.getZip(), commerceAddress.getCommerceRegionId(), commerceAddress.getCommerceCountryId(), commerceAddress.getPhoneNumber(), false, false, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceAddress deleteCommerceAddress(CommerceAddress commerceAddress) throws PortalException {
        this.commerceAddressPersistence.remove((BaseModel)commerceAddress);
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByBillingAddress(commerceAddress.getCommerceAddressId());
        this.removeCommerceOrderAddresses(commerceOrders, commerceAddress.getCommerceAddressId());
        commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(commerceAddress.getCommerceAddressId());
        this.removeCommerceOrderAddresses(commerceOrders, commerceAddress.getCommerceAddressId());
        return commerceAddress;
    }

    @Override
    public CommerceAddress deleteCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        return this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
    }

    public void deleteCommerceAddresses(String className, long classPK) throws PortalException {
        List commerceAddresses = this.commerceAddressPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK);
        for (CommerceAddress commerceAddress : commerceAddresses) {
            this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
        }
    }

    public void deleteCountryCommerceAddresses(long commerceCountryId) throws PortalException {
        List commerceAddresses = this.commerceAddressPersistence.findByCommerceCountryId(commerceCountryId);
        for (CommerceAddress commerceAddress : commerceAddresses) {
            this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
        }
    }

    public void deleteRegionCommerceAddresses(long commerceRegionId) throws PortalException {
        List commerceAddresses = this.commerceAddressPersistence.findByCommerceRegionId(commerceRegionId);
        for (CommerceAddress commerceAddress : commerceAddresses) {
            this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress geolocateCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        double[] coordinates = this._commerceGeocoder.getCoordinates(commerceAddress.getStreet1(), commerceAddress.getCity(), commerceAddress.getZip(), commerceAddress.getCommerceRegion(), commerceAddress.getCommerceCountry());
        commerceAddress.setLatitude(coordinates[0]);
        commerceAddress.setLongitude(coordinates[1]);
        return (CommerceAddress)this.commerceAddressPersistence.update((BaseModel)commerceAddress);
    }

    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK) {
        return this.commerceAddressPersistence.findByG_C_C(groupId, this.classNameLocalService.getClassNameId(className), classPK);
    }

    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        return this.commerceAddressPersistence.findByG_C_C(groupId, this.classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddresses(String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        return this.commerceAddressPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public int getCommerceAddressesCount(long groupId, String className, long classPK) {
        return this.commerceAddressPersistence.countByG_C_C(groupId, this.classNameLocalService.getClassNameId(className), classPK);
    }

    public int getCommerceAddressesCount(String className, long classPK) {
        return this.commerceAddressPersistence.countByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, long groupId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, className, classPK, keywords, start, end, sort);
        return this.searchCommerceAddresses(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressPersistence.findByPrimaryKey(commerceAddressId);
        this.validate(commerceAddress.getCommerceAddressId(), commerceAddress.getGroupId(), commerceAddress.getClassName(), commerceAddress.getClassPK(), name, street1, city, zip, commerceCountryId, defaultBilling, defaultShipping);
        commerceAddress.setName(name);
        commerceAddress.setDescription(description);
        commerceAddress.setStreet1(street1);
        commerceAddress.setStreet2(street2);
        commerceAddress.setStreet3(street3);
        commerceAddress.setCity(city);
        commerceAddress.setZip(zip);
        commerceAddress.setCommerceRegionId(commerceRegionId);
        commerceAddress.setCommerceCountryId(commerceCountryId);
        commerceAddress.setLatitude(0.0);
        commerceAddress.setLongitude(0.0);
        commerceAddress.setPhoneNumber(phoneNumber);
        commerceAddress.setDefaultBilling(defaultBilling);
        commerceAddress.setDefaultShipping(defaultShipping);
        this.commerceAddressPersistence.update((BaseModel)commerceAddress);
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(commerceAddressId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            this.commerceOrderLocalService.resetCommerceOrderShipping(commerceOrder.getCommerceOrderId());
        }
        return commerceAddress;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, String className, long classPK, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("classNameId", this.classNameLocalService.getClassNameId(className));
        attributes.put("classPK", classPK);
        attributes.put("name", keywords);
        attributes.put("city", keywords);
        attributes.put("countryName", keywords);
        attributes.put("regionName", keywords);
        attributes.put("zip", keywords);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setStart(start);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        return searchContext;
    }

    protected List<CommerceAddress> getCommerceAddresses(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceAddress> commerceAddresses = new ArrayList<CommerceAddress>(documents.size());
        for (Document document : documents) {
            long commerceAddressId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceAddress commerceAddress = this.fetchCommerceAddress(commerceAddressId);
            if (commerceAddress == null) {
                commerceAddresses = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceAddress.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceAddresses == null) continue;
            commerceAddresses.add(commerceAddress);
        }
        return commerceAddresses;
    }

    protected void removeCommerceOrderAddresses(List<CommerceOrder> commerceOrders, long commerceAddressId) throws PortalException {
        for (CommerceOrder commerceOrder : commerceOrders) {
            long billingAddressId = commerceOrder.getBillingAddressId();
            long shippingAddressId = commerceOrder.getShippingAddressId();
            long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
            String shippingOptionName = commerceOrder.getShippingOptionName();
            BigDecimal shippingPrice = commerceOrder.getShippingAmount();
            if (billingAddressId == commerceAddressId) {
                billingAddressId = 0L;
            }
            if (shippingAddressId == commerceAddressId) {
                shippingAddressId = 0L;
                commerceShippingMethodId = 0L;
                shippingOptionName = null;
                shippingPrice = BigDecimal.ZERO;
            }
            this.commerceOrderLocalService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), billingAddressId, shippingAddressId, commerceOrder.getCommercePaymentMethodKey(), commerceShippingMethodId, shippingOptionName, commerceOrder.getPurchaseOrderNumber(), commerceOrder.getSubtotal(), shippingPrice, commerceOrder.getTotal(), commerceOrder.getAdvanceStatus(), null);
        }
    }

    protected BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceAddress.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceAddress> commerceAddresses = this.getCommerceAddresses(hits);
            if (commerceAddresses == null) continue;
            return new BaseModelSearchResult(commerceAddresses, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long commerceAddressId, long groupId, String className, long classPK, String name, String street1, String city, String zip, long commerceCountryId, boolean defaultBilling, boolean defaultShipping) throws PortalException {
        List commerceAddresses;
        if (Validator.isNull((String)name)) {
            throw new CommerceAddressNameException();
        }
        if (Validator.isNull((String)street1)) {
            throw new CommerceAddressStreetException();
        }
        if (Validator.isNull((String)city)) {
            throw new CommerceAddressCityException();
        }
        if (Validator.isNull((String)zip)) {
            throw new CommerceAddressZipException();
        }
        if (commerceCountryId <= 0L) {
            throw new CommerceAddressCountryException();
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        if (defaultBilling) {
            commerceAddresses = this.commerceAddressPersistence.findByG_C_C_DB(groupId, classNameId, classPK, true);
            for (CommerceAddress commerceAddress : commerceAddresses) {
                if (commerceAddress.getCommerceAddressId() == commerceAddressId) continue;
                commerceAddress.setDefaultBilling(false);
                this.commerceAddressPersistence.update((BaseModel)commerceAddress);
            }
        }
        if (defaultShipping) {
            commerceAddresses = this.commerceAddressPersistence.findByG_C_C_DS(groupId, classNameId, classPK, true);
            for (CommerceAddress commerceAddress : commerceAddresses) {
                if (commerceAddress.getCommerceAddressId() == commerceAddressId) continue;
                commerceAddress.setDefaultShipping(false);
                this.commerceAddressPersistence.update((BaseModel)commerceAddress);
            }
        }
    }
}

