/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.service.base.CommerceCountryServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceCountryServiceImpl
extends CommerceCountryServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceCountryServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceCountry addCommerceCountry(Map<Locale, String> nameMap, boolean billingAllowed, boolean shippingAllowed, String twoLettersISOCode, String threeLettersISOCode, int numericISOCode, boolean subjectToVAT, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.addCommerceCountry(nameMap, billingAllowed, shippingAllowed, twoLettersISOCode, threeLettersISOCode, numericISOCode, subjectToVAT, priority, active, serviceContext);
    }

    public void deleteCommerceCountry(long commerceCountryId) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        this.commerceCountryLocalService.deleteCommerceCountry(commerceCountry);
    }

    public List<CommerceCountry> getBillingCommerceCountries(long groupId, boolean billingAllowed, boolean active) {
        return this.commerceCountryLocalService.getBillingCommerceCountries(groupId, billingAllowed, active);
    }

    public List<CommerceCountry> getCommerceCountries(long groupId, boolean active) {
        return this.commerceCountryLocalService.getCommerceCountries(groupId, active);
    }

    public List<CommerceCountry> getCommerceCountries(long groupId, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountries(groupId, active, start, end, orderByComparator);
    }

    public List<CommerceCountry> getCommerceCountries(long groupId, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountries(groupId, start, end, orderByComparator);
    }

    public int getCommerceCountriesCount(long groupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountriesCount(groupId);
    }

    public int getCommerceCountriesCount(long groupId, boolean active) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getCommerceCountriesCount(groupId, active);
    }

    public CommerceCountry getCommerceCountry(long commerceCountryId) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryLocalService.getCommerceCountry(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return commerceCountry;
    }

    public List<CommerceCountry> getShippingCommerceCountries(long groupId, boolean shippingAllowed, boolean active) {
        return this.commerceCountryLocalService.getShippingCommerceCountries(groupId, shippingAllowed, active);
    }

    public List<CommerceCountry> getWarehouseCommerceCountries(long groupId, boolean all) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.getWarehouseCommerceCountries(groupId, all);
    }

    public BaseModelSearchResult<CommerceCountry> searchCommerceCountries(long groupId, SearchContext searchContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.searchCommerceCountries(searchContext);
    }

    public CommerceCountry setActive(long commerceCountryId, boolean active) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.setActive(commerceCountryId, active);
    }

    public CommerceCountry updateCommerceCountry(long commerceCountryId, Map<Locale, String> nameMap, boolean billingAllowed, boolean shippingAllowed, String twoLettersISOCode, String threeLettersISOCode, int numericISOCode, boolean subjectToVAT, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceCountryLocalService.updateCommerceCountry(commerceCountry.getCommerceCountryId(), nameMap, billingAllowed, shippingAllowed, twoLettersISOCode, threeLettersISOCode, numericISOCode, subjectToVAT, priority, active, serviceContext);
    }
}

