/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.base.CommerceAddressServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceAddressServiceImpl
extends CommerceAddressServiceBaseImpl {
    @ServiceReference(type=CommerceAccountService.class)
    private CommerceAccountService _commerceAccountService;

    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.addCommerceAddress(className, classPK, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, defaultBilling, defaultShipping, serviceContext);
    }

    public void deleteCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.getCommerceAddress(commerceAddressId);
        this.checkPermission(commerceAddress);
        this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
    }

    public CommerceAddress fetchCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.fetchCommerceAddress(commerceAddressId);
        if (commerceAddress != null) {
            this.checkPermission(commerceAddress);
        }
        return commerceAddress;
    }

    public CommerceAddress getCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.getCommerceAddress(commerceAddressId);
        this.checkPermission(commerceAddress);
        return commerceAddress;
    }

    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddresses(groupId, className, classPK);
    }

    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddresses(groupId, className, classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddresses(String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddresses(className, classPK, start, end, orderByComparator);
    }

    public int getCommerceAddressesCount(long groupId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddressesCount(groupId, className, classPK);
    }

    public int getCommerceAddressesCount(String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddressesCount(className, classPK);
    }

    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, long groupId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.searchCommerceAddresses(companyId, groupId, className, classPK, keywords, start, end, sort);
    }

    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.getCommerceAddress(commerceAddressId);
        this.checkPermission(commerceAddress);
        return this.commerceAddressLocalService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, defaultBilling, defaultShipping, serviceContext);
    }

    protected void checkPermission(CommerceAddress commerceAddress) throws PortalException {
        this.checkPermission(commerceAddress.getClassName(), commerceAddress.getClassPK());
    }

    protected void checkPermission(String className, long classPK) throws PortalException {
        if (className.equals(CommerceOrder.class.getName())) {
            this.commerceOrderService.getCommerceOrder(classPK);
        } else if (className.equals(CommerceAccount.class.getName())) {
            this._commerceAccountService.getCommerceAccount(classPK);
        }
    }
}

