/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.notification.type;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.notification.type.key=subscription-renewed", "commerce.notification.type.order:Integer=20"}, service={CommerceNotificationType.class})
public class SubscriptionRenewedCommerceNotificationTypeImpl
implements CommerceNotificationType {
    public static final String KEY = "subscription-renewed";
    private static final String _ORDER_CREATOR = "[%ORDER_CREATOR%]";
    private static final String _ORDER_ID = "[%ORDER_ID%]";
    private static final String _PRODUCT_NAME = "[%PRODUCT_NAME%]";
    private CommerceOrderItem _commerceOrderItem;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Map<String, String> getDefinitionTerms(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        map.put(_ORDER_CREATOR, LanguageUtil.get((ResourceBundle)resourceBundle, (String)"order-creator-definition-term"));
        map.put(_ORDER_ID, LanguageUtil.get((ResourceBundle)resourceBundle, (String)"order-id-definition-term"));
        map.put(_PRODUCT_NAME, LanguageUtil.get((ResourceBundle)resourceBundle, (String)"product-name"));
        return map;
    }

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        if (!(object instanceof CommerceSubscriptionEntry)) {
            return term;
        }
        CommerceSubscriptionEntry commerceSubscriptionEntry = (CommerceSubscriptionEntry)object;
        if (this._commerceOrderItem == null) {
            this._commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceSubscriptionEntry.getCommerceOrderItemId());
        }
        if (term.equals(_ORDER_CREATOR)) {
            CommerceOrder commerceOrder = this._commerceOrderItem.getCommerceOrder();
            CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
            if (commerceAccount.getType() == 1) {
                User user = this._userLocalService.getUser(GetterUtil.getLong((String)commerceAccount.getName()));
                return user.getFullName(true, true);
            }
            return commerceAccount.getName();
        }
        if (term.equals(_ORDER_ID)) {
            return String.valueOf(this._commerceOrderItem.getCommerceOrderId());
        }
        if (term.equals(_PRODUCT_NAME)) {
            CPDefinition cpDefinition = this._commerceOrderItem.getCPDefinition();
            return cpDefinition.getName(LocaleUtil.toLanguageId((Locale)locale));
        }
        return term;
    }

    public String getKey() {
        return KEY;
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)KEY);
    }
}

