/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceWarehouse;
import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.base.CommerceWarehouseItemLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Collections;
import java.util.List;

public class CommerceWarehouseItemLocalServiceImpl
extends CommerceWarehouseItemLocalServiceBaseImpl {
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CPInstanceLocalService.class)
    private CPInstanceLocalService _cpInstanceLocalService;

    @Deprecated
    public CommerceWarehouseItem addCommerceWarehouseItem(long commerceWarehouseId, long cpInstanceId, int quantity, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        return this.commerceWarehouseItemLocalService.addCommerceWarehouseItem(commerceWarehouseId, cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), quantity, serviceContext);
    }

    public CommerceWarehouseItem addCommerceWarehouseItem(long commerceWarehouseId, long cProductId, String cpInstanceUuid, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehouseLocalService.getCommerceWarehouse(commerceWarehouseId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceWarehouseItemId = this.counterLocalService.increment();
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemPersistence.create(commerceWarehouseItemId);
        commerceWarehouseItem.setGroupId(commerceWarehouse.getGroupId());
        commerceWarehouseItem.setCompanyId(user.getCompanyId());
        commerceWarehouseItem.setUserId(user.getUserId());
        commerceWarehouseItem.setUserName(user.getFullName());
        commerceWarehouseItem.setCommerceWarehouseId(commerceWarehouseId);
        commerceWarehouseItem.setCProductId(cProductId);
        commerceWarehouseItem.setCPInstanceUuid(cpInstanceUuid);
        commerceWarehouseItem.setQuantity(quantity);
        this.commerceWarehouseItemPersistence.update((BaseModel)commerceWarehouseItem);
        return commerceWarehouseItem;
    }

    public void deleteCommerceWarehouseItems(long commerceWarehouseId) {
        this.commerceWarehouseItemPersistence.removeByCommerceWarehouseId(commerceWarehouseId);
    }

    public void deleteCommerceWarehouseItemsByCPI_CPIU(long cProductId, String cpInstanceUuid) {
        this.commerceWarehouseItemPersistence.removeByCPI_CPIU(cProductId, cpInstanceUuid);
    }

    @Deprecated
    public void deleteCommerceWarehouseItemsByCPInstanceId(long cpInstanceId) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return;
        }
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpInstance.getCPDefinitionId());
        if (cpDefinition == null) {
            return;
        }
        this.commerceWarehouseItemLocalService.deleteCommerceWarehouseItemsByCPI_CPIU(cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid());
    }

    public void deleteCommerceWarehouseItemsByCWI_CPIU(long commerceWarehouseId, String cpInstanceUuid) {
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemPersistence.fetchByCWI_CPIU(commerceWarehouseId, cpInstanceUuid);
        if (commerceWarehouseItem != null) {
            this.commerceWarehouseItemPersistence.remove((BaseModel)commerceWarehouseItem);
        }
    }

    @Deprecated
    public CommerceWarehouseItem fetchCommerceWarehouseItem(long commerceWarehouseId, long cpInstanceId) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return null;
        }
        return this.commerceWarehouseItemLocalService.fetchCommerceWarehouseItemByCWI_CPIU(commerceWarehouseId, cpInstance.getCPInstanceUuid());
    }

    public CommerceWarehouseItem fetchCommerceWarehouseItemByCWI_CPIU(long commerceWarehouseId, String cpInstanceUuid) {
        return this.commerceWarehouseItemPersistence.fetchByCWI_CPIU(commerceWarehouseId, cpInstanceUuid);
    }

    @Deprecated
    public List<CommerceWarehouseItem> getCommerceWarehouseItems(long cpInstanceId) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return Collections.emptyList();
        }
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpInstance.getCPDefinitionId());
        if (cpDefinition == null) {
            return Collections.emptyList();
        }
        return this.commerceWarehouseItemLocalService.getCommerceWarehouseItemsByCPI_CPIU(cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid());
    }

    @Deprecated
    public List<CommerceWarehouseItem> getCommerceWarehouseItems(long cpInstanceId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return Collections.emptyList();
        }
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpInstance.getCPDefinitionId());
        if (cpDefinition == null) {
            return Collections.emptyList();
        }
        return this.commerceWarehouseItemLocalService.getCommerceWarehouseItemsByCPI_CPIU(cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), start, end, orderByComparator);
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItemsByCommerceWarehouseId(long commerceWarehouseId) {
        return this.commerceWarehouseItemPersistence.findByCommerceWarehouseId(commerceWarehouseId);
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItemsByCPI_CPIU(long cProductId, String cpInstanceUuid) {
        return this.commerceWarehouseItemPersistence.findByCPI_CPIU(cProductId, cpInstanceUuid);
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItemsByCPI_CPIU(long cProductId, String cpInstanceUuid, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        return this.commerceWarehouseItemPersistence.findByCPI_CPIU(cProductId, cpInstanceUuid, start, end);
    }

    @Deprecated
    public int getCommerceWarehouseItemsCount(long cpInstanceId) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return 0;
        }
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpInstance.getCPDefinitionId());
        if (cpDefinition == null) {
            return 0;
        }
        return this.commerceWarehouseItemLocalService.getCommerceWarehouseItemsCount(cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid());
    }

    @Deprecated
    public int getCommerceWarehouseItemsCount(long cProductId, String cpInstanceUuid) {
        return this.commerceWarehouseItemPersistence.countByCPI_CPIU(cProductId, cpInstanceUuid);
    }

    public int getCPInstanceQuantity(long cpInstanceId) {
        int quantity = 0;
        List<CommerceWarehouseItem> commerceWarehouseItems = this.getCommerceWarehouseItems(cpInstanceId);
        for (CommerceWarehouseItem commerceWarehouseItem : commerceWarehouseItems) {
            quantity += commerceWarehouseItem.getQuantity();
        }
        return quantity;
    }

    public CommerceWarehouseItem updateCommerceWarehouseItem(long commerceWarehouseItemId, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemPersistence.findByPrimaryKey(commerceWarehouseItemId);
        commerceWarehouseItem.setQuantity(quantity);
        this.commerceWarehouseItemPersistence.update((BaseModel)commerceWarehouseItem);
        return commerceWarehouseItem;
    }
}

