/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.starter;

import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.service.CommerceCountryLocalService;
import com.liferay.commerce.service.CommerceRegionLocalService;
import com.liferay.commerce.starter.CommerceRegionsStarter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.region.starter.key=840"}, service={CommerceRegionsStarter.class})
public class USACommerceRegionsStarter
implements CommerceRegionsStarter {
    public static final int USA_NUMERIC_ISO_CODE = 840;
    @Reference
    private CommerceCountryLocalService _commerceCountryLocalService;
    @Reference
    private CommerceRegionLocalService _commerceRegionLocalService;
    @Reference
    private JSONFactory _jsonFactory;

    public CommerceCountry getCommerceCountry(long groupId) throws PortalException {
        return this._commerceCountryLocalService.fetchCommerceCountry(groupId, 840);
    }

    public JSONArray getCommerceRegionsJSONArray() throws Exception {
        Class<?> clazz = this.getClass();
        String layoutsPath = "com/liferay/commerce/internal/usa.json";
        String regionsJSON = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)layoutsPath, (boolean)false);
        return this._jsonFactory.createJSONArray(regionsJSON);
    }

    public void start(ServiceContext serviceContext) throws Exception {
        CommerceCountry commerceCountry = this.getCommerceCountry(serviceContext.getScopeGroupId());
        if (commerceCountry == null) {
            return;
        }
        JSONArray jsonArray = this.getCommerceRegionsJSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String code = jsonObject.getString("code");
            String name = jsonObject.getString("name");
            double priority = jsonObject.getDouble("priority");
            this._commerceRegionLocalService.addCommerceRegion(commerceCountry.getCommerceCountryId(), name, code, priority, true, serviceContext);
        }
    }
}

