/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.context;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCouponCodeHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.model.CPRule;
import com.liferay.commerce.product.service.CPRuleLocalService;
import com.liferay.commerce.user.segment.util.CommerceUserSegmentHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class CommerceContextHttpImpl
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(CommerceContextHttpImpl.class);
    private CommerceAccount _commerceAccount;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final CommerceAccountHelper _commerceAccountHelper;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private final CommerceDiscountCouponCodeHelper _commerceDiscountCouponCodeHelper;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderHttpHelper _commerceOrderHttpHelper;
    private Optional<CommercePriceList> _commercePriceList;
    private final CommercePriceListLocalService _commercePriceListLocalService;
    private long[] _commerceUserSegmentEntryIds;
    private final CommerceUserSegmentHelper _commerceUserSegmentHelper;
    private final CPRuleLocalService _cpRuleLocalService;
    private List<CPRule> _cpRules;
    private final HttpServletRequest _httpServletRequest;
    private final Portal _portal;

    public CommerceContextHttpImpl(HttpServletRequest httpServletRequest, CommerceAccountHelper commerceAccountHelper, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceDiscountCouponCodeHelper commerceDiscountCouponCodeHelper, CommerceOrderHttpHelper commerceOrderHttpHelper, CommercePriceListLocalService commercePriceListLocalService, CommerceUserSegmentHelper commerceUserSegmentHelper, ConfigurationProvider configurationProvider, CPRuleLocalService cpRuleLocalService, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._commerceAccountHelper = commerceAccountHelper;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceDiscountCouponCodeHelper = commerceDiscountCouponCodeHelper;
        this._commerceOrderHttpHelper = commerceOrderHttpHelper;
        this._commercePriceListLocalService = commercePriceListLocalService;
        this._commerceUserSegmentHelper = commerceUserSegmentHelper;
        this._cpRuleLocalService = cpRuleLocalService;
        this._portal = portal;
        try {
            this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._portal.getScopeGroupId(httpServletRequest), "com.liferay.commerce.account"));
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
    }

    public CommerceAccount getCommerceAccount() throws PortalException {
        if (this._commerceAccount != null) {
            return this._commerceAccount;
        }
        this._commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(this._httpServletRequest);
        return this._commerceAccount;
    }

    public CommerceCurrency getCommerceCurrency() throws PortalException {
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        long groupId = this._portal.getScopeGroupId(this._httpServletRequest);
        this._commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(groupId);
        return this._commerceCurrency;
    }

    public CommerceOrder getCommerceOrder() throws PortalException {
        if (this._commerceOrder != null) {
            return this._commerceOrder;
        }
        this._commerceOrder = this._commerceOrderHttpHelper.getCurrentCommerceOrder(this._httpServletRequest);
        return this._commerceOrder;
    }

    public Optional<CommercePriceList> getCommercePriceList() throws PortalException {
        if (this._commercePriceList != null) {
            return this._commercePriceList;
        }
        long groupId = this._portal.getScopeGroupId(this._httpServletRequest);
        CommerceAccount commerceAccount = this.getCommerceAccount();
        if (commerceAccount == null) {
            return Optional.empty();
        }
        this._commercePriceList = this._commercePriceListLocalService.getCommercePriceList(groupId, commerceAccount.getCommerceAccountId(), this.getCommerceUserSegmentEntryIds());
        return this._commercePriceList;
    }

    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    public long[] getCommerceUserSegmentEntryIds() throws PortalException {
        if (this._commerceUserSegmentEntryIds != null) {
            return this._commerceUserSegmentEntryIds;
        }
        this._commerceUserSegmentEntryIds = this._commerceUserSegmentHelper.getCommerceUserSegmentIds(this._httpServletRequest);
        return this._commerceUserSegmentEntryIds;
    }

    public String getCouponCode() throws PortalException {
        return this._commerceDiscountCouponCodeHelper.getCommerceDiscountCouponCode(this._httpServletRequest);
    }

    public List<CPRule> getCPRules() throws PortalException {
        if (this._cpRules != null) {
            return this._cpRules;
        }
        long groupId = this._portal.getScopeGroupId(this._httpServletRequest);
        this._cpRules = this._cpRuleLocalService.getCPRules(groupId, this.getCommerceUserSegmentEntryIds());
        return null;
    }

    public long getSiteGroupId() throws PortalException {
        return this._portal.getScopeGroupId(this._httpServletRequest);
    }

    public long getUserId() {
        return this._portal.getUserId(this._httpServletRequest);
    }
}

