/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.exception.GuestCartItemMaxAllowedException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.base.CommerceOrderItemLocalServiceBaseImpl;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CommerceOrderItemLocalServiceImpl
extends CommerceOrderItemLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};
    @ServiceReference(type=CommerceOrderConfiguration.class)
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @ServiceReference(type=CommerceOrderValidatorRegistry.class)
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @ServiceReference(type=CommerceProductPriceCalculation.class)
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CPInstanceLocalService.class)
    private CPInstanceLocalService _cpInstanceLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        CPDefinition cpDefinition = null;
        if (cpInstance != null) {
            cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
            if (Validator.isNull((String)json) || json.equals("[]")) {
                json = cpInstance.getJson();
            }
        }
        this.validate(serviceContext.getLocale(), commerceOrder, cpDefinition, cpInstance, quantity);
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(cpInstanceId, quantity, false, commerceContext);
        CommerceMoney unitPrice = commerceProductPrice.getUnitPrice();
        CommerceMoney finalPrice = commerceProductPrice.getFinalPrice();
        long commerceOrderItemId = this.counterLocalService.increment();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.create(commerceOrderItemId);
        commerceOrderItem.setGroupId(commerceOrder.getGroupId());
        commerceOrderItem.setCompanyId(user.getCompanyId());
        commerceOrderItem.setUserId(user.getUserId());
        commerceOrderItem.setUserName(user.getFullName());
        commerceOrderItem.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderItem.setCProductId(cpDefinition.getCProductId());
        commerceOrderItem.setCPInstanceId(cpInstanceId);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setUnitPrice(unitPrice.getPrice());
        commerceOrderItem.setFinalPrice(finalPrice.getPrice());
        commerceOrderItem.setNameMap(cpDefinition.getNameMap());
        commerceOrderItem.setSku(cpInstance.getSku());
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue());
        boolean subscription = cpDefinition.isSubscriptionEnabled();
        if (cpInstance.isOverrideSubscriptionInfo()) {
            subscription = cpInstance.isSubscriptionEnabled();
        }
        commerceOrderItem.setSubscription(subscription);
        this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        return commerceOrderItem;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem) throws PortalException {
        this.commerceOrderItemPersistence.remove((BaseModel)commerceOrderItem);
        this.expandoRowLocalService.deleteRows(commerceOrderItem.getCommerceOrderItemId());
        return commerceOrderItem;
    }

    @Override
    public CommerceOrderItem deleteCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
    }

    public void deleteCommerceOrderItems(long commerceOrderId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public void deleteCommerceOrderItemsByCPInstanceId(long cpInstanceId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCPInstanceId(cpInstanceId);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public CommerceOrderItem fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        return this.commerceOrderItemPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemFinder.findByAvailableQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end) {
        return this.commerceOrderItemPersistence.findByC_I(commerceOrderId, cpInstanceId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByC_I(commerceOrderId, cpInstanceId, start, end, orderByComparator);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) {
        return this.commerceOrderItemFinder.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public int getCommerceWarehouseItemQuantity(long commerceOrderItemId, long commerceWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemLocalService.fetchCommerceWarehouseItem(commerceWarehouseId, commerceOrderItem.getCPInstanceId());
        if (commerceWarehouseItem == null) {
            return 0;
        }
        return commerceWarehouseItem.getQuantity();
    }

    public int getCPInstanceQuantity(long cpInstanceId, int orderStatus) {
        return this.commerceOrderItemFinder.getCPInstanceQuantity(cpInstanceId, orderStatus);
    }

    public List<CommerceOrderItem> getSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.findByC_S(commerceOrderId, true);
    }

    public CommerceOrderItem incrementShippedQuantity(long commerceOrderItemId, int shippedQuantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        shippedQuantity = commerceOrderItem.getShippedQuantity() + shippedQuantity;
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String sku, String name, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, start, end, sort);
        searchContext.setAndSearch(andOperator);
        searchContext.setAttribute("sku", (Serializable)((Object)sku));
        searchContext.setAttribute("name", (Serializable)((Object)name));
        return this.searchCommerceOrderItems(searchContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, quantity, commerceOrderItem.getJson(), commerceContext, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(commerceOrderItem.getCPInstanceId(), quantity, false, commerceContext);
        CommerceMoney unitPrice = commerceProductPrice.getUnitPrice();
        CommerceMoney finalPrice = commerceProductPrice.getFinalPrice();
        this.validate(serviceContext.getLocale(), commerceOrderItem.getCommerceOrder(), commerceOrderItem.getCPDefinition(), commerceOrderItem.getCPInstance(), quantity);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setUnitPrice(unitPrice.getPrice());
        commerceOrderItem.setFinalPrice(finalPrice.getPrice());
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue());
        this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        return commerceOrderItem;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrice(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(commerceOrderItem.getCPInstanceId(), commerceOrderItem.getQuantity(), false, commerceContext);
        CommerceMoney unitPrice = commerceProductPrice.getUnitPrice();
        CommerceMoney finalPrice = commerceProductPrice.getFinalPrice();
        commerceOrderItem.setUnitPrice(unitPrice.getPrice());
        commerceOrderItem.setFinalPrice(finalPrice.getPrice());
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue());
        this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        return commerceOrderItem;
    }

    public CommerceOrderItem upsertCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(commerceOrderId, cpInstanceId, -1, -1);
        if (!commerceOrderItems.isEmpty()) {
            CommerceOrderItem commerceOrderItem = commerceOrderItems.get(0);
            return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceOrderItem.getQuantity() + quantity, commerceOrderItem.getJson(), commerceContext, serviceContext);
        }
        return this.addCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, 0, json, commerceContext, serviceContext);
    }

    protected SearchContext buildSearchContext(long commerceOrderId, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = new SearchContext();
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        searchContext.setAttribute("commerceOrderId", (Serializable)Long.valueOf(commerceOrderId));
        searchContext.setCompanyId(commerceOrder.getCompanyId());
        searchContext.setEnd(end);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected List<CommerceOrderItem> getCommerceOrderItems(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrderItem> commerceOrderItems = new ArrayList<CommerceOrderItem>(documents.size());
        for (Document document : documents) {
            long commerceOrderItemId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrderItem commerceOrderItem = this.fetchCommerceOrderItem(commerceOrderItemId);
            if (commerceOrderItem == null) {
                commerceOrderItems = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceOrderItem.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceOrderItems == null) continue;
            commerceOrderItems.add(commerceOrderItem);
        }
        return commerceOrderItems;
    }

    protected BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceOrderItem.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(hits);
            if (commerceOrderItems == null) continue;
            return new BaseModelSearchResult(commerceOrderItems, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(Locale locale, CommerceOrder commerceOrder, CPDefinition cpDefinition, CPInstance cpInstance, int quantity) throws PortalException {
        List commerceCartValidatorResults;
        int count;
        if (commerceOrder.getUserId() == 0L && (count = this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrder.getCommerceOrderId())) >= this._commerceOrderConfiguration.guestCartItemMaxAllowed()) {
            throw new GuestCartItemMaxAllowedException();
        }
        if (cpDefinition != null && cpInstance != null && cpDefinition.getCPDefinitionId() != cpInstance.getCPDefinitionId()) {
            throw new NoSuchCPInstanceException(StringBundler.concat((Object[])new Object[]{"CPInstance ", cpInstance.getCPInstanceId(), " belongs to a different CPDefinition than ", cpDefinition.getCPDefinitionId()}));
        }
        if (!ExportImportThreadLocal.isImportInProcess() && !(commerceCartValidatorResults = this._commerceOrderValidatorRegistry.validate(locale, commerceOrder, cpInstance, quantity)).isEmpty()) {
            throw new CommerceOrderValidatorException(commerceCartValidatorResults);
        }
    }

    private void _setCommerceOrderItemDiscountValue(CommerceOrderItem commerceOrderItem, CommerceDiscountValue commerceDiscountValue) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel1 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel1 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel1 = percentages[3];
            }
        }
        commerceOrderItem.setDiscountAmount(discountAmount);
        commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
    }
}

