/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.subscription;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionCycleEntry;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceSubscriptionCycleEntryLocalService;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryHelper;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceSubscriptionEntryHelper.class})
public class CommerceSubscriptionEntryHelperImpl
implements CommerceSubscriptionEntryHelper {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceSubscriptionCycleEntryLocalService _commerceSubscriptionCycleEntryLocalService;
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;
    @Reference
    private CounterLocalService _counterLocalService;

    public void checkCommerceSubscriptions(CommerceOrder commerceOrder) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        serviceContext.setUserId(commerceAccount.getUserId());
        List commerceOrderItems = this._commerceOrderItemLocalService.getSubscriptionCommerceOrderItems(commerceOrder.getCommerceOrderId());
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (!this._isNewSubscription(commerceOrderItem)) continue;
            this._commerceSubscriptionEntryLocalService.addCommerceSubscriptionEntry(commerceOrderItem.getCPInstanceId(), commerceOrderItem.getCommerceOrderItemId(), serviceContext);
        }
    }

    public void renewSubscriptionEntries(List<CommerceSubscriptionEntry> commerceSubscriptionEntries) throws PortalException {
        for (CommerceSubscriptionEntry commerceSubscriptionEntry : commerceSubscriptionEntries) {
            this.renewSubscriptionEntry(commerceSubscriptionEntry);
        }
    }

    public void renewSubscriptionEntry(CommerceSubscriptionEntry commerceSubscriptionEntry) throws PortalException {
        int commerceSubscriptionCycleEntriesCount;
        Date now = new Date();
        Date nextIterationDate = commerceSubscriptionEntry.getNextIterationDate();
        if (nextIterationDate.before(now) && commerceSubscriptionEntry.getSubscriptionStatus() == 0) {
            ServiceContext serviceContext = new ServiceContext();
            CommerceOrder commerceOrder = this._addCommerceOrder(commerceSubscriptionEntry, serviceContext);
            this._commerceOrderLocalService.checkoutCommerceOrder(commerceOrder.getCommerceOrderId(), null, serviceContext);
        }
        if (commerceSubscriptionEntry.getMaxSubscriptionCycles() > 0L && (long)(commerceSubscriptionCycleEntriesCount = this._commerceSubscriptionCycleEntryLocalService.getCommerceSubscriptionCycleEntriesCount(commerceSubscriptionEntry.getCommerceSubscriptionEntryId())) >= commerceSubscriptionEntry.getMaxSubscriptionCycles()) {
            this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), 3);
        }
    }

    private CommerceOrder _addCommerceOrder(CommerceSubscriptionEntry commerceSubscriptionEntry, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem oldCommerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceSubscriptionEntry.getCommerceOrderItemId());
        CommerceOrder oldOrder = oldCommerceOrderItem.getCommerceOrder();
        CommerceOrder newOrder = this._commerceOrderLocalService.addCommerceOrder(oldOrder.getGroupId(), oldOrder.getUserId(), oldOrder.getCommerceAccountId(), oldOrder.getCommerceCurrencyId(), oldOrder.getShippingAddressId(), oldOrder.getPurchaseOrderNumber());
        newOrder.setBillingAddressId(oldOrder.getBillingAddressId());
        newOrder.setCommercePaymentMethodKey(oldOrder.getCommercePaymentMethodKey());
        newOrder.setCommerceShippingMethodId(oldOrder.getCommerceShippingMethodId());
        long newCommerceOrderItemId = this._counterLocalService.increment();
        CommerceOrderItem newCommerceOrderItem = (CommerceOrderItem)oldCommerceOrderItem.clone();
        newCommerceOrderItem.setCommerceOrderItemId(newCommerceOrderItemId);
        newCommerceOrderItem.setCommerceOrderId(newOrder.getCommerceOrderId());
        newCommerceOrderItem = this._commerceOrderItemLocalService.addCommerceOrderItem(newCommerceOrderItem);
        newOrder.setSubtotal(newCommerceOrderItem.getFinalPrice());
        newOrder.setTotal(newCommerceOrderItem.getFinalPrice());
        newOrder.setPaymentStatus(1);
        newOrder.setOrderStatus(9);
        newOrder = this._commerceOrderLocalService.updateCommerceOrder(newOrder);
        ExpandoBridge expandoBridge = oldOrder.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
        serviceContext.setCompanyId(oldOrder.getCompanyId());
        serviceContext.setScopeGroupId(oldOrder.getGroupId());
        serviceContext.setUserId(oldOrder.getUserId());
        this._commerceSubscriptionCycleEntryLocalService.addCommerceSubscriptionCycleEntry(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), newCommerceOrderItemId, true);
        return newOrder;
    }

    private boolean _isNewSubscription(CommerceOrderItem commerceOrderItem) {
        CommerceSubscriptionCycleEntry commerceSubscriptionCycleEntry = this._commerceSubscriptionCycleEntryLocalService.fetchCommerceSubscriptionCycleEntryByCommerceOrderItemId(commerceOrderItem.getCommerceOrderItemId());
        return commerceSubscriptionCycleEntry == null || !commerceSubscriptionCycleEntry.isRenew();
    }
}

