/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.configuration.CommerceSubscriptionConfiguration;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceSubscriptionCycleEntry;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.service.CommerceSubscriptionCycleEntryLocalService;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.commerce.util.comparator.CommerceSubscriptionCycleEntryCreateDateComparator;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceSubscriptionConfiguration"}, immediate=true, service={CheckCommerceSubscriptionOrderPayedMessageListener.class})
public class CheckCommerceSubscriptionOrderPayedMessageListener
extends BaseMessageListener {
    private CommerceSubscriptionConfiguration _commerceSubscriptionConfiguration;
    @Reference
    private CommerceSubscriptionCycleEntryLocalService _commerceSubscriptionCycleEntryLocalService;
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(Map<String, Object> properties) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        this._commerceSubscriptionConfiguration = (CommerceSubscriptionConfiguration)ConfigurableUtil.createConfigurable(CommerceSubscriptionConfiguration.class, properties);
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._commerceSubscriptionConfiguration.checkPayedOrderInterval(), TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        List activeCommerceSubscriptionEntries = this._commerceSubscriptionEntryLocalService.getActiveCommerceSubscriptionEntries();
        for (CommerceSubscriptionEntry commerceSubscriptionEntry : activeCommerceSubscriptionEntries) {
            CommerceSubscriptionCycleEntryCreateDateComparator commerceSubscriptionCycleEntryCreateDateComparator = new CommerceSubscriptionCycleEntryCreateDateComparator();
            List commerceSubscriptionCycleEntries = this._commerceSubscriptionCycleEntryLocalService.getCommerceSubscriptionCycleEntries(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), -1, -1, (OrderByComparator)commerceSubscriptionCycleEntryCreateDateComparator);
            CommerceSubscriptionCycleEntry firstCommerceSubscriptionCycleEntry = (CommerceSubscriptionCycleEntry)commerceSubscriptionCycleEntries.get(0);
            Date now = new Date();
            Date creationDate = firstCommerceSubscriptionCycleEntry.getCreateDate();
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(creationDate);
            calendar.add(12, this._commerceSubscriptionConfiguration.payedOrderInterval());
            CommerceOrder commerceOrder = firstCommerceSubscriptionCycleEntry.fetchCommerceOrder();
            if (commerceOrder == null || commerceOrder.getPaymentStatus() == 0 || DateUtil.compareTo((Date)calendar.getTime(), (Date)now) < 0) continue;
            this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), 1);
        }
    }
}

