/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceSubscriptionCycleEntry;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.service.base.CommerceSubscriptionCycleEntryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceSubscriptionCycleEntryLocalServiceImpl
extends CommerceSubscriptionCycleEntryLocalServiceBaseImpl {
    @ServiceReference(type=CommerceNotificationHelper.class)
    private CommerceNotificationHelper _commerceNotificationHelper;

    public CommerceSubscriptionCycleEntry addCommerceSubscriptionCycleEntry(long commerceSubscriptionEntryId, long commerceOrderItemId, boolean renew) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        long commerceSubscriptionCycleEntryId = this.counterLocalService.increment();
        CommerceSubscriptionCycleEntry commerceSubscriptionCycleEntry = this.commerceSubscriptionCycleEntryPersistence.create(commerceSubscriptionCycleEntryId);
        commerceSubscriptionCycleEntry.setGroupId(commerceSubscriptionEntry.getGroupId());
        commerceSubscriptionCycleEntry.setCompanyId(commerceSubscriptionEntry.getCompanyId());
        commerceSubscriptionCycleEntry.setUserId(commerceSubscriptionEntry.getUserId());
        commerceSubscriptionCycleEntry.setUserName(commerceSubscriptionEntry.getUserName());
        commerceSubscriptionCycleEntry.setCommerceSubscriptionEntryId(commerceSubscriptionEntryId);
        commerceSubscriptionCycleEntry.setCommerceOrderItemId(commerceOrderItemId);
        commerceSubscriptionCycleEntry.setRenew(renew);
        this.commerceSubscriptionCycleEntryPersistence.update((BaseModel)commerceSubscriptionCycleEntry);
        if (renew) {
            this.commerceSubscriptionEntryLocalService.updateCommerceSubscriptionEntryIterationDates(commerceSubscriptionEntryId, commerceSubscriptionCycleEntry.getCreateDate());
        } else {
            this.reindexCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        }
        this._commerceNotificationHelper.sendNotifications(commerceSubscriptionCycleEntry.getGroupId(), "subscription-renewed", (Object)commerceSubscriptionCycleEntry);
        return commerceSubscriptionCycleEntry;
    }

    public CommerceSubscriptionCycleEntry fetchCommerceSubscriptionCycleEntryByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceSubscriptionCycleEntryPersistence.fetchByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceSubscriptionCycleEntry> getCommerceSubscriptionCycleEntries(long commerceSubscriptionEntryId) {
        return this.commerceSubscriptionCycleEntryPersistence.findBycommerceSubscriptionEntryId(commerceSubscriptionEntryId);
    }

    public List<CommerceSubscriptionCycleEntry> getCommerceSubscriptionCycleEntries(long commerceSubscriptionEntryId, int start, int end, OrderByComparator<CommerceSubscriptionCycleEntry> orderByComparator) {
        return this.commerceSubscriptionCycleEntryPersistence.findBycommerceSubscriptionEntryId(commerceSubscriptionEntryId, start, end, orderByComparator);
    }

    public int getCommerceSubscriptionCycleEntriesCount(long commerceSubscriptionEntryId) {
        return this.commerceSubscriptionCycleEntryPersistence.countBycommerceSubscriptionEntryId(commerceSubscriptionEntryId);
    }

    protected void reindexCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceSubscriptionEntry.class);
        indexer.reindex(CommerceSubscriptionEntry.class.getName(), commerceSubscriptionEntryId);
    }
}

